/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Log
implements IApplyInPlace {
    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int i;
        double scale = 256.0 / Math.log(256.0);
        if (fastBitmap.isGrayscale()) {
            byte[] pixels = fastBitmap.getGrayData();
            for (i = 0; i < pixels.length; ++i) {
                double v = pixels[i] & 0xFF;
                if ((v = Math.log(1.0 + v) * scale) < 0.0) {
                    v = 0.0;
                }
                if (v > 255.0) {
                    v = 255.0;
                }
                pixels[i] = (byte)v;
            }
        }
        if (fastBitmap.isRGB()) {
            int[] pixelsRGB = fastBitmap.getRGBData();
            for (i = 0; i < pixelsRGB.length; ++i) {
                double r = pixelsRGB[i] >> 16 & 0xFF;
                double g = pixelsRGB[i] >> 8 & 0xFF;
                double b = pixelsRGB[i] & 0xFF;
                r = Math.log(r + 1.0) * scale;
                g = Math.log(g + 1.0) * scale;
                b = Math.log(b + 1.0) * scale;
                if (r < 0.0) {
                    r = 0.0;
                }
                if (r > 255.0) {
                    r = 255.0;
                }
                if (g < 0.0) {
                    g = 0.0;
                }
                if (g > 255.0) {
                    g = 255.0;
                }
                if (b < 0.0) {
                    b = 0.0;
                }
                if (b > 255.0) {
                    b = 255.0;
                }
                pixelsRGB[i] = (int)r << 16 | (int)g << 8 | (int)b;
            }
        }
    }
}

