/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Core.IntRange;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class LevelsLinear
implements IApplyInPlace {
    private IntRange inRed = new IntRange(0, 255);
    private IntRange inGreen = new IntRange(0, 255);
    private IntRange inBlue = new IntRange(0, 255);
    private IntRange inGray = new IntRange(0, 255);
    private IntRange outRed = new IntRange(0, 255);
    private IntRange outGreen = new IntRange(0, 255);
    private IntRange outBlue = new IntRange(0, 255);
    private IntRange outGray = new IntRange(0, 255);
    private int[] mapRed = new int[256];
    private int[] mapGreen = new int[256];
    private int[] mapBlue = new int[256];
    private int[] mapGray = new int[256];

    public IntRange getInBlue() {
        return this.inBlue;
    }

    public void setInBlue(IntRange inBlue) {
        this.inBlue = inBlue;
        this.CalculateMap(inBlue, this.outBlue, this.mapBlue);
    }

    public IntRange getInGray() {
        return this.inGray;
    }

    public void setInGray(IntRange inGray) {
        this.inGray = inGray;
        this.CalculateMap(inGray, this.outGray, this.mapGray);
    }

    public IntRange getInGreen() {
        return this.inGreen;
    }

    public void setInGreen(IntRange inGreen) {
        this.inGreen = inGreen;
        this.CalculateMap(inGreen, this.outGreen, this.mapGreen);
    }

    public IntRange getInRed() {
        return this.inRed;
    }

    public void setInRed(IntRange inRed) {
        this.inRed = inRed;
        this.CalculateMap(inRed, this.outRed, this.mapRed);
    }

    public IntRange getOutBlue() {
        return this.outBlue;
    }

    public void setOutBlue(IntRange outBlue) {
        this.outBlue = outBlue;
        this.CalculateMap(this.inBlue, outBlue, this.mapBlue);
    }

    public IntRange getOutGray() {
        return this.outGray;
    }

    public void setOutGray(IntRange outGray) {
        this.outGray = outGray;
        this.CalculateMap(this.inGray, outGray, this.mapGray);
    }

    public IntRange getOutGreen() {
        return this.outGreen;
    }

    public void setOutGreen(IntRange outGreen) {
        this.outGreen = outGreen;
        this.CalculateMap(this.inGreen, outGreen, this.mapGreen);
    }

    public IntRange getOutRed() {
        return this.outRed;
    }

    public void setOutRed(IntRange outRed) {
        this.outRed = outRed;
        this.CalculateMap(this.inRed, outRed, this.mapRed);
    }

    public void setInRGB(IntRange inRGB) {
        this.inRed = inRGB;
        this.inGreen = inRGB;
        this.inBlue = inRGB;
        this.CalculateMap(inRGB, this.outRed, this.mapRed);
        this.CalculateMap(inRGB, this.outGreen, this.mapGreen);
        this.CalculateMap(inRGB, this.outBlue, this.mapBlue);
    }

    public void setOutRGB(IntRange outRGB) {
        this.outRed = outRGB;
        this.outGreen = outRGB;
        this.outBlue = outRGB;
        this.CalculateMap(this.inRed, outRGB, this.mapRed);
        this.CalculateMap(this.inGreen, outRGB, this.mapGreen);
        this.CalculateMap(this.inBlue, outRGB, this.mapBlue);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int size = fastBitmap.getSize();
        if (fastBitmap.isGrayscale()) {
            this.CalculateMap(this.inGray, this.outGray, this.mapGray);
            for (int i = 0; i < size; ++i) {
                fastBitmap.setGray(i, this.mapGray[fastBitmap.getGray(i)]);
            }
        } else {
            this.CalculateMap(this.inRed, this.outRed, this.mapRed);
            this.CalculateMap(this.inGreen, this.outGreen, this.mapGreen);
            this.CalculateMap(this.inBlue, this.outBlue, this.mapBlue);
            for (int i = 0; i < size; ++i) {
                int r = this.mapRed[fastBitmap.getRed(i)];
                int g = this.mapGreen[fastBitmap.getGreen(i)];
                int b = this.mapBlue[fastBitmap.getBlue(i)];
                fastBitmap.setRGB(i, r, g, b);
            }
        }
    }

    private void CalculateMap(IntRange inRange, IntRange outRange, int[] map) {
        double k = 0.0;
        double b = 0.0;
        if (inRange.getMax() != inRange.getMin()) {
            k = (double)(outRange.getMax() - outRange.getMin()) / (double)(inRange.getMax() - inRange.getMin());
            b = (double)outRange.getMin() - k * (double)inRange.getMin();
        }
        for (int i = 0; i < 256; ++i) {
            int v = i;
            v = v >= inRange.getMax() ? outRange.getMax() : (v <= inRange.getMin() ? outRange.getMin() : (int)(k * (double)v + b));
            map[i] = v;
        }
    }
}

