/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters.Integral;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.IntegralImage;

public class IntegralMean
implements IApplyInPlace {
    private int radius;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = Math.max(1, radius);
    }

    public IntegralMean() {
        this(1);
    }

    public IntegralMean(int radius) {
        this.setRadius(radius);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            IntegralImage ii = new IntegralImage(fastBitmap);
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    int v = (int)ii.getRectangleMean(i, j, this.radius);
                    fastBitmap.setGray(i, j, fastBitmap.clampValues(v, 0, 255));
                }
            }
        } else {
            throw new IllegalArgumentException("IntegralMean only works in grayscale images.");
        }
    }
}

