/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Core.IntRange;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.FourierTransform;
import Catalano.Imaging.Filters.FrequencyFilter;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Math.ComplexNumber;

public class HomomorphicFilter
implements IApplyInPlace {
    private IntRange range;

    public HomomorphicFilter() {
    }

    public HomomorphicFilter(int min, int max) {
        this.range = new IntRange(min, max);
    }

    public HomomorphicFilter(IntRange range) {
        this.range = range;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        FourierTransform ft = new FourierTransform(fastBitmap);
        ComplexNumber[][] complex = ft.getData();
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        for (int x = 0; x < height; ++x) {
            for (int y = 0; y < width; ++y) {
                complex[x][y].real = Math.log(complex[x][y].real + 1.0);
            }
        }
        ft.setData(complex);
        ft.Forward();
        FrequencyFilter freq = new FrequencyFilter(this.range);
        freq.ApplyInPlace(ft);
        ft.Backward();
        complex = ft.getData();
        for (int x = 0; x < height; ++x) {
            for (int y = 0; y < width; ++y) {
                complex[x][y].real = Math.exp(complex[x][y].real - 1.0);
            }
        }
        ft.setData(complex);
        fastBitmap.setImage(ft.toFastBitmap());
    }
}

