/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class HistogramStretch
implements IApplyInPlace {
    private int max;
    private int min;

    public HistogramStretch() {
        this.max = 255;
        this.min = 0;
    }

    public HistogramStretch(int min, int max) {
        this.min = Math.max(min, 0);
        this.max = Math.min(max, 255);
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = Math.min(max, 255);
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = Math.max(min, 0);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int size = fastBitmap.getSize();
        if (fastBitmap.isGrayscale()) {
            float grayMax = this.getMaxGray(fastBitmap);
            float grayMin = this.getMinGray(fastBitmap);
            for (int x = 0; x < size; ++x) {
                float gray = fastBitmap.getGray(x);
                float stretch = (gray - grayMin) / (grayMax - grayMin) * (float)(this.max - this.min) + (float)this.min;
                fastBitmap.setGray(x, (int)stretch);
            }
        } else {
            float[] colorMax = this.getMaxRGB(fastBitmap);
            float[] colorMin = this.getMinRGB(fastBitmap);
            for (int x = 0; x < size; ++x) {
                float r = fastBitmap.getRed(x);
                float g = fastBitmap.getGreen(x);
                float b = fastBitmap.getBlue(x);
                float stretchRed = (r - colorMin[0]) / (colorMax[0] - colorMin[0]) * (float)(this.max - this.min) + (float)this.min;
                float stretchGreen = (g - colorMin[1]) / (colorMax[1] - colorMin[1]) * (float)(this.max - this.min) + (float)this.min;
                float stretchBlue = (b - colorMin[2]) / (colorMax[2] - colorMin[2]) * (float)(this.max - this.min) + (float)this.min;
                fastBitmap.setRGB(x, (int)stretchRed, (int)stretchGreen, (int)stretchBlue);
            }
        }
    }

    private int getMaxGray(FastBitmap fb) {
        int size = fb.getSize();
        int max = 0;
        for (int i = 0; i < size; ++i) {
            if (fb.getGray(i) <= max) continue;
            max = fb.getGray(i);
        }
        return max;
    }

    private int getMinGray(FastBitmap fb) {
        int size = fb.getSize();
        int min = 255;
        for (int i = 0; i < size; ++i) {
            if (fb.getGray(i) >= min) continue;
            min = fb.getGray(i);
        }
        return min;
    }

    private float[] getMaxRGB(FastBitmap fb) {
        float[] color = new float[3];
        int size = fb.getSize();
        int maxR = 0;
        int maxG = 0;
        int maxB = 0;
        for (int i = 0; i < size; ++i) {
            if (fb.getRed(i) > maxR) {
                maxR = fb.getRed(i);
            }
            if (fb.getGreen(i) > maxG) {
                maxG = fb.getGreen(i);
            }
            if (fb.getBlue(i) <= maxB) continue;
            maxB = fb.getBlue(i);
        }
        color[0] = maxR;
        color[1] = maxG;
        color[2] = maxB;
        return color;
    }

    private float[] getMinRGB(FastBitmap fb) {
        float[] color = new float[3];
        int size = fb.getSize();
        int minR = 255;
        int minG = 255;
        int minB = 255;
        for (int i = 0; i < size; ++i) {
            if (fb.getRed(i) < minR) {
                minR = fb.getRed(i);
            }
            if (fb.getGreen(i) < minG) {
                minG = fb.getGreen(i);
            }
            if (fb.getBlue(i) >= minB) continue;
            minB = fb.getBlue(i);
        }
        color[0] = minR;
        color[1] = minG;
        color[2] = minB;
        return color;
    }
}

