/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.ImageStatistics;
import Catalano.Statistics.Histogram;

public class HistogramMatching
implements IApplyInPlace {
    private int[] gray;
    private int[] red;
    private int[] green;
    private int[] blue;

    public HistogramMatching(FastBitmap reference) {
        this.Init(reference);
    }

    private void Init(FastBitmap reference) {
        ImageStatistics stat = new ImageStatistics(reference);
        if (reference.isGrayscale()) {
            this.gray = stat.getHistogramGray().getValues();
        }
        if (reference.isRGB()) {
            this.red = stat.getHistogramRed().getValues();
            this.green = stat.getHistogramGreen().getValues();
            this.blue = stat.getHistogramBlue().getValues();
        }
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        ImageStatistics stat = new ImageStatistics(fastBitmap);
        if (fastBitmap.isGrayscale()) {
            int[] fGray = stat.getHistogramGray().getValues();
            int[] mh = Histogram.MatchHistograms(fGray, this.gray);
            int size = fastBitmap.getSize();
            for (int i = 0; i < size; ++i) {
                int g = fastBitmap.getGray(i);
                g = mh[g];
                fastBitmap.setGray(i, g);
            }
        } else if (fastBitmap.isRGB()) {
            int[] fRed = stat.getHistogramRed().getValues();
            int[] fGreen = stat.getHistogramGreen().getValues();
            int[] fBlue = stat.getHistogramBlue().getValues();
            int[] mhR = Histogram.MatchHistograms(fRed, this.red);
            int[] mhG = Histogram.MatchHistograms(fGreen, this.green);
            int[] mhB = Histogram.MatchHistograms(fBlue, this.blue);
            int size = fastBitmap.getSize();
            for (int i = 0; i < size; ++i) {
                int r = fastBitmap.getRed(i);
                int g = fastBitmap.getGreen(i);
                int b = fastBitmap.getBlue(i);
                r = mhR[r];
                g = mhG[g];
                b = mhB[b];
                fastBitmap.setRGB(i, r, g, b);
            }
        } else {
            throw new IllegalArgumentException("Histogram Matching only works with Grayscale and RGB images.");
        }
    }
}

