/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class GradientMap
implements IApplyInPlace {
    private FastBitmap gradient;
    private int[][] lut;
    private boolean useLut = false;
    private boolean invert = false;

    public FastBitmap getGradient() {
        return this.gradient;
    }

    public void setGradient(FastBitmap gradient) {
        this.gradient = gradient;
        this.useLut = false;
    }

    public int[][] getLut() {
        return this.lut;
    }

    public void setLut(int[][] lut) {
        this.lut = lut;
        this.useLut = true;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    public GradientMap(FastBitmap gradient) {
        this.gradient = gradient;
    }

    public GradientMap(int[][] lut) {
        this(lut, false);
    }

    public GradientMap(int[][] lut, boolean invert) {
        this.setLut(lut);
        this.invert = invert;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            if (!this.useLut) {
                this.lut = this.LUT(this.gradient);
            }
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            fastBitmap.toRGB();
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    int r = fastBitmap.getRed(i, j);
                    if (!this.invert) {
                        fastBitmap.setRGB(i, j, this.lut[r][1], this.lut[r][2], this.lut[r][3]);
                        continue;
                    }
                    fastBitmap.setRGB(i, j, this.lut[255 - r][1], this.lut[255 - r][2], this.lut[255 - r][3]);
                }
            }
        } else {
            throw new IllegalArgumentException("Gradient Map only works in grayscale images.");
        }
    }

    private int[][] LUT(FastBitmap gradient) {
        int[][] lut = new int[256][3];
        if (gradient.getWidth() == 256) {
            for (int j = 0; j < 256; ++j) {
                lut[j][0] = gradient.getRed(0, j);
                lut[j][1] = gradient.getGreen(0, j);
                lut[j][2] = gradient.getBlue(0, j);
            }
        } else {
            throw new IllegalArgumentException("Gradient Map needs at least a gradient image with 1 row and exactly 256 columns.");
        }
        return lut;
    }
}

