/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class ConservativeSmoothing
implements IApplyInPlace {
    private int radius = 1;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = Math.max(1, radius);
    }

    public ConservativeSmoothing() {
    }

    public ConservativeSmoothing(int radius) {
        this.setRadius(radius);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        int lines = this.CalcLines(this.radius);
        FastBitmap copy = new FastBitmap(fastBitmap);
        if (fastBitmap.isRGB()) {
            for (int x = 0; x < height; ++x) {
                for (int y = 0; y < width; ++y) {
                    int minB = 255;
                    int minG = 255;
                    int minR = 255;
                    int maxB = 0;
                    int maxG = 0;
                    int maxR = 0;
                    for (int i = 0; i < lines; ++i) {
                        int Xline = x + (i - this.radius);
                        for (int j = 0; j < lines; ++j) {
                            int Yline = y + (j - this.radius);
                            if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width || i == j) continue;
                            if (copy.getRed(Xline, Yline) > maxR) {
                                maxR = copy.getRed(Xline, Yline);
                            }
                            if (copy.getGreen(Xline, Yline) > maxG) {
                                maxG = copy.getGreen(Xline, Yline);
                            }
                            if (copy.getBlue(Xline, Yline) > maxB) {
                                maxB = copy.getBlue(Xline, Yline);
                            }
                            if (copy.getRed(Xline, Yline) < minR) {
                                minR = copy.getRed(Xline, Yline);
                            }
                            if (copy.getGreen(Xline, Yline) < minG) {
                                minG = copy.getGreen(Xline, Yline);
                            }
                            if (copy.getBlue(Xline, Yline) >= minB) continue;
                            minB = copy.getBlue(Xline, Yline);
                        }
                    }
                    int r = copy.getRed(x, y);
                    int g = copy.getGreen(x, y);
                    int b = copy.getBlue(x, y);
                    if (r > maxR) {
                        r = maxR;
                    }
                    if (g > maxG) {
                        g = maxG;
                    }
                    if (b > maxB) {
                        b = maxB;
                    }
                    if (r < minR) {
                        r = minR;
                    }
                    if (g < minG) {
                        g = minG;
                    }
                    if (b < minB) {
                        b = minB;
                    }
                    fastBitmap.setRGB(x, y, r, g, b);
                }
            }
        } else {
            for (int x = 0; x < height; ++x) {
                for (int y = 0; y < width; ++y) {
                    int minG = 255;
                    int maxG = 0;
                    for (int i = 0; i < lines; ++i) {
                        int Xline = x + (i - this.radius);
                        for (int j = 0; j < lines; ++j) {
                            int Yline = y + (j - this.radius);
                            if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width || i == j) continue;
                            if (copy.getGray(Xline, Yline) > maxG) {
                                maxG = copy.getGray(Xline, Yline);
                            }
                            if (copy.getGray(Xline, Yline) >= minG) continue;
                            minG = copy.getGray(Xline, Yline);
                        }
                    }
                    int g = copy.getGray(x, y);
                    if (g > maxG) {
                        g = maxG;
                    }
                    if (g < minG) {
                        g = minG;
                    }
                    fastBitmap.setGray(x, y, g);
                }
            }
        }
    }

    private int CalcLines(int radius) {
        return radius * 2 + 1;
    }
}

