/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Maximum;
import Catalano.Imaging.Filters.Minimum;
import Catalano.Imaging.IApplyInPlace;

public class BernsenThreshold
implements IApplyInPlace {
    private int radius = 15;
    private double c = 15.0;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = Math.max(1, radius);
    }

    public double getContrastThreshold() {
        return this.c;
    }

    public void setContrastThreshold(double c) {
        this.c = Math.max(0.0, c);
    }

    public BernsenThreshold() {
    }

    public BernsenThreshold(int radius) {
        this.radius = radius;
    }

    public BernsenThreshold(int radius, double contrastThreshold) {
        this.radius = radius;
        this.c = contrastThreshold;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            FastBitmap max = new FastBitmap(fastBitmap);
            FastBitmap min = new FastBitmap(fastBitmap);
            Maximum maximum = new Maximum(this.radius);
            maximum.applyInPlace(max);
            Minimum minimum = new Minimum(this.radius);
            minimum.applyInPlace(min);
            int size = fastBitmap.getSize();
            for (int i = 0; i < size; ++i) {
                double localContrast = max.getGray(i) - min.getGray(i);
                double midG = (max.getGray(i) + min.getGray(i)) / 2;
                int g = fastBitmap.getGray(i);
                g = localContrast < this.c ? (midG >= 128.0 ? 255 : 0) : ((double)g >= midG ? 255 : 0);
                fastBitmap.setGray(i, g);
            }
        } else {
            throw new IllegalArgumentException("Bernsen Threshold only works in grayscale images.");
        }
    }
}

