/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters.Artistic;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Artistic.Blend;
import Catalano.Imaging.Filters.GaussianBoxBlur;
import Catalano.Imaging.Filters.OtsuThreshold;
import Catalano.Imaging.Filters.RosinThreshold;
import Catalano.Imaging.Filters.SISThreshold;
import Catalano.Imaging.Filters.Threshold;
import Catalano.Imaging.IApplyInPlace;

public class SpecularBloom
implements IApplyInPlace {
    private AdaptiveThreshold adaptive = AdaptiveThreshold.Rosin;
    private int threshold = 180;
    private int radius = 20;
    private boolean auto = true;

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = Math.max(1, Math.min(255, threshold));
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = Math.max(1, radius);
    }

    public SpecularBloom() {
    }

    public SpecularBloom(int threshold, int radius) {
        this.threshold = threshold;
        this.radius = radius;
        this.auto = false;
    }

    public SpecularBloom(AdaptiveThreshold threshold, int radius) {
        this.adaptive = threshold;
        this.radius = radius;
        this.auto = true;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        FastBitmap layerA = new FastBitmap(fastBitmap);
        layerA.toGrayscale();
        switch (this.adaptive) {
            case Otsu: {
                OtsuThreshold o = new OtsuThreshold();
                o.applyInPlace(layerA);
                break;
            }
            case Rosin: {
                RosinThreshold r = new RosinThreshold();
                r.applyInPlace(layerA);
                break;
            }
            case Sis: {
                SISThreshold s = new SISThreshold();
                s.applyInPlace(layerA);
            }
        }
        if (!this.auto) {
            Threshold t = new Threshold(this.threshold);
            t.applyInPlace(layerA);
        }
        layerA.toRGB();
        GaussianBoxBlur fgb = new GaussianBoxBlur(this.radius);
        fgb.applyInPlace(layerA);
        Blend b = new Blend(layerA, Blend.Algorithm.Screen);
        b.applyInPlace(fastBitmap);
    }

    public static enum AdaptiveThreshold {
        Otsu,
        Rosin,
        Sis;

    }
}

