/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import java.util.Arrays;

public class AlphaTrimmedMean
implements IApplyInPlace {
    private int radius = 1;
    private int t = 1;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = Math.max(1, radius);
    }

    public int getT() {
        return this.t;
    }

    public void setT(int t) {
        this.t = Math.min((this.radius * 2 + 1) * (this.radius * 2 + 1) / 2, Math.max(0, t));
    }

    public AlphaTrimmedMean() {
    }

    public AlphaTrimmedMean(int radius) {
        this.setRadius(radius);
    }

    public AlphaTrimmedMean(int radius, int t) {
        this.setRadius(radius);
        this.setT(t);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        block13: {
            FastBitmap copy;
            int maxArray;
            int lines;
            int height;
            int width;
            block12: {
                width = fastBitmap.getWidth();
                height = fastBitmap.getHeight();
                lines = this.CalcLines(this.radius);
                maxArray = lines * lines;
                copy = new FastBitmap(fastBitmap);
                if (!fastBitmap.isGrayscale()) break block12;
                int[] avgL = new int[maxArray];
                for (int x = 0; x < height; ++x) {
                    for (int y = 0; y < width; ++y) {
                        int c = 0;
                        for (int i = 0; i < lines; ++i) {
                            int Xline = x + (i - this.radius);
                            for (int j = 0; j < lines; ++j) {
                                int Yline = y + (j - this.radius);
                                avgL[c] = Xline >= 0 && Xline < height && Yline >= 0 && Yline < width ? copy.getGray(Xline, Yline) : copy.getGray(x, y);
                                ++c;
                            }
                        }
                        Arrays.sort(avgL);
                        double mean = 0.0;
                        for (int i = this.t; i < c - this.t; ++i) {
                            mean += (double)avgL[i];
                        }
                        fastBitmap.setGray(x, y, (int)(mean / (double)(avgL.length - 2 * this.t)));
                    }
                }
                break block13;
            }
            if (!fastBitmap.isRGB()) break block13;
            int[] avgR = new int[maxArray];
            int[] avgG = new int[maxArray];
            int[] avgB = new int[maxArray];
            for (int x = 0; x < height; ++x) {
                for (int y = 0; y < width; ++y) {
                    int c = 0;
                    for (int i = 0; i < lines; ++i) {
                        int Xline = x + (i - this.radius);
                        for (int j = 0; j < lines; ++j) {
                            int Yline = y + (j - this.radius);
                            if (Xline >= 0 && Xline < height && Yline >= 0 && Yline < width) {
                                avgR[c] = copy.getRed(Xline, Yline);
                                avgG[c] = copy.getGreen(Xline, Yline);
                                avgB[c] = copy.getBlue(Xline, Yline);
                            } else {
                                avgR[c] = copy.getRed(x, y);
                                avgG[c] = copy.getGreen(x, y);
                                avgB[c] = copy.getBlue(x, y);
                            }
                            ++c;
                        }
                    }
                    Arrays.sort(avgR);
                    Arrays.sort(avgG);
                    Arrays.sort(avgB);
                    double meanR = 0.0;
                    double meanG = 0.0;
                    double meanB = 0.0;
                    for (int i = this.t; i < c - this.t; ++i) {
                        meanR += (double)avgR[i];
                        meanG += (double)avgG[i];
                        meanB += (double)avgB[i];
                    }
                    fastBitmap.setRGB(x, y, (int)(meanR /= (double)(avgR.length - 2 * this.t)), (int)(meanG /= (double)(avgG.length - 2 * this.t)), (int)(meanB /= (double)(avgB.length - 2 * this.t)));
                }
            }
        }
    }

    private int CalcLines(int radius) {
        return radius * 2 + 1;
    }
}

