/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Corners.FREAK;

import Catalano.Core.IntPoint;

public class FastRetinaKeypoint {
    public double x;
    public double y;
    public double scale;
    public double orientation;
    private byte[] descriptor;

    public double getOrientation() {
        return this.orientation;
    }

    public void setOrientation(double orientation) {
        this.orientation = orientation;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public byte[] getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(byte[] descriptor) {
        this.descriptor = descriptor;
    }

    public FastRetinaKeypoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public String toBinary() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.descriptor.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                boolean set = (this.descriptor[i] & 1 << j) != 0;
                sb.append(set ? "1" : "0");
            }
        }
        return sb.toString();
    }

    public String toHex() {
        StringBuilder sb = new StringBuilder(this.descriptor.length * 2);
        for (int i = 0; i < this.descriptor.length; ++i) {
            sb.append(String.format("%02X ", this.descriptor[i]));
        }
        return sb.toString();
    }

    public IntPoint toIntPoint() {
        return new IntPoint(this.x, this.y);
    }

    public boolean equals(Object obj) {
        FastRetinaKeypoint p = (FastRetinaKeypoint)obj;
        byte[] d = p.descriptor;
        for (int i = 0; i < d.length; ++i) {
            if (this.descriptor[i] == d[i]) continue;
            return false;
        }
        return true;
    }
}

