/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Dilatation
implements IApplyInPlace {
    private int radius = 0;
    private int[][] kernel;
    private FastBitmap copy;

    public Dilatation() {
        this.radius = 1;
    }

    public Dilatation(int radius) {
        this.radius = Math.max(radius, 1);
    }

    public Dilatation(int[][] kernel) {
        this.kernel = kernel;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        this.copy = new FastBitmap(fastBitmap);
        if (this.kernel == null) {
            this.createKernel(this.radius);
        }
        this.Parallel(fastBitmap);
    }

    private void Parallel(FastBitmap fastBitmap) {
        int i;
        int cores = Runtime.getRuntime().availableProcessors();
        Thread[] t = new Thread[cores];
        int part = fastBitmap.getHeight() / cores;
        int last = cores - 1;
        boolean lastThread = false;
        int startX = 0;
        for (i = 0; i < cores; ++i) {
            if (i == last) {
                lastThread = true;
            }
            t[i] = new Thread(new Run(new Share(fastBitmap, startX, startX + part, lastThread)));
            t[i].start();
            startX += part;
        }
        try {
            for (i = 0; i < cores; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void createKernel(int radius) {
        int size = radius * 2 + 1;
        this.kernel = new int[size][size];
        for (int i = 0; i < this.kernel.length; ++i) {
            for (int j = 0; j < this.kernel[0].length; ++j) {
                this.kernel[i][j] = 1;
            }
        }
    }

    private class Run
    implements Runnable {
        private Share share;

        public Run(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            int Y;
            int X;
            int j;
            int i;
            int safe = Dilatation.this.radius;
            if (this.share.lastThread) {
                safe = 0;
            }
            if (this.share.fastBitmap.isGrayscale()) {
                for (i = this.share.startX; i < this.share.endHeight; ++i) {
                    for (j = 0; j < this.share.fastBitmap.getWidth(); ++j) {
                        X = 0;
                        int max = 0;
                        for (int x = i - Dilatation.this.radius; x < i + Dilatation.this.radius + 1; ++x) {
                            Y = 0;
                            for (int y = j - Dilatation.this.radius; y < j + Dilatation.this.radius + 1; ++y) {
                                int val;
                                if (x >= 0 && x < this.share.endHeight + safe && y >= 0 && y < this.share.fastBitmap.getWidth() && (val = Dilatation.this.copy.getGray(x, y) + Dilatation.this.kernel[X][Y]) > max) {
                                    max = val;
                                }
                                ++Y;
                            }
                            ++X;
                        }
                        max = max > 255 ? 255 : max;
                        this.share.fastBitmap.setGray(i, j, max);
                    }
                }
            }
            if (this.share.fastBitmap.isRGB()) {
                for (i = this.share.startX; i < this.share.endHeight; ++i) {
                    for (j = 0; j < this.share.fastBitmap.getWidth(); ++j) {
                        X = 0;
                        int maxR = 0;
                        int maxG = 0;
                        int maxB = 0;
                        for (int x = i - Dilatation.this.radius; x < i + Dilatation.this.radius + 1; ++x) {
                            Y = 0;
                            for (int y = j - Dilatation.this.radius; y < j + Dilatation.this.radius + 1; ++y) {
                                if (x >= 0 && x < this.share.endHeight + safe && y >= 0 && y < this.share.fastBitmap.getWidth()) {
                                    int valR = Dilatation.this.copy.getRed(x, y) + Dilatation.this.kernel[X][Y];
                                    int valG = Dilatation.this.copy.getGreen(x, y) + Dilatation.this.kernel[X][Y];
                                    int valB = Dilatation.this.copy.getBlue(x, y) + Dilatation.this.kernel[X][Y];
                                    if (valR > maxR) {
                                        maxR = valR;
                                    }
                                    if (valG > maxG) {
                                        maxG = valG;
                                    }
                                    if (valB > maxB) {
                                        maxB = valB;
                                    }
                                }
                                ++Y;
                            }
                            ++X;
                        }
                        maxR = maxR > 255 ? 255 : maxR;
                        maxG = maxG > 255 ? 255 : maxG;
                        maxB = maxB > 255 ? 255 : maxB;
                        this.share.fastBitmap.setRGB(i, j, maxR, maxG, maxB);
                    }
                }
            }
        }
    }
}

