/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Filters.Maximum;
import Catalano.Imaging.Concurrent.Filters.Minimum;
import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class BernsenThreshold
implements IApplyInPlace {
    private int radius = 15;
    private double c = 15.0;
    private FastBitmap max;
    private FastBitmap min;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = Math.max(1, radius);
    }

    public double getContrastThreshold() {
        return this.c;
    }

    public void setContrastThreshold(double c) {
        this.c = Math.max(0.0, c);
    }

    public BernsenThreshold() {
    }

    public BernsenThreshold(int radius) {
        this.radius = radius;
    }

    public BernsenThreshold(int radius, double contrastThreshold) {
        this.radius = radius;
        this.c = contrastThreshold;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("Bernsen Threshold only work in grayscale images.");
        }
        this.Parallel(fastBitmap);
    }

    private void Parallel(FastBitmap fastBitmap) {
        int i;
        this.max = new FastBitmap(fastBitmap);
        this.min = new FastBitmap(fastBitmap);
        Maximum m = new Maximum(this.radius);
        m.applyInPlace(this.max);
        Minimum mm = new Minimum(this.radius);
        mm.applyInPlace(this.min);
        int cores = Runtime.getRuntime().availableProcessors();
        Thread[] t = new Thread[cores];
        int part = fastBitmap.getHeight() / cores;
        int startX = 0;
        for (i = 0; i < cores; ++i) {
            t[i] = new Thread(new Run(new Share(fastBitmap, startX, startX + part)));
            t[i].start();
            startX += part;
        }
        try {
            for (i = 0; i < cores; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class Run
    implements Runnable {
        private Share share;

        public Run(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            for (int i = this.share.startX; i < this.share.endHeight; ++i) {
                for (int j = 0; j < this.share.fastBitmap.getWidth(); ++j) {
                    double localContrast = BernsenThreshold.this.max.getGray(i, j) - BernsenThreshold.this.min.getGray(i, j);
                    double midG = (BernsenThreshold.this.max.getGray(i, j) + BernsenThreshold.this.min.getGray(i, j)) / 2;
                    int g = this.share.fastBitmap.getGray(i, j);
                    g = localContrast < BernsenThreshold.this.c ? (midG >= 128.0 ? 255 : 0) : ((double)g >= midG ? 255 : 0);
                    this.share.fastBitmap.setGray(i, j, g);
                }
            }
        }
    }
}

