/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Metaheuristics.Monoobjective;

import Catalano.Core.DoubleRange;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.BaseEvolutionaryOptimization;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.IObjectiveFunction;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.Individual;
import Catalano.Math.Tools;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class SalpSwarmAlgorithm
extends BaseEvolutionaryOptimization {
    public SalpSwarmAlgorithm() {
        this(30, 1000);
    }

    public SalpSwarmAlgorithm(int population, int generations) {
        this.populationSize = population;
        this.generations = generations;
    }

    @Override
    public void Compute(IObjectiveFunction function, List<DoubleRange> boundConstraints) {
        Random rand = new Random();
        this.minError = Double.MAX_VALUE;
        this.nEvals = 0L;
        List<Individual> pop = Individual.CreatePopulation(this.populationSize, boundConstraints, function);
        Collections.sort(pop);
        this.minError = pop.get(0).getFitness();
        this.best = Arrays.copyOf(pop.get(0).getLocation(), boundConstraints.size());
        Collections.shuffle(pop);
        for (int g = 0; g < this.generations; ++g) {
            int i;
            double c1 = 2.0 * Math.exp(-Math.pow(4 * (g + 1) / this.generations, 2.0));
            for (i = 0; i < pop.size(); ++i) {
                if (i <= pop.size() / 2) {
                    for (int j = 0; j < boundConstraints.size(); ++j) {
                        DoubleRange range = boundConstraints.get(j);
                        pop.get((int)i).getLocation()[j] = rand.nextDouble() < 0.5 ? this.best[j] + c1 * ((range.getMax() - range.getMin()) * rand.nextDouble() + range.getMin()) : this.best[j] - c1 * ((range.getMax() - range.getMin()) * rand.nextDouble() + range.getMin());
                    }
                    continue;
                }
                if (i <= pop.size() / 2 || i >= pop.size()) continue;
                double[] salp1 = pop.get(i - 1).getLocation();
                double[] salp2 = pop.get(i).getLocation();
                for (int j = 0; j < salp2.length; ++j) {
                    salp2[j] = (salp2[j] + salp1[j]) / 2.0;
                }
            }
            for (i = 0; i < pop.size(); ++i) {
                Tools.Clamp(pop.get(i).getLocation(), boundConstraints);
            }
            for (i = 0; i < pop.size(); ++i) {
                double f = function.Compute(pop.get(i).getLocation());
                pop.get(i).setFitness(f);
                ++this.nEvals;
                if (!(f < this.minError)) continue;
                this.minError = f;
                this.best = Arrays.copyOf(pop.get(i).getLocation(), boundConstraints.size());
            }
            if (this.listener == null) continue;
            this.listener.onIteration(g + 1, this.minError);
        }
    }
}

