/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Genetic.Crossover;

import Catalano.Evolutionary.Genetic.Chromosome.DoubleChromosome;
import Catalano.Evolutionary.Genetic.Chromosome.FloatChromosome;
import Catalano.Evolutionary.Genetic.Chromosome.IChromosome;
import Catalano.Evolutionary.Genetic.Crossover.ICrossover;
import Catalano.Math.Tools;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class MultiplierCrossover
implements ICrossover<IChromosome> {
    @Override
    public List<IChromosome> Compute(IChromosome chromosome1, IChromosome chromosome2) {
        if (chromosome1 instanceof FloatChromosome) {
            return this.Compute((FloatChromosome)chromosome1, (FloatChromosome)chromosome2);
        }
        if (chromosome1 instanceof DoubleChromosome) {
            return this.Compute((DoubleChromosome)chromosome1, (DoubleChromosome)chromosome2);
        }
        throw new IllegalArgumentException("Multiplier crossover only works with Double/Float chromosomes.");
    }

    @Override
    private List<IChromosome> Compute(DoubleChromosome chromosome1, DoubleChromosome chromosome2) {
        Random rand = new Random();
        DoubleChromosome c1 = (DoubleChromosome)chromosome1.Clone();
        DoubleChromosome c2 = (DoubleChromosome)chromosome2.Clone();
        double[] v1 = c1.getData();
        double[] v2 = c2.getData();
        for (int i = 0; i < v1.length; ++i) {
            v1[i] = v1[i] + rand.nextDouble() * (v1[i] - v2[i]);
            v2[i] = v2[i] + rand.nextDouble() * (v1[i] - v2[i]);
            v1[i] = Tools.Clamp(v1[i], c1.getMinValue(), c1.getMaxValue());
            v2[i] = Tools.Clamp(v2[i], c1.getMinValue(), c1.getMaxValue());
        }
        ArrayList<IChromosome> lst = new ArrayList<IChromosome>();
        lst.add(c1);
        lst.add(c2);
        return lst;
    }

    @Override
    private List<IChromosome> Compute(FloatChromosome chromosome1, FloatChromosome chromosome2) {
        Random rand = new Random();
        FloatChromosome c1 = (FloatChromosome)chromosome1.Clone();
        FloatChromosome c2 = (FloatChromosome)chromosome2.Clone();
        float[] v1 = c1.getData();
        float[] v2 = c2.getData();
        for (int i = 0; i < v1.length; ++i) {
            v1[i] = v1[i] + rand.nextFloat() * (v1[i] - v2[i]);
            v2[i] = v2[i] + rand.nextFloat() * (v1[i] - v2[i]);
            v1[i] = Tools.Clamp(v1[i], c1.getMinValue(), c1.getMaxValue());
            v2[i] = Tools.Clamp(v2[i], c1.getMinValue(), c1.getMaxValue());
        }
        ArrayList<IChromosome> lst = new ArrayList<IChromosome>();
        lst.add(c1);
        lst.add(c2);
        return lst;
    }
}

