/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Genetic.Chromosome;

import Catalano.Evolutionary.Genetic.Chromosome.ChromosomeBase;
import Catalano.Evolutionary.Genetic.Chromosome.IChromosome;
import java.util.Arrays;
import java.util.Random;

public class IntegerChromosome
extends ChromosomeBase {
    private final int size;
    private final int maxValue;
    private int[] values;

    public int[] getData() {
        return this.values;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public IntegerChromosome(int[] values, int maxValue) {
        this.size = values.length;
        this.values = values;
        this.maxValue = maxValue;
    }

    public IntegerChromosome(int size, int maxValue) {
        this.size = size;
        this.maxValue = maxValue;
        this.Generate();
    }

    @Override
    public Object getGene(int index) {
        return this.values[index];
    }

    @Override
    public void setGene(int index, Object gene) {
        this.values[index] = (Integer)gene;
    }

    @Override
    public void Generate() {
        Random rand = new Random();
        this.values = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = rand.nextInt(this.maxValue);
        }
    }

    @Override
    public IChromosome CreateNew() {
        return new IntegerChromosome(this.size, this.maxValue);
    }

    @Override
    public IChromosome Clone() {
        IntegerChromosome c = new IntegerChromosome(Arrays.copyOf(this.values, this.values.length), this.maxValue);
        c.fitness = this.fitness;
        return c;
    }

    @Override
    public int getLength() {
        return this.size;
    }

    public String toString() {
        String str = "";
        for (int i = 0; i < this.size; ++i) {
            str = str + String.valueOf(this.values[i]);
        }
        return str;
    }
}

