/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.utils;

import java.util.Collections;
import java.util.Vector;
import org.statcato.utils.HelperFunctions;

public class CategoryCounter {
    Vector<String> categories = new Vector();
    Vector<Integer> frequencies = new Vector();

    public void addCategory(String cat) {
        if (!cat.equals("")) {
            int index = this.getIndex(cat);
            if (index == -1) {
                this.categories.addElement(cat);
                this.frequencies.addElement(new Integer(0));
            } else {
                this.frequencies.setElementAt(new Integer(this.frequencies.elementAt(index) + 1), index);
            }
        }
    }

    public String getCategory(int i) {
        if (i >= 0 && i < this.categories.size()) {
            return this.categories.elementAt(i);
        }
        return null;
    }

    public Vector<String> getCategories() {
        Vector cat = (Vector)this.categories.clone();
        Collections.sort(cat);
        return cat;
    }

    public int getIndex(String cat) {
        for (int i = 0; i < this.categories.size(); ++i) {
            String x = this.categories.elementAt(i);
            if (!x.equals(cat)) continue;
            return i;
        }
        return -1;
    }

    public int getSize() {
        return this.categories.size();
    }

    public int getEqualFrequency() {
        if (this.frequencies.size() == 0) {
            return 0;
        }
        int f = this.frequencies.elementAt(0);
        for (int i = 1; i < this.frequencies.size(); ++i) {
            if (this.frequencies.elementAt(i) == f) continue;
            return -1;
        }
        return f;
    }

    public int getFrequency(String cat) {
        int index = this.getIndex(cat);
        if (index == -1) {
            return -1;
        }
        return this.frequencies.elementAt(index);
    }

    public String toString() {
        String text = "Categories: " + HelperFunctions.printVectorToString(this.categories);
        text = "\nIndices: " + HelperFunctions.printVectorToString(this.frequencies);
        return text + "\n";
    }
}

