/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential.nonparametrics;

import org.statcato.statistics.NormalProbabilityDistribution;

public class WilcoxonSignedRankPValue {
    public static final int MAX_N = 30;
    public static boolean[] calculated = new boolean[31];
    public static final int MAX_SUM = 465;
    public static int[][] sum = new int[31][466];
    public static double[][] pvalue = new double[31][466];

    public WilcoxonSignedRankPValue() {
        for (int i = 0; i <= 30; ++i) {
            WilcoxonSignedRankPValue.calculated[i] = false;
            for (int j = 0; j <= 465; ++j) {
                WilcoxonSignedRankPValue.sum[i][j] = 0;
                WilcoxonSignedRankPValue.pvalue[i][j] = 0.0;
            }
        }
        WilcoxonSignedRankPValue.sum[1][0] = 1;
        WilcoxonSignedRankPValue.sum[1][1] = 1;
        WilcoxonSignedRankPValue.pvalue[1][0] = 0.5;
        WilcoxonSignedRankPValue.pvalue[1][1] = 1.0;
        WilcoxonSignedRankPValue.calculated[1] = true;
    }

    public static double getPValue(double s, int n) {
        if (n <= 30) {
            if (!calculated[n]) {
                for (int i = 2; i <= n; ++i) {
                    if (calculated[i]) continue;
                    for (int j = 0; j <= i * (i + 1) / 2; ++j) {
                        WilcoxonSignedRankPValue.sum[i][j] = j < i ? sum[i - 1][j] : sum[i - 1][j] + sum[i - 1][j - i];
                        WilcoxonSignedRankPValue.pvalue[i][j] = (double)sum[i][j] / Math.pow(2.0, i) + (j > 0 ? pvalue[i][j - 1] : 0.0);
                    }
                    WilcoxonSignedRankPValue.calculated[i] = true;
                }
            }
            return pvalue[n][(int)Math.round(s)];
        }
        NormalProbabilityDistribution dist = new NormalProbabilityDistribution(0.0, 1.0);
        double ts = (s - (double)(n * (n + 1) / 4)) / Math.sqrt(n * (n + 1) * (2 * n + 1) / 24);
        return dist.cumulativeProbability(ts);
    }

    public static double getCriticalValue(double alpha, int n) {
        if (n <= 30) {
            int max = n * (n + 1) / 2;
            for (int ranksum = 0; ranksum <= max; ++ranksum) {
                if (!(WilcoxonSignedRankPValue.getPValue(ranksum, n) >= alpha)) continue;
                return ranksum;
            }
            return max;
        }
        NormalProbabilityDistribution dist = new NormalProbabilityDistribution(0.0, 1.0);
        double z = dist.inverseCumulativeProbability(alpha);
        return z * Math.sqrt(n * (n + 1) * (2 * n + 1) / 24) + (double)(n * (n + 1) / 4);
    }
}

