/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential.nonparametrics;

import java.util.Vector;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.NormalProbabilityDistribution;
import org.statcato.utils.HelperFunctions;

public class RunsTest {
    private int n1;
    private int n2;
    private int G;
    private double significance;

    public RunsTest(int n1, int n2, int G, double significance) {
        this.significance = significance;
        this.n1 = n1;
        this.n2 = n2;
        this.G = G;
        this.significance = significance;
    }

    public RunsTest(Vector<Cell> vector, String cat1, String cat2, double significance) {
        String last = "";
        this.G = 0;
        this.n1 = 0;
        this.n2 = 0;
        this.significance = significance;
        for (Cell c : vector) {
            String data = c.toString();
            if (data.equals(cat1)) {
                ++this.n1;
            } else {
                ++this.n2;
            }
            if (data.equals(last)) continue;
            ++this.G;
            last = c.toString();
        }
    }

    public RunsTest(Vector<Double> vector, double separator, double significance) {
        this.G = 0;
        this.n1 = 0;
        this.n2 = 0;
        this.significance = significance;
        Vector<String> catVector = new Vector<String>();
        for (double value : vector) {
            if (value > separator) {
                catVector.addElement("1");
                continue;
            }
            catVector.addElement("2");
        }
        String last = "";
        for (String data : catVector) {
            if (data.equals("1")) {
                ++this.n1;
            } else {
                ++this.n2;
            }
            if (data.equals(last)) continue;
            ++this.G;
            last = data;
        }
    }

    public double testStatistic() {
        return ((double)this.G - this.mu()) / this.sigma();
    }

    public double mu() {
        return 2.0 * (double)this.n1 * (double)this.n2 / (double)(this.n1 + this.n2) + 1.0;
    }

    public double sigma() {
        return Math.sqrt(2.0 * (double)this.n1 * (double)this.n2 * (double)(2 * this.n1 * this.n2 - this.n1 - this.n2) / Math.pow(this.n1 + this.n2, 2.0) / (double)(this.n1 + this.n2 - 1));
    }

    public double pValue() {
        NormalProbabilityDistribution dist = new NormalProbabilityDistribution(0.0, 1.0);
        double p = dist.cumulativeProbability(this.testStatistic());
        return 2.0 * (p <= 0.5 ? p : 1.0 - p);
    }

    public double criticalValue() {
        NormalProbabilityDistribution dist = new NormalProbabilityDistribution(0.0, 1.0);
        return Math.abs(dist.inverseCumulativeProbability(this.significance / 2.0));
    }

    public String toString() {
        String s = "";
        s = s + "Runs Test for Randomness: <br>";
        s = s + "H<sub>0</sub>: The sequence is random.<br>";
        s = s + "H<sub>1</sub>: The sequence is not random.";
        s = s + "<table border='1'>";
        s = s + "<tr>";
        s = s + "<th>n<sub>1</sub></th><th>n<sub>2</sub></th><th>Runs</th>";
        s = s + "<th>&mu;</th><th>&sigma;</th>";
        s = s + "<th>Test Statistics z</th><th>Critical Value</th><th>p-Value</th>";
        s = s + "</tr>";
        s = s + "<td>" + this.n1 + "</td>";
        s = s + "<td>" + this.n2 + "</td>";
        s = s + "<td>" + this.G + "</td>";
        s = s + "<td>" + HelperFunctions.formatFloat(this.mu(), 3) + "</td>";
        s = s + "<td>" + HelperFunctions.formatFloat(this.sigma(), 3) + "</td>";
        s = s + "<td>" + HelperFunctions.formatFloat(this.testStatistic(), 3) + "</td>";
        s = s + "<td>&plusmn;" + HelperFunctions.formatFloat(this.criticalValue(), 3) + "</td>";
        s = s + "<td>" + HelperFunctions.formatFloat(this.pValue(), 5) + "</td>";
        s = s + "</tr>";
        s = s + "</table><br>";
        if (this.n1 <= 10 || this.n2 <= 10) {
            s = s + "* Warning: Normal approximation might not be valid for small samples.";
        }
        return s;
    }
}

