/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential;

import org.statcato.statistics.NormalProbabilityDistribution;
import org.statcato.statistics.inferential.HypothesisTest;
import org.statcato.utils.HelperFunctions;

public class HypothesisTest2Prop {
    double n1;
    double n2;
    double x1;
    double x2;
    double diff;
    double confidenceLevel;
    int testType;
    boolean pool;

    public HypothesisTest2Prop(int n1, int n2, int x1, int x2, double diff, double confidenceLevel, int testType, boolean pool) {
        this.n1 = n1;
        this.n2 = n2;
        this.x1 = x1;
        this.x2 = x2;
        this.diff = diff;
        this.confidenceLevel = confidenceLevel;
        this.testType = testType;
        this.pool = pool;
    }

    public double testStatistics() {
        if (this.pool) {
            double pBar = (this.x1 + this.x2) / (this.n1 + this.n2);
            double qBar = 1.0 - pBar;
            System.out.println("pBar = " + pBar + " qBar = " + qBar);
            return (this.x1 / this.n1 - this.x2 / this.n2 - this.diff) / Math.sqrt(pBar * qBar / this.n1 + pBar * qBar / this.n2);
        }
        double p1 = this.x1 / this.n1;
        double p2 = this.x2 / this.n2;
        return (p1 - p2 - this.diff) / Math.sqrt(p1 * (1.0 - p1) / this.n1 + p2 * (1.0 - p2) / this.n2);
    }

    public String criticalValue() {
        double alpha = 1.0 - this.confidenceLevel;
        NormalProbabilityDistribution dist = new NormalProbabilityDistribution(0.0, 1.0);
        if (this.testType == HypothesisTest.RIGHT_TAIL) {
            return HelperFunctions.formatFloat(dist.inverseCumulativeProbability(1.0 - alpha), 3);
        }
        if (this.testType == HypothesisTest.LEFT_TAIL) {
            return HelperFunctions.formatFloat(dist.inverseCumulativeProbability(alpha), 3);
        }
        return HelperFunctions.formatFloat(dist.inverseCumulativeProbability(alpha / 2.0), 3) + ", " + HelperFunctions.formatFloat(dist.inverseCumulativeProbability(1.0 - alpha / 2.0), 3);
    }

    public double pValue() {
        double ts = this.testStatistics();
        NormalProbabilityDistribution dist = new NormalProbabilityDistribution(0.0, 1.0);
        if (this.testType == HypothesisTest.LEFT_TAIL) {
            return dist.cumulativeProbability(ts);
        }
        if (this.testType == HypothesisTest.RIGHT_TAIL) {
            return 1.0 - dist.cumulativeProbability(ts);
        }
        double area = dist.cumulativeProbability(ts);
        if (area > 0.5) {
            area = 1.0 - area;
        }
        return 2.0 * area;
    }
}

