/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential;

import org.statcato.statistics.NormalProbabilityDistribution;
import org.statcato.statistics.inferential.HypothesisTest;
import org.statcato.utils.HelperFunctions;

public class HypothesisTest2MeanSigmaKnown {
    int n1;
    int n2;
    double xBar1;
    double xBar2;
    double sigma1;
    double sigma2;
    double diff;
    double confidenceLevel;
    int testType;
    boolean varEqual;

    public HypothesisTest2MeanSigmaKnown(int n1, int n2, double xBar1, double xBar2, double sigma1, double sigma2, double diff, double confidenceLevel, int testType) {
        this.n1 = n1;
        this.n2 = n2;
        this.xBar1 = xBar1;
        this.xBar2 = xBar2;
        this.sigma1 = sigma1;
        this.sigma2 = sigma2;
        this.diff = diff;
        this.confidenceLevel = confidenceLevel;
        this.testType = testType;
    }

    public double testStatistics() {
        return (this.xBar1 - this.xBar2 - this.diff) / Math.sqrt(this.sigma1 * this.sigma1 / (double)this.n1 + this.sigma2 * this.sigma2 / (double)this.n2);
    }

    public String criticalValue() {
        double alpha = 1.0 - this.confidenceLevel;
        NormalProbabilityDistribution dist = new NormalProbabilityDistribution(0.0, 1.0);
        if (this.testType == HypothesisTest.RIGHT_TAIL) {
            return HelperFunctions.formatFloat(dist.inverseCumulativeProbability(1.0 - alpha), 3);
        }
        if (this.testType == HypothesisTest.LEFT_TAIL) {
            return HelperFunctions.formatFloat(dist.inverseCumulativeProbability(alpha), 3);
        }
        return HelperFunctions.formatFloat(dist.inverseCumulativeProbability(alpha / 2.0), 3) + ", " + HelperFunctions.formatFloat(dist.inverseCumulativeProbability(1.0 - alpha / 2.0), 3);
    }

    public double pValue() {
        double ts = this.testStatistics();
        NormalProbabilityDistribution dist = new NormalProbabilityDistribution(0.0, 1.0);
        if (this.testType == HypothesisTest.LEFT_TAIL) {
            return dist.cumulativeProbability(ts);
        }
        if (this.testType == HypothesisTest.RIGHT_TAIL) {
            return 1.0 - dist.cumulativeProbability(ts);
        }
        double area = dist.cumulativeProbability(ts);
        if (area > 0.5) {
            area = 1.0 - area;
        }
        return 2.0 * area;
    }
}

