/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential;

import org.statcato.statistics.NormalProbabilityDistribution;
import org.statcato.statistics.inferential.HypothesisTest;
import org.statcato.utils.HelperFunctions;

public class HypothesisTest1Prop {
    int n;
    double p;
    double confidenceLevel;
    int testType;

    public HypothesisTest1Prop(int n, double p, double confidenceLevel, int testType) {
        this.n = n;
        this.p = p;
        this.confidenceLevel = confidenceLevel;
        this.testType = testType;
    }

    public double testStatistics(double pHat) {
        return (pHat - this.p) / Math.sqrt(this.p * (1.0 - this.p) / (double)this.n);
    }

    public String criticalValue() {
        double alpha = 1.0 - this.confidenceLevel;
        NormalProbabilityDistribution dist = new NormalProbabilityDistribution(0.0, 1.0);
        if (this.testType == HypothesisTest.RIGHT_TAIL) {
            return HelperFunctions.formatFloat(dist.inverseCumulativeProbability(1.0 - alpha), 3);
        }
        if (this.testType == HypothesisTest.LEFT_TAIL) {
            return HelperFunctions.formatFloat(dist.inverseCumulativeProbability(alpha), 3);
        }
        return HelperFunctions.formatFloat(dist.inverseCumulativeProbability(alpha / 2.0), 3) + ", " + HelperFunctions.formatFloat(dist.inverseCumulativeProbability(1.0 - alpha / 2.0), 3);
    }

    public double pValue(double pHat) {
        double ts = this.testStatistics(pHat);
        NormalProbabilityDistribution dist = new NormalProbabilityDistribution(0.0, 1.0);
        if (this.testType == HypothesisTest.LEFT_TAIL) {
            return dist.cumulativeProbability(ts);
        }
        if (this.testType == HypothesisTest.RIGHT_TAIL) {
            return 1.0 - dist.cumulativeProbability(ts);
        }
        double area = dist.cumulativeProbability(ts);
        if (area > 0.5) {
            area = 1.0 - area;
        }
        return 2.0 * area;
    }
}

