/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential;

import java.util.Vector;
import org.statcato.statistics.ChiSquareProbabilityDistribution;

public class GoodnessOfFitTest {
    int k;
    double confidenceLevel;

    public GoodnessOfFitTest(int k, double confidence) {
        this.k = k;
        this.confidenceLevel = confidence;
    }

    public Vector<Double> testStatisticContribution(Vector<Double> observedFreq, Vector<Double> expectedFreq) {
        Vector<Double> cont = new Vector<Double>();
        for (int i = 0; i < observedFreq.size(); ++i) {
            double chi2 = Math.pow(observedFreq.elementAt(i) - expectedFreq.elementAt(i), 2.0) / expectedFreq.elementAt(i);
            cont.addElement(new Double(chi2));
        }
        return cont;
    }

    public double testStatistic(Vector<Double> observedFreq, Vector<Double> expectedFreq) {
        double chi2 = 0.0;
        for (int i = 0; i < observedFreq.size(); ++i) {
            chi2 += Math.pow(observedFreq.elementAt(i) - expectedFreq.elementAt(i), 2.0) / expectedFreq.elementAt(i);
        }
        return chi2;
    }

    public int DOF() {
        return this.k - 1;
    }

    public double criticalValue() {
        ChiSquareProbabilityDistribution dist = new ChiSquareProbabilityDistribution(this.DOF());
        return dist.inverseCumulativeProbability(this.confidenceLevel);
    }

    public double pValue(double ts) {
        ChiSquareProbabilityDistribution dist = new ChiSquareProbabilityDistribution(this.DOF());
        return 1.0 - dist.cumulativeProbability(ts);
    }
}

