/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential;

import java.util.ArrayList;
import java.util.Vector;
import org.statcato.statistics.BasicStatistics;
import org.statcato.statistics.StudentTProbabilityDistribution;
import org.statcato.utils.HelperFunctions;

public class CorrelationRegression {
    private Vector<Double> x;
    private Vector<Double> y;
    int n;
    double significance;

    public CorrelationRegression(Vector<Double> x, Vector<Double> y, double sig) {
        this.x = x;
        this.y = y;
        this.n = x.size();
        this.significance = sig;
    }

    public int N() {
        return this.n;
    }

    public int DOF() {
        return this.n - 2;
    }

    public double LinearCorrelationCoeff() {
        double sumX = this.SumX();
        double sumY = this.SumY();
        return ((double)this.n * this.SumXY() - sumX * sumY) / Math.sqrt((double)this.n * this.SumXSq() - Math.pow(sumX, 2.0)) / Math.sqrt((double)this.n * this.SumYSq() - Math.pow(sumY, 2.0));
    }

    public double TestStatistic_t() {
        double r = this.LinearCorrelationCoeff();
        return r / Math.sqrt((1.0 - r * r) / (double)(this.n - 2));
    }

    public double RegressionEqSlope() {
        double sumX = this.SumX();
        double sumY = this.SumY();
        return ((double)this.n * this.SumXY() - sumX * sumY) / ((double)this.n * this.SumXSq() - sumX * sumX);
    }

    public double RegressionEqYInt() {
        double sumX = this.SumX();
        double sumY = this.SumY();
        double sumXSq = this.SumXSq();
        return (sumY * sumXSq - sumX * this.SumXY()) / ((double)this.n * this.SumXSq() - sumX * sumX);
    }

    private double SumX() {
        return BasicStatistics.sum(this.x);
    }

    private double SumY() {
        return BasicStatistics.sum(this.y);
    }

    private double SumXY() {
        double sum = 0.0;
        for (int i = 0; i < this.x.size(); ++i) {
            sum += this.x.elementAt(i) * this.y.elementAt(i);
        }
        return sum;
    }

    private double SumXSq() {
        double sum = 0.0;
        for (int i = 0; i < this.x.size(); ++i) {
            sum += this.x.elementAt(i) * this.x.elementAt(i);
        }
        return sum;
    }

    private double SumYSq() {
        double sum = 0.0;
        for (int i = 0; i < this.y.size(); ++i) {
            sum += this.y.elementAt(i) * this.y.elementAt(i);
        }
        return sum;
    }

    public double TotalVariation() {
        double total = 0.0;
        double mean = BasicStatistics.mean(this.y);
        for (int i = 0; i < this.y.size(); ++i) {
            total += Math.pow(Double.valueOf(this.y.elementAt(i)) - mean, 2.0);
        }
        return total;
    }

    public double ExplainedVariation() {
        double total = 0.0;
        double mean = BasicStatistics.mean(this.y);
        double b0 = this.RegressionEqYInt();
        double b1 = this.RegressionEqSlope();
        for (int i = 0; i < this.y.size(); ++i) {
            double yValue = this.y.elementAt(i);
            double xValue = this.x.elementAt(i);
            double yR = b0 + b1 * xValue;
            total += Math.pow(yR - mean, 2.0);
        }
        return total;
    }

    public double UnexplainedVariation() {
        double total = 0.0;
        double mean = BasicStatistics.mean(this.y);
        double b0 = this.RegressionEqYInt();
        double b1 = this.RegressionEqSlope();
        for (int i = 0; i < this.y.size(); ++i) {
            double yValue = this.y.elementAt(i);
            double xValue = this.x.elementAt(i);
            double yR = b0 + b1 * xValue;
            total += Math.pow(yValue - yR, 2.0);
        }
        return total;
    }

    public ArrayList<Double> Residuals() {
        ArrayList<Double> residualList = new ArrayList<Double>();
        ArrayList<Double> predictedList = this.PredictedValues();
        for (int i = 0; i < this.y.size(); ++i) {
            double yR = predictedList.get(i);
            double yValue = this.y.elementAt(i);
            residualList.add(new Double(yValue - yR));
        }
        return residualList;
    }

    public ArrayList<Double> PredictedValues() {
        ArrayList<Double> valueList = new ArrayList<Double>();
        double b0 = this.RegressionEqYInt();
        double b1 = this.RegressionEqSlope();
        for (int i = 0; i < this.y.size(); ++i) {
            double yValue = this.y.elementAt(i);
            double xValue = this.x.elementAt(i);
            double yR = b0 + b1 * xValue;
            valueList.add(new Double(yR));
        }
        return valueList;
    }

    public double CoefficientOfDetermination() {
        return this.ExplainedVariation() / this.TotalVariation();
    }

    public double StandardError() {
        double b0 = this.RegressionEqYInt();
        double b1 = this.RegressionEqSlope();
        return Math.sqrt((this.SumYSq() - b0 * this.SumY() - b1 * this.SumXY()) / (double)(this.n - 2));
    }

    public double CriticalValue_r(double significance) {
        double t = this.CriticalValue_t(significance);
        double tSq = t * t;
        return Math.sqrt(tSq / ((double)(this.n - 2) + tSq));
    }

    public double CriticalValue_t(double significance) {
        StudentTProbabilityDistribution dist = new StudentTProbabilityDistribution(this.DOF());
        return dist.inverseCumulativeProbability(1.0 - significance / 2.0);
    }

    public double PValue() {
        double ts = this.TestStatistic_t();
        StudentTProbabilityDistribution dist = new StudentTProbabilityDistribution(this.DOF());
        double area = dist.cumulativeProbability(ts);
        if (area > 0.5) {
            area = 1.0 - area;
        }
        return 2.0 * area;
    }

    public String toString() {
        String text = "";
        text = text + "Sample size n = " + this.N() + "<br>";
        text = text + "Degrees of freedom = " + this.DOF() + "<br><br>";
        text = text + "<u>Correlation</u>:<br>";
        text = text + "H<sub>0</sub>: &rho; = 0 (no linear correlation)<br>";
        text = text + "H<sub>1</sub>: &rho; &ne; 0 (linear correlation)<br>";
        text = text + "<table border=1>";
        text = text + "<tr><th>&nbsp;</th><th>Test Statistic</th><th>Critical Value</th></tr>";
        text = text + "<tr><th>r</th>";
        text = text + "<td>" + HelperFunctions.formatFloat(this.LinearCorrelationCoeff(), 4) + "</td>";
        text = text + "<td>&plusmn;" + HelperFunctions.formatFloat(this.CriticalValue_r(this.significance), 4) + "</td>";
        text = text + "</tr>";
        text = text + "<tr><th>t</th>";
        text = text + "<td>" + HelperFunctions.formatFloat(this.TestStatistic_t(), 4) + "</td>";
        text = text + "<td>&plusmn;" + HelperFunctions.formatFloat(this.CriticalValue_t(this.significance), 4) + "</td>";
        text = text + "</tr></table>";
        text = text + "p-Value = " + HelperFunctions.formatFloat(this.PValue(), 4) + "<br><br>";
        text = text + "<u>Regression</u>:<br>";
        text = text + "Regression equation Y = b<sub>0</sub> + b<sub>1</sub>x<br>";
        text = text + "b<sub>0</sub> = " + HelperFunctions.formatFloat(this.RegressionEqYInt(), 4) + "<br>";
        text = text + "b<sub>1</sub> = " + HelperFunctions.formatFloat(this.RegressionEqSlope(), 4) + "<br><br>";
        text = text + "<u>Variation</u>:<br>";
        text = text + "Explained variation = " + HelperFunctions.formatFloat(this.ExplainedVariation(), 4) + "<br>";
        text = text + "Unexplained variation = " + HelperFunctions.formatFloat(this.UnexplainedVariation(), 4) + "<br>";
        text = text + "Total variation = " + HelperFunctions.formatFloat(this.TotalVariation(), 4) + "<br>";
        text = text + "Coefficient of determination r<sup>2</sup> = " + HelperFunctions.formatFloat(this.CoefficientOfDetermination(), 4) + "<br>";
        text = text + "Standard error of estimate = " + HelperFunctions.formatFloat(this.StandardError(), 4) + "<br><br>";
        return text;
    }
}

