/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential;

import org.statcato.statistics.BinomialProbabilityDistribution;
import org.statcato.statistics.NormalProbabilityDistribution;
import org.statcato.statistics.inferential.ConfidenceInterval;

public class CIOnePopProp
extends ConfidenceInterval {
    private double p;
    private int n;
    private int distType;
    public static int NORMAL = 0;
    public static int BINOMIAL = 1;

    public CIOnePopProp(double confidenceLevel, int n, double p, int type) {
        this.n = n;
        this.p = p;
        this.center = p;
        this.confidenceLevel = confidenceLevel;
        this.distType = type;
    }

    @Override
    public double marginOfError() {
        return this.criticalValue() * Math.sqrt(this.p * (1.0 - this.p) / (double)this.n);
    }

    @Override
    public double criticalValue() {
        double alpha = 1.0 - this.confidenceLevel;
        if (this.distType == NORMAL) {
            NormalProbabilityDistribution dist = new NormalProbabilityDistribution(0.0, 1.0);
            return dist.inverseCumulativeProbability(1.0 - alpha / 2.0);
        }
        BinomialProbabilityDistribution dist = new BinomialProbabilityDistribution(this.n, this.p);
        return dist.inverseCumulativeProbability(1.0 - alpha / 2.0);
    }
}

