/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential;

import org.statcato.statistics.NormalProbabilityDistribution;
import org.statcato.statistics.inferential.ConfidenceInterval;

public class CI2PopMeanSigmaKnown
extends ConfidenceInterval {
    private double sigma1;
    private double sigma2;
    private int n1;
    private int n2;
    private double xBar1;
    private double xBar2;

    public CI2PopMeanSigmaKnown(double confidenceLevel, int n1, int n2, double xBar1, double xBar2, double sigma1, double sigma2) {
        this.n1 = n1;
        this.n2 = n2;
        this.sigma1 = sigma1;
        this.sigma2 = sigma2;
        this.xBar1 = xBar1;
        this.xBar2 = xBar2;
        this.center = xBar1 - xBar2;
        this.confidenceLevel = confidenceLevel;
    }

    @Override
    public double marginOfError() {
        return this.criticalValue() * Math.sqrt(this.sigma1 * this.sigma1 / (double)this.n1 + this.sigma2 * this.sigma2 / (double)this.n2);
    }

    @Override
    public double criticalValue() {
        double alpha = 1.0 - this.confidenceLevel;
        NormalProbabilityDistribution dist = new NormalProbabilityDistribution(0.0, 1.0);
        return dist.inverseCumulativeProbability(1.0 - alpha / 2.0);
    }
}

