/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics;

import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class DiscreteCustomProbabilityDistribution {
    TreeMap map = new TreeMap();
    TreeMap cumMap = new TreeMap();

    public DiscreteCustomProbabilityDistribution(Vector<Double> values, Vector<Double> probabilities) {
        double total = 0.0;
        for (int i = 0; i < values.size(); ++i) {
            this.map.put(values.elementAt(i), probabilities.elementAt(i));
            this.cumMap.put(values.elementAt(i), new Double(total += probabilities.elementAt(i).doubleValue()));
        }
    }

    public double density(double x) {
        Double p = (Double)this.map.get(new Double(x));
        if (p == null) {
            return 0.0;
        }
        return p;
    }

    public double cumulativeProbability(double x) {
        Set keys = this.cumMap.keySet();
        double p = 0.0;
        for (Double value : keys) {
            if (x < value) {
                return p;
            }
            p = (Double)this.cumMap.get(value);
            if (x != value) continue;
            return p;
        }
        return 1.0;
    }

    public Double inverseCumulativeProbability(double area) {
        if (area < 0.0 || area > 1.0) {
            return null;
        }
        Set keys = this.cumMap.keySet();
        for (Double value : keys) {
            Double p = (Double)this.cumMap.get(value);
            if (!(area <= p)) continue;
            return value;
        }
        return null;
    }
}

