/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.graph;

import java.util.Collections;
import java.util.Vector;

public class StemAndLeafPlot {
    private Vector<Double> Stems = new Vector();
    private Vector<Vector<Integer>> Leaves = new Vector();
    public static boolean DEBUG = false;
    private double leafUnits;
    public boolean displayEmptyStem = true;

    public StemAndLeafPlot(Vector<Double> values, double u) {
        int i;
        if (u <= 0.0 || Math.log10(u) - Math.floor(Math.log10(u)) != 0.0) {
            Vector<Double> LeafUnits = new Vector<Double>();
            for (int i2 = 0; i2 < values.size(); ++i2) {
                double value = values.elementAt(i2);
                double leafUnit = StemAndLeafPlot.computeLeafUnit(value);
                StemAndLeafPlot.printDebug("value = " + value + " leafunit = " + leafUnit);
                LeafUnits.addElement(new Double(leafUnit));
            }
            this.leafUnits = StemAndLeafPlot.computeCommonLeafUnit(LeafUnits);
        } else {
            this.leafUnits = u;
        }
        for (i = 0; i < values.size(); ++i) {
            int loc;
            double value = values.elementAt(i) + this.leafUnits / 2.0;
            Integer leaf = new Integer(StemAndLeafPlot.getLeaf(value, this.leafUnits));
            Double stem = new Double(StemAndLeafPlot.getStem(value, this.leafUnits));
            StemAndLeafPlot.printDebug("stem = " + stem + ", leaf = " + leaf);
            if (this.Stems.contains(new Double(stem))) {
                loc = this.Stems.indexOf(stem);
                this.Leaves.elementAt(loc).addElement(leaf);
                continue;
            }
            this.Stems.addElement(stem);
            Collections.sort(this.Stems);
            loc = this.Stems.indexOf(stem);
            this.Leaves.add(loc, new Vector());
            this.Leaves.elementAt(loc).addElement(leaf);
        }
        for (i = 0; i < this.Stems.size(); ++i) {
            StemAndLeafPlot.printDebug("Stem: " + this.Stems.elementAt(i));
            for (int j = 0; j < this.Leaves.elementAt(i).size(); ++j) {
                StemAndLeafPlot.printDebug("leaf " + this.Leaves.elementAt(i).elementAt(j));
            }
        }
    }

    public String toString() {
        if (this.Stems.size() == 0) {
            return "";
        }
        String s = "";
        s = s + "<table border='1'>";
        s = s + "<tr><td align='right'>Stem</td><td>Leaves</td></tr>";
        double lastStem = this.Stems.elementAt(0);
        s = s + this.rowToString(lastStem, this.Leaves.elementAt(0));
        double stemUnits = this.getStemUnits();
        for (int i = 1; i < this.Stems.size(); ++i) {
            double thisStem = this.Stems.elementAt(i);
            for (double r = lastStem + stemUnits; r < thisStem - stemUnits / 2.0; r += stemUnits) {
                s = s + this.rowToString(r, null);
            }
            s = s + this.rowToString(thisStem, this.Leaves.elementAt(i));
            lastStem = thisStem;
        }
        s = s + "</table>";
        return s;
    }

    private String rowToString(double stem, Vector<Integer> Leaf) {
        String s = "";
        if (this.displayEmptyStem || Leaf != null) {
            s = "<tr>";
            if (this.leafUnits >= 0.1) {
                s = s + "<td align='right'>" + String.format("%d", (int)stem) + "</td>";
            } else {
                int places = -((int)Math.log10(this.leafUnits)) - 1;
                s = s + "<td align='right'>" + String.format("%." + places + "f", stem) + "</td>";
            }
            s = s + "<td>";
            if (Leaf == null) {
                s = s + "&nbsp;";
            } else {
                Collections.sort(Leaf);
                for (int j = 0; j < Leaf.size(); ++j) {
                    s = s + Leaf.elementAt(j);
                }
            }
            s = s + "</td>";
            s = s + "</tr>";
        }
        return s;
    }

    public double getLeafUnits() {
        return this.leafUnits;
    }

    private double getStemUnits() {
        if (this.leafUnits >= 0.1) {
            return 1.0;
        }
        return this.leafUnits * 10.0;
    }

    public static double getStem(double value, double place) {
        String s = String.format("%f", value);
        int decimalLoc = s.indexOf(46);
        int leafLoc = StemAndLeafPlot.getLeafIndex(value, place);
        if (leafLoc == -1) {
            return 0.0;
        }
        if (decimalLoc == -1) {
            return Integer.parseInt(s.substring(0, leafLoc));
        }
        StemAndLeafPlot.printDebug("value = " + value + " place = " + place);
        StemAndLeafPlot.printDebug("decimal loc " + decimalLoc);
        if (leafLoc == 0) {
            return 0.0;
        }
        return Double.parseDouble(s.substring(0, leafLoc));
    }

    public static int getLeafIndex(double value, double place) {
        String s = String.format("%f", value);
        int decimalLoc = s.indexOf(46);
        int offset = (int)Math.log10(place);
        int loc = 0;
        if (decimalLoc == -1) {
            if (offset < 0) {
                return -1;
            }
            loc = s.length() - offset - 1;
        } else {
            loc = decimalLoc - offset;
            if (offset >= 0) {
                --loc;
            }
        }
        if (loc < 0 || loc >= s.length()) {
            return -1;
        }
        return loc;
    }

    public static int getLeaf(double value, double place) {
        int loc = StemAndLeafPlot.getLeafIndex(value, place);
        String s = String.format("%f", value);
        if (loc == -1) {
            return 0;
        }
        return Character.getNumericValue(s.charAt(loc));
    }

    public static double computeLeafUnit(double x) {
        double i;
        if ((x = Math.abs(x)) < 1.0) {
            i = 10.0;
            while (x * i < 1.0) {
                i *= 10.0;
            }
            i = 1.0 / i / 10.0;
        } else {
            i = 10.0;
            while (x / i >= 1.0) {
                i *= 10.0;
            }
            i /= 100.0;
        }
        return i;
    }

    public static double computeCommonLeafUnit(Vector<Double> units) {
        double max = Collections.max(units);
        return max;
    }

    public static void printDebug(String msg) {
        if (DEBUG) {
            System.out.println(msg);
        }
    }
}

