/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.encoders.EncoderUtil;

public class GraphUtils {
    public static Icon createGraphImageLabel(JFreeChart plot) {
        BufferedImage image = plot.createBufferedImage(400, 300);
        return new ImageIcon(image);
    }

    public static BufferedImage joinBufferedChartImages(ArrayList<JFreeChart> charts) {
        if (charts.isEmpty()) {
            return null;
        }
        int height = 420;
        int width = 680;
        int totalHeight = height * (int)Math.ceil((double)charts.size() / 2.0);
        int totalWidth = width * 2;
        BufferedImage newImage = new BufferedImage(totalWidth, totalHeight, 2);
        Graphics2D g = newImage.createGraphics();
        GraphUtils.drawCharts(g, charts, 0, 0, totalWidth, totalHeight);
        g.dispose();
        return newImage;
    }

    public static void drawCharts(Graphics2D g, ArrayList<JFreeChart> charts, int x, int y, int width, int height) {
        int aHeight = height / (int)Math.ceil((double)charts.size() / 2.0);
        int aWidth = width / 2;
        g.setBackground(Color.WHITE);
        g.clearRect(x, y, width + x, height + y);
        for (int i = 0; i < charts.size(); ++i) {
            charts.get(i).draw(g, new Rectangle2D.Double(x + i % 2 * aWidth, y + i / 2 * aHeight, aWidth, aHeight));
        }
    }

    public static void writeBufferedImageAsPNG(OutputStream out, BufferedImage image, int width, int height) throws IOException {
        EncoderUtil.writeBufferedImage(image, "png", out);
    }
}

