/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.nonparametrics;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.inferential.HypothesisTest;
import org.statcato.statistics.inferential.nonparametrics.WilcoxonRankSumTest;
import org.statcato.utils.HelperFunctions;

public class WilcoxonRankSumTestDialog
extends StatcatoDialog {
    private JComboBox AltComboBox;
    private JButton CancelButton;
    private JButton OKButton;
    private JComboBox Sample1ComboBox;
    private JComboBox Sample2ComboBox;
    private JTextField SigTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;

    public WilcoxonRankSumTestDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.app = (Statcato)parent;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        this.ParentSpreadsheet.populateComboBox(this.Sample1ComboBox);
        this.ParentSpreadsheet.populateComboBox(this.Sample2ComboBox);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("stat-nonparam-wilcoxon-rank-sum");
        this.name = "Wilcoxon Rank Sum / Mann-Whitney Test";
        this.description = "For performing the Wilcoxon Rank Sum Test for two independent samples.";
        this.helpStrings.add("Select whether there is one sample or two sapmles of matched pairs.  Select the column names in the drop-down menus.");
        this.helpStrings.add("Provide the alternative hypothesis and significance level.");
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.Sample2ComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.Sample1ComboBox = new JComboBox();
        this.jPanel3 = new JPanel();
        this.jLabel8 = new JLabel();
        this.AltComboBox = new JComboBox();
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.SigTextField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Wilcoxon Rank Sum / Mann-Whitney Test");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.jLabel2.setText("Second Sample:");
        this.jLabel1.setText("First Sample:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(51, 51, 51).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.Sample2ComboBox, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.Sample1ComboBox, -2, 114, -2)).addContainerGap(69, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(37, 37, 37).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.Sample1ComboBox, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.Sample2ComboBox, -2, -1, -2).addComponent(this.jLabel2)).addGap(27, 27, 27)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Alternative Hypothesis"));
        this.jLabel8.setText("<html>Alternative Hypothesis:  ");
        this.AltComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Less than", "Not Equal to", "Greater than"}));
        this.AltComboBox.setSelectedIndex(1);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel8, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.AltComboBox, -2, -1, -2).addContainerGap(93, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8, -2, -1, -2).addComponent(this.AltComboBox, -2, -1, -2)).addGap(31, 31, 31)));
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WilcoxonRankSumTestDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WilcoxonRankSumTestDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Significance"));
        this.jLabel6.setText("Significance level:");
        this.SigTextField.setText("0.05");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addGap(39, 39, 39).addComponent(this.SigTextField, -2, 81, -2).addContainerGap(99, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.SigTextField, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGap(121, 121, 121).addComponent(this.OKButton, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton))).addContainerGap(10, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 64, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton))));
        this.pack();
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.Sample1ComboBox);
        this.updateComboBox(this.Sample2ComboBox);
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        double significance;
        this.app.compoundEdit = new DialogEdit("wilcoxon rank sum / mann-whitney");
        String heading = "Wilcoxon Rank Sum / Mann-Whitney Test:";
        String text = "";
        String columnLabel1 = "";
        String columnLabel2 = "";
        double median = 0.0;
        int typeTest = this.AltComboBox.getSelectedIndex();
        try {
            significance = Double.parseDouble(this.SigTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the significance level.");
            return;
        }
        if (significance <= 0.0 || significance >= 1.0) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
            return;
        }
        heading = heading + "  Significance level = " + significance;
        columnLabel1 = this.Sample1ComboBox.getSelectedItem().toString();
        Vector<Double> ColumnVector1 = new Vector();
        Vector<Double> ColumnVector2 = new Vector();
        if (columnLabel1.equals("")) {
            this.app.showErrorDialog("Select sample 1 input column.");
            return;
        }
        int column = this.ParentSpreadsheet.parseColumnNumber(columnLabel1);
        Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(column);
        ColumnVector1 = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
        if (ColumnVector1 == null) {
            this.app.showErrorDialog("Invalid input column " + columnLabel1 + ": all data must be numbers.");
            return;
        }
        ColumnVector1 = HelperFunctions.removeNullValues(ColumnVector1);
        text = text + "Sample 1: " + columnLabel1 + "<br>";
        columnLabel2 = this.Sample2ComboBox.getSelectedItem().toString();
        if (columnLabel2.equals("")) {
            this.app.showErrorDialog("Select sample 2 input column.");
            return;
        }
        column = this.ParentSpreadsheet.parseColumnNumber(columnLabel2);
        StrColumnVector = this.ParentSpreadsheet.getColumn(column);
        ColumnVector2 = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
        if (ColumnVector2 == null) {
            this.app.showErrorDialog("Invalid input column " + columnLabel2 + ": all data must be numbers.");
            return;
        }
        ColumnVector2 = HelperFunctions.removeNullValues(ColumnVector2);
        text = text + "Sample 2: " + columnLabel2 + "<br>";
        WilcoxonRankSumTest test = new WilcoxonRankSumTest(ColumnVector1, ColumnVector2, typeTest, significance);
        text = text + "H<sub>0</sub>: median<sub>1</sub> = median<sub>2</sub><br>";
        text = text + "H<sub>1</sub>: median<sub>1</sub>";
        text = typeTest == HypothesisTest.LEFT_TAIL ? text + " &lt; " : (typeTest == HypothesisTest.RIGHT_TAIL ? text + " &gt; " : text + " &ne; ");
        text = text + "median<sub>2</sub><br>";
        text = text + test;
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

