/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.nonparametrics;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.inferential.nonparametrics.RankCorrelation;
import org.statcato.utils.HelperFunctions;

public class RankCorrelationDialog
extends StatcatoDialog {
    private JButton AddButton;
    private JButton CancelButton;
    private JButton ClearButton1;
    private JButton OKButton;
    private JButton RemoveButton;
    private JList SeriesList;
    private JTextField SigTextField;
    private JComboBox XComboBox;
    private JComboBox YComboBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;

    public RankCorrelationDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.app = (Statcato)parent;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        this.customInitComponents();
        this.setHelpFile("stat-nonparam-rank-correlation");
        this.name = "Rank Correlation";
        this.description = "For performing the Spearman's rank correlation test between two variables.";
        this.helpStrings.add("Provide the matched pairs in two separate columns and add the series of two variables to the list of variable series.");
        this.helpStrings.add("Provide the significance level.");
    }

    private void customInitComponents() {
        this.updateComboBox(this.XComboBox);
        this.updateComboBox(this.YComboBox);
        this.clearMutableColumnsList(this.SeriesList);
        this.getRootPane().setDefaultButton(this.OKButton);
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.XComboBox);
        this.updateComboBox(this.YComboBox);
        this.clearMutableColumnsList(this.SeriesList);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.SeriesList = new JList(new DefaultListModel());
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.XComboBox = new JComboBox();
        this.jLabel4 = new JLabel();
        this.YComboBox = new JComboBox();
        this.AddButton = new JButton();
        this.jLabel9 = new JLabel();
        this.RemoveButton = new JButton();
        this.ClearButton1 = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.SigTextField = new JTextField();
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Spearman's Rank Correlation");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Variable series");
        this.SeriesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                RankCorrelationDialog.this.SeriesListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.SeriesList);
        this.jLabel2.setText("<html>Select the two variables of a new series:");
        this.jLabel3.setText("Variable 1:");
        this.XComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RankCorrelationDialog.this.XComboBoxItemStateChanged(evt);
            }
        });
        this.jLabel4.setText("Variable 2:");
        this.YComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RankCorrelationDialog.this.YComboBoxItemStateChanged(evt);
            }
        });
        this.AddButton.setText("Add Series");
        this.AddButton.setEnabled(false);
        this.AddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RankCorrelationDialog.this.AddButtonActionPerformed(evt);
            }
        });
        this.jLabel9.setText("Select the series to be removed:");
        this.RemoveButton.setText("Remove Series");
        this.RemoveButton.setEnabled(false);
        this.RemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RankCorrelationDialog.this.RemoveButtonActionPerformed(evt);
            }
        });
        this.ClearButton1.setText("Clear Input List");
        this.ClearButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RankCorrelationDialog.this.ClearButton1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 103, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(26, 26, 26).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.YComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.XComboBox, 0, 104, Short.MAX_VALUE))).addComponent(this.AddButton))).addGroup(jPanel1Layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jLabel2, -2, -1, -2)))).addComponent(this.jLabel1).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.RemoveButton))).addGap(90, 90, 90)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.ClearButton1).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.XComboBox, -2, -1, -2).addComponent(this.jLabel3)).addGap(13, 13, 13).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.YComboBox, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.AddButton)).addComponent(this.jScrollPane1, -2, -1, -2)).addGap(15, 15, 15).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.RemoveButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ClearButton1).addContainerGap(40, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Significance"));
        this.jLabel6.setText("Significance level:");
        this.SigTextField.setText("0.05");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SigTextField, -2, 81, -2).addContainerGap(252, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.SigTextField, -2, -1, -2)).addContainerGap()));
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RankCorrelationDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RankCorrelationDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton).addGap(149, 149, 149)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, 470, Short.MAX_VALUE).addContainerGap())));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(324, Short.MAX_VALUE).addComponent(this.jPanel2, -2, -1, -2).addGap(45, 45, 45).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(155, Short.MAX_VALUE))));
        this.pack();
    }

    private void SeriesListValueChanged(ListSelectionEvent evt) {
        if (this.SeriesList.getSelectedIndex() != -1) {
            this.RemoveButton.setEnabled(true);
        } else {
            this.RemoveButton.setEnabled(false);
        }
    }

    private void XComboBoxItemStateChanged(ItemEvent evt) {
        if (this.XComboBox.getSelectedIndex() == 0 || this.YComboBox.getSelectedIndex() == 0) {
            this.AddButton.setEnabled(false);
        } else {
            this.AddButton.setEnabled(true);
            this.AddButton.requestFocusInWindow();
        }
    }

    private void YComboBoxItemStateChanged(ItemEvent evt) {
        if (this.XComboBox.getSelectedIndex() == 0 || this.YComboBox.getSelectedIndex() == 0) {
            this.AddButton.setEnabled(false);
        } else {
            this.AddButton.setEnabled(true);
            this.AddButton.requestFocusInWindow();
        }
    }

    private void AddButtonActionPerformed(ActionEvent evt) {
        if (this.XComboBox.getSelectedIndex() == 0) {
            this.app.showErrorDialog("Select variable 1 of the new series.");
            return;
        }
        if (this.YComboBox.getSelectedIndex() == 0) {
            this.app.showErrorDialog("Select variable 2 of the new series.");
            return;
        }
        String x = this.XComboBox.getSelectedItem().toString();
        String y = this.YComboBox.getSelectedItem().toString();
        String z = x.trim() + "," + y.trim();
        ((DefaultListModel)this.SeriesList.getModel()).addElement(z);
        this.SeriesList.setSelectedValue(z, true);
        this.OKButton.requestFocusInWindow();
    }

    private void RemoveButtonActionPerformed(ActionEvent evt) {
        if (this.SeriesList.getSelectedValue() != null) {
            ((DefaultListModel)this.SeriesList.getModel()).removeElementAt(this.SeriesList.getSelectedIndex());
            this.AddButton.requestFocusInWindow();
        }
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("rank correlation");
        double significance = 0.0;
        String heading = "Spearman's Rank Correlation:";
        String text = "";
        if (this.SeriesList.getModel().getSize() == 0) {
            this.app.showErrorDialog("Add at least one series.");
            return;
        }
        try {
            significance = Double.parseDouble(this.SigTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
            return;
        }
        if (significance <= 0.0 || significance >= 1.0) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
            return;
        }
        heading = heading + "  Significance level = " + significance;
        for (int i = 0; i < this.SeriesList.getModel().getSize(); ++i) {
            String xy = (String)this.SeriesList.getModel().getElementAt(i);
            text = text + "--------------------------<br>";
            text = text + "Series: " + xy + "<br>";
            String[] items = xy.split(",");
            int selectedXColumn = this.ParentSpreadsheet.parseColumnNumber(items[0]);
            int selectedYColumn = this.ParentSpreadsheet.parseColumnNumber(items[1]);
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(selectedXColumn);
            Vector<Double> XColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (XColumnVector == null) {
                this.app.showErrorDialog("Invalid input column " + items[0] + ": all data must be numbers.");
                return;
            }
            XColumnVector = HelperFunctions.removeNullValues(XColumnVector);
            StrColumnVector = this.ParentSpreadsheet.getColumn(selectedYColumn);
            Vector<Double> YColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (YColumnVector == null) {
                this.app.showErrorDialog("Invalid input column " + items[1] + ": all data must be numbers.");
                return;
            }
            YColumnVector = HelperFunctions.removeNullValues(YColumnVector);
            if (XColumnVector.size() != YColumnVector.size()) {
                this.app.showErrorDialog("The number of x values must be the same as the number of y values.");
                return;
            }
            RankCorrelation CG = new RankCorrelation(XColumnVector, YColumnVector, significance);
            text = text + CG;
        }
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void ClearButton1ActionPerformed(ActionEvent evt) {
        this.clearMutableColumnsList(this.SeriesList);
    }
}

