/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.multinomial;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.BasicStatistics;
import org.statcato.statistics.inferential.GoodnessOfFitTest;
import org.statcato.utils.HelperFunctions;

public class GoodnessOfFitDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JComboBox CatComboBox;
    private JRadioButton EqFreqRadioButton;
    private JRadioButton ExCatRadioButton;
    private JComboBox ODataComboBox;
    private JRadioButton ODataRadioButton;
    private JComboBox OFreqComboBox;
    private JRadioButton OFreqRadioButton;
    private JButton OKButton;
    private JComboBox PastComboBox;
    private JLabel PastLabel;
    private JComboBox ProbComboBox;
    private JTextField SigTextField;
    private JComboBox UnEqFreqComboBox;
    private JRadioButton UnEqualFreqRadioButton;
    private JRadioButton UneqFreqRadioButton;
    private JLabel UneqLabel;
    private JRadioButton UneqProbRadioButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;

    public GoodnessOfFitDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.app = app;
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.initComponents();
        this.customInitComponents();
        this.setHelpFile("stat-multi-goodness");
        this.name = "Chi-Square Goodness of Fit Test";
        this.description = "For determining whether an observed frequency distribution agrees with some claimed distribution.";
        this.helpStrings.add("Specify the observed and expected frequencies.");
        this.helpStrings.add("Specify the significance level.");
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.OFreqComboBox);
        this.updateComboBox(this.ODataComboBox);
        this.updateComboBox(this.UnEqFreqComboBox);
        this.updateComboBox(this.ProbComboBox);
        this.updateComboBox(this.CatComboBox);
        this.updateComboBox(this.PastComboBox);
    }

    public void customInitComponents() {
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.OFreqRadioButton);
        group1.add(this.ODataRadioButton);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.EqFreqRadioButton);
        group2.add(this.UnEqualFreqRadioButton);
        group2.add(this.ExCatRadioButton);
        ButtonGroup group3 = new ButtonGroup();
        group3.add(this.UneqFreqRadioButton);
        group3.add(this.UneqProbRadioButton);
        this.ParentSpreadsheet.populateComboBox(this.OFreqComboBox);
        this.ParentSpreadsheet.populateComboBox(this.ODataComboBox);
        this.ParentSpreadsheet.populateComboBox(this.UnEqFreqComboBox);
        this.ParentSpreadsheet.populateComboBox(this.ProbComboBox);
        this.ParentSpreadsheet.populateComboBox(this.CatComboBox);
        this.ParentSpreadsheet.populateComboBox(this.PastComboBox);
        this.getRootPane().setDefaultButton(this.OKButton);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.ODataComboBox = new JComboBox();
        this.CatComboBox = new JComboBox();
        this.OFreqRadioButton = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.ODataRadioButton = new JRadioButton();
        this.jLabel7 = new JLabel();
        this.OFreqComboBox = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jPanel4 = new JPanel();
        this.UnEqualFreqRadioButton = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.EqFreqRadioButton = new JRadioButton();
        this.UnEqFreqComboBox = new JComboBox();
        this.UneqLabel = new JLabel();
        this.UneqFreqRadioButton = new JRadioButton();
        this.UneqProbRadioButton = new JRadioButton();
        this.ProbComboBox = new JComboBox();
        this.ExCatRadioButton = new JRadioButton();
        this.PastLabel = new JLabel();
        this.PastComboBox = new JComboBox();
        this.jPanel2 = new JPanel();
        this.SigTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Chi-Square Goodness of Fit Test");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GoodnessOfFitDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GoodnessOfFitDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.ODataComboBox.setEnabled(false);
        this.OFreqRadioButton.setSelected(true);
        this.OFreqRadioButton.setText("Frequencies in Column:");
        this.OFreqRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GoodnessOfFitDialog.this.OFreqRadioButtonStateChanged(evt);
            }
        });
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Observed Frequencies:");
        this.ODataRadioButton.setText("Categorical Data in Column:");
        this.ODataRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GoodnessOfFitDialog.this.ODataRadioButtonStateChanged(evt);
            }
        });
        this.jLabel7.setText("(optional)");
        this.jLabel5.setText("Category names in Column:");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jLabel5)).addComponent(this.OFreqRadioButton).addComponent(this.ODataRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ODataComboBox, -2, -1, -2).addComponent(this.OFreqComboBox, -2, 96, -2).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.CatComboBox, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7))))).addContainerGap()));
        jPanel3Layout.linkSize(0, this.CatComboBox, this.ODataComboBox, this.OFreqComboBox);
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OFreqRadioButton).addComponent(this.OFreqComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.CatComboBox, -2, -1, -2).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ODataRadioButton).addComponent(this.ODataComboBox, -2, -1, -2)).addContainerGap()));
        this.UnEqualFreqRadioButton.setText("Unequal Frequencies");
        this.UnEqualFreqRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GoodnessOfFitDialog.this.UnEqualFreqRadioButtonStateChanged(evt);
            }
        });
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setText("Expected Frequencies:");
        this.EqFreqRadioButton.setSelected(true);
        this.EqFreqRadioButton.setText("Equal Frequencies");
        this.UnEqFreqComboBox.setEnabled(false);
        this.UneqLabel.setText("(assume in the same order as the categories provided)");
        this.UneqLabel.setEnabled(false);
        this.UneqFreqRadioButton.setSelected(true);
        this.UneqFreqRadioButton.setText("Frequencies in Column:");
        this.UneqFreqRadioButton.setEnabled(false);
        this.UneqFreqRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GoodnessOfFitDialog.this.UneqFreqRadioButtonStateChanged(evt);
            }
        });
        this.UneqProbRadioButton.setText("Probabilities in Column:");
        this.UneqProbRadioButton.setEnabled(false);
        this.UneqProbRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GoodnessOfFitDialog.this.UneqProbRadioButtonStateChanged(evt);
            }
        });
        this.ProbComboBox.setEnabled(false);
        this.ExCatRadioButton.setText("Categorical Data");
        this.ExCatRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GoodnessOfFitDialog.this.ExCatRadioButtonStateChanged(evt);
            }
        });
        this.PastLabel.setText("Past Sample Data in Column:");
        this.PastLabel.setEnabled(false);
        this.PastComboBox.setEnabled(false);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(43, 43, 43).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.UneqProbRadioButton).addComponent(this.UneqFreqRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.UnEqFreqComboBox, 0, 91, Short.MAX_VALUE).addComponent(this.ProbComboBox, 0, -1, Short.MAX_VALUE))).addComponent(this.UneqLabel))).addGroup(jPanel4Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.EqFreqRadioButton).addComponent(this.jLabel2).addComponent(this.UnEqualFreqRadioButton).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ExCatRadioButton).addGroup(jPanel4Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.PastLabel))).addGap(10, 10, 10).addComponent(this.PastComboBox, -2, 82, -2))))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.linkSize(0, this.ProbComboBox, this.UnEqFreqComboBox);
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.EqFreqRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.UnEqualFreqRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.UneqFreqRadioButton).addComponent(this.UnEqFreqComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.UneqProbRadioButton).addComponent(this.ProbComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.UneqLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ExCatRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.PastLabel).addComponent(this.PastComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -2, -1, -2).addComponent(this.jPanel3, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -1, 215, Short.MAX_VALUE).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Significance"));
        this.SigTextField.setText("0.05");
        this.jLabel4.setText("0 - 1.00 (e.g. 0.05)");
        this.jLabel6.setText("Significance level:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SigTextField, -2, 81, -2).addGap(10, 10, 10).addComponent(this.jLabel4).addContainerGap(58, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.SigTextField, -2, -1, -2).addComponent(this.jLabel4)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(132, 132, 132).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 37, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.CancelButton).addComponent(this.OKButton)).addContainerGap()));
        this.pack();
    }

    private void OFreqRadioButtonStateChanged(ChangeEvent evt) {
        if (this.OFreqRadioButton.isSelected()) {
            this.OFreqComboBox.setEnabled(true);
            this.CatComboBox.setEnabled(true);
        } else {
            this.OFreqComboBox.setEnabled(false);
            this.CatComboBox.setEnabled(false);
        }
    }

    private void ODataRadioButtonStateChanged(ChangeEvent evt) {
        if (this.ODataRadioButton.isSelected()) {
            this.ODataComboBox.setEnabled(true);
        } else {
            this.ODataComboBox.setEnabled(false);
        }
    }

    private void UnEqualFreqRadioButtonStateChanged(ChangeEvent evt) {
        if (this.UnEqualFreqRadioButton.isSelected()) {
            this.UnEqFreqComboBox.setEnabled(true);
            this.ProbComboBox.setEnabled(true);
            this.UneqFreqRadioButton.setEnabled(true);
            this.UneqProbRadioButton.setEnabled(true);
            this.UneqLabel.setEnabled(true);
        } else {
            this.UnEqFreqComboBox.setEnabled(false);
            this.ProbComboBox.setEnabled(false);
            this.UneqFreqRadioButton.setEnabled(false);
            this.UneqProbRadioButton.setEnabled(false);
            this.UneqLabel.setEnabled(false);
        }
        this.UneqFreqRadioButtonStateChanged(evt);
        this.UneqProbRadioButtonStateChanged(evt);
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        String columnLabel;
        Vector<Cell> StrColumnVector;
        int column;
        String columnLabel2;
        this.app.compoundEdit = new DialogEdit("goodness of fit");
        double confidenceLevel = 0.0;
        Vector<Double> ColumnVector = new Vector();
        Vector<Object> EFreqVector = new Vector<Double>();
        Vector<Cell> CatColumnVector = null;
        String heading = "Chi-Square Goodness-of-Fit Test:";
        String text = "";
        try {
            confidenceLevel = 1.0 - Double.parseDouble(this.SigTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the significance level.");
            return;
        }
        if (confidenceLevel <= 0.0 || confidenceLevel >= 1.0) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the significance level.");
            return;
        }
        if (this.OFreqRadioButton.isSelected()) {
            columnLabel2 = this.OFreqComboBox.getSelectedItem().toString();
            if (columnLabel2.equals("")) {
                this.app.showErrorDialog("Select the column containing observed frequencies.");
                return;
            }
            column = this.ParentSpreadsheet.parseColumnNumber(columnLabel2);
            StrColumnVector = this.ParentSpreadsheet.getColumn(column);
            ColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (ColumnVector == null) {
                this.app.showErrorDialog("Invalid input column " + columnLabel2 + ": all data must be numbers.");
                return;
            }
            text = text + "Input: " + columnLabel2 + "<br>";
            ColumnVector = HelperFunctions.removeNullValues(ColumnVector);
            if (this.CatComboBox.getSelectedIndex() != 0) {
                String catColumnLabel = this.CatComboBox.getSelectedItem().toString();
                CatColumnVector = this.ParentSpreadsheet.getColumn(this.ParentSpreadsheet.parseColumnNumber(catColumnLabel));
                CatColumnVector = HelperFunctions.removeNullCells(CatColumnVector);
            }
        } else {
            columnLabel2 = this.ODataComboBox.getSelectedItem().toString();
            if (columnLabel2.equals("")) {
                this.app.showErrorDialog("Select the column containing categorical data.");
                return;
            }
            text = text + "Input: " + columnLabel2 + "<br>";
            column = this.ParentSpreadsheet.parseColumnNumber(columnLabel2);
            StrColumnVector = this.ParentSpreadsheet.getColumn(column);
            StrColumnVector = HelperFunctions.removeNullCells(StrColumnVector);
            Object[] returnValues = HelperFunctions.ComputeCategoryFrequency(StrColumnVector);
            ColumnVector = (Vector)returnValues[1];
            CatColumnVector = (Vector<Cell>)returnValues[0];
        }
        double total = BasicStatistics.sum(ColumnVector);
        if (this.EqFreqRadioButton.isSelected()) {
            double expected = total / (double)ColumnVector.size();
            for (int i = 0; i < ColumnVector.size(); ++i) {
                EFreqVector.addElement(new Double(expected));
            }
            text = text + "Expected frequency = " + HelperFunctions.formatFloat(expected, 4) + "<br>";
        } else if (this.UnEqualFreqRadioButton.isSelected()) {
            if (this.UneqFreqRadioButton.isSelected()) {
                columnLabel = this.UnEqFreqComboBox.getSelectedItem().toString();
                if (columnLabel.equals("")) {
                    this.app.showErrorDialog("Select the column containing expected frequencies.");
                    return;
                }
                int column2 = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
                Vector<Cell> StrColumnVector2 = this.ParentSpreadsheet.getColumn(column2);
                EFreqVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector2);
                if (EFreqVector == null) {
                    this.app.showErrorDialog("Invalid input column " + columnLabel + ": all data must be numbers.");
                    return;
                }
                text = text + "Expected frequencies in " + columnLabel + "<br>";
                EFreqVector = HelperFunctions.removeNullValues(EFreqVector);
            } else {
                columnLabel = this.ProbComboBox.getSelectedItem().toString();
                if (columnLabel.equals("")) {
                    this.app.showErrorDialog("Select the column containing expected probabilites.");
                    return;
                }
                int column3 = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
                Vector<Cell> StrColumnVector3 = this.ParentSpreadsheet.getColumn(column3);
                EFreqVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector3);
                if (EFreqVector == null) {
                    this.app.showErrorDialog("Invalid input column " + columnLabel + ": all data must be numbers.");
                    return;
                }
                text = text + "Expected probabilities in " + columnLabel + "<br>";
                double totalProb = BasicStatistics.sum(EFreqVector = HelperFunctions.removeNullValues(EFreqVector));
                if (totalProb != 1.0) {
                    this.app.showErrorDialog("The expected probabilities must add up to 1.");
                    return;
                }
                for (int i = 0; i < EFreqVector.size(); ++i) {
                    EFreqVector.setElementAt((Double)EFreqVector.elementAt(i) * total, i);
                }
            }
        } else {
            columnLabel = this.PastComboBox.getSelectedItem().toString();
            if (columnLabel.equals("")) {
                this.app.showErrorDialog("Select the column containing past sample categorical data.");
                return;
            }
            text = text + "Past Sample Data: " + columnLabel + "<br>";
            int column4 = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
            Vector<Cell> StrColumnVector4 = this.ParentSpreadsheet.getColumn(column4);
            StrColumnVector4 = HelperFunctions.removeNullCells(StrColumnVector4);
            Object[] returnValues = HelperFunctions.ComputeCategoryFrequency(StrColumnVector4);
            Vector PastEFreqVector = (Vector)returnValues[1];
            Vector PastCatColumnVector = (Vector)returnValues[0];
            if (PastCatColumnVector.size() != CatColumnVector.size()) {
                this.app.showErrorDialog("The number of categories in the past sample data must be the same as the number of categories observed.");
                return;
            }
            double pastTotal = BasicStatistics.sum(PastEFreqVector);
            for (int i = 0; i < CatColumnVector.size(); ++i) {
                Cell cat = CatColumnVector.elementAt(i);
                int index = -1;
                for (int j = 0; j < PastCatColumnVector.size(); ++j) {
                    if (!((Cell)PastCatColumnVector.elementAt(j)).toString().equals(cat.toString())) continue;
                    index = j;
                    break;
                }
                if (index == -1) {
                    this.app.showErrorDialog("The category " + cat + " is not " + "found in the past sample data.");
                    return;
                }
                double freq = (Double)PastEFreqVector.elementAt(index);
                EFreqVector.addElement(freq / pastTotal * total);
            }
        }
        if (ColumnVector.size() != EFreqVector.size()) {
            this.app.showErrorDialog("The number of observed frequencies and the number of expected frequencies must be the same.");
            return;
        }
        GoodnessOfFitTest test = new GoodnessOfFitTest(ColumnVector.size(), confidenceLevel);
        Vector<Double> tsCont = test.testStatisticContribution(ColumnVector, EFreqVector);
        double ts = BasicStatistics.sum(tsCont);
        text = text + "<table border=1>";
        text = text + "<tr><td>Category</td><td>Observed Frequency</td><td>Expected Frequency</td><td>Contribution to &Chi;<sup>2</sup></td></tr>";
        for (int i = 0; i < ColumnVector.size(); ++i) {
            text = text + "<tr><td>";
            text = CatColumnVector == null ? text + i : text + CatColumnVector.elementAt(i);
            text = text + "</td><td>" + ColumnVector.elementAt(i) + "</td><td>";
            text = text + HelperFunctions.formatFloat((Double)EFreqVector.elementAt(i), 4) + "</td><td>" + HelperFunctions.formatFloat(tsCont.elementAt(i), 4) + "</td></tr>";
        }
        text = text + "</table><br>";
        text = text + "<table border=1>";
        text = text + "<tr><td>N</td><td>Number of Categories</td><td>DOF</td><td>Significance</td><td>Critical Value</td><td>Test statistics</td><td>p-Value</td></tr>";
        text = text + "<tr><td>" + total + "</td><td>" + ColumnVector.size() + "</td><td>" + test.DOF() + "</td><td>" + HelperFunctions.formatFloat(1.0 - confidenceLevel, 2) + "</td><td>" + HelperFunctions.formatFloat(test.criticalValue(), 4) + "</td><td>" + HelperFunctions.formatFloat(ts, 4) + "</tr><td>" + HelperFunctions.formatFloat(test.pValue(ts), 4) + "</td></tr>";
        text = text + "</table>";
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void UneqFreqRadioButtonStateChanged(ChangeEvent evt) {
        if (this.UneqFreqRadioButton.isSelected() && this.UnEqualFreqRadioButton.isSelected()) {
            this.UnEqFreqComboBox.setEnabled(true);
        } else {
            this.UnEqFreqComboBox.setEnabled(false);
        }
    }

    private void UneqProbRadioButtonStateChanged(ChangeEvent evt) {
        if (this.UneqProbRadioButton.isSelected() && this.UnEqualFreqRadioButton.isSelected()) {
            this.ProbComboBox.setEnabled(true);
        } else {
            this.ProbComboBox.setEnabled(false);
        }
    }

    private void ExCatRadioButtonStateChanged(ChangeEvent evt) {
        if (this.ExCatRadioButton.isSelected()) {
            this.PastLabel.setEnabled(true);
            this.PastComboBox.setEnabled(true);
        } else {
            this.PastLabel.setEnabled(false);
            this.PastComboBox.setEnabled(false);
        }
    }
}

