/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.multinomial;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.inferential.ContingencyTable;
import org.statcato.utils.HelperFunctions;

public class ContingencyTableDialog
extends StatcatoDialog {
    private JButton AddButton1;
    private JButton CancelButton;
    private JButton ClearButton1;
    private JList ColList;
    private JButton OKButton;
    private JButton RemoveButton1;
    private JTextField SigTextField;
    private JList VarList;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;

    public ContingencyTableDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.app = app;
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.initComponents();
        this.customInitComponents();
        this.setHelpFile("stat-multi-contingency_table");
        this.name = "Chi-Square Test: Contingency Table";
        this.description = "For testing independence in a contingency table.";
        this.helpStrings.add("The columns of a contingency table should be placed in separate columns in the Datasheet. All the columns in a contingency table must have the same number of rows.");
        this.helpStrings.add("To specify a column of a contingency table, select a column of the table, and click the Add to List button. ");
        this.helpStrings.add("Specify the significance level.");
    }

    @Override
    public void updateElements() {
        this.clearMutableColumnsList(this.ColList);
        this.clearMutableColumnsList(this.VarList);
        this.ParentSpreadsheet.populateMutableColumnsList(this.ColList);
    }

    public void customInitComponents() {
        this.ParentSpreadsheet.populateMutableColumnsList(this.ColList);
        this.ColList.setSelectionMode(2);
        this.VarList.setSelectionMode(2);
        this.getRootPane().setDefaultButton(this.OKButton);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.SigTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.VarList = new JList(new DefaultListModel());
        this.RemoveButton1 = new JButton();
        this.jLabel5 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.ColList = new JList(new DefaultListModel());
        this.jLabel1 = new JLabel();
        this.AddButton1 = new JButton();
        this.ClearButton1 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Chi-Square Test: Contingency Table");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContingencyTableDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContingencyTableDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Significance"));
        this.jLabel6.setText("Significance level:");
        this.SigTextField.setText("0.05");
        this.jLabel4.setText("0 - 1.00 (e.g. 0.05)");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SigTextField, -2, 81, -2).addGap(10, 10, 10).addComponent(this.jLabel4).addContainerGap(156, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.SigTextField, -2, -1, -2).addComponent(this.jLabel4)).addContainerGap()));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.VarList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ContingencyTableDialog.this.VarListValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.VarList);
        this.RemoveButton1.setText("Remove from list >>");
        this.RemoveButton1.setEnabled(false);
        this.RemoveButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContingencyTableDialog.this.RemoveButton1ActionPerformed(evt);
            }
        });
        this.jLabel5.setText("<HTML>Select a column of the table<br>\n(Ctrl-click or Shift-click to <br>\nselect multiple columns):");
        this.ColList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ContingencyTableDialog.this.ColListValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.ColList);
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Columns:");
        this.AddButton1.setText("<< Add to list");
        this.AddButton1.setEnabled(false);
        this.AddButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContingencyTableDialog.this.AddButton1ActionPerformed(evt);
            }
        });
        this.ClearButton1.setText("Clear Input List");
        this.ClearButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContingencyTableDialog.this.ClearButton1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ClearButton1).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 236, Short.MAX_VALUE).addComponent(this.jLabel5, -2, -1, -2)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 103, -2).addGap(22, 22, 22).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.AddButton1).addComponent(this.RemoveButton1)).addGap(28, 28, 28).addComponent(this.jScrollPane3, -2, 100, -2))).addContainerGap()));
        jPanel3Layout.linkSize(0, this.AddButton1, this.RemoveButton1);
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jLabel5, -2, -1, -2)).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(46, 46, 46).addComponent(this.AddButton1).addGap(18, 18, 18).addComponent(this.RemoveButton1)).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane3, -1, 122, Short.MAX_VALUE).addComponent(this.jScrollPane2, -1, 122, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ClearButton1))).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(181, 181, 181).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 43, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.CancelButton).addComponent(this.OKButton)).addContainerGap()));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("contingency table");
        Vector<Vector<Double>> table = new Vector<Vector<Double>>();
        int numRows = -1;
        double confidenceLevel = 0.0;
        String heading = "Chi-Square Test: Contingency Table:";
        String text = "";
        try {
            confidenceLevel = 1.0 - Double.parseDouble(this.SigTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
            return;
        }
        if (confidenceLevel <= 0.0 || confidenceLevel >= 1.0) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
            return;
        }
        String header = "";
        if (this.VarList.getModel().getSize() == 0) {
            this.app.showErrorDialog("The list of columns is empty.  Select at least one column.");
            return;
        }
        for (int i = 0; i < this.VarList.getModel().getSize(); ++i) {
            String x = (String)this.VarList.getModel().getElementAt(i);
            header = header + "<th>" + x + "</th>";
            int selectedXColumn = this.ParentSpreadsheet.parseColumnNumber(x);
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(selectedXColumn);
            Vector<Double> ColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if ((ColumnVector = HelperFunctions.removeNullValues(ColumnVector)) == null) {
                this.app.showErrorDialog("Invalid input column " + x + ": all data must be numbers.");
                return;
            }
            if (numRows == -1) {
                numRows = ColumnVector.size();
            } else if (numRows != ColumnVector.size()) {
                this.app.showErrorDialog("All columns must have the same number of elements.");
                return;
            }
            table.addElement(ColumnVector);
        }
        ContingencyTable CT = new ContingencyTable(table);
        text = text + "<table border=1><tr align='right'><th>&nbsp;</th>" + header;
        text = text + "<th>Total</th></tr>";
        text = text + CT.toString() + "</table><br>";
        text = text + "(expected frequency), [test statistic contribution]<br><br>";
        text = text + "<table border=1>";
        text = text + "<tr><td>Significance Level</td><td>DOF</td><td>&Chi;<sup>2</sup></td><td>Critical value</td><td>p-Value</td></tr>";
        text = text + "<tr><td>" + HelperFunctions.formatFloat(1.0 - confidenceLevel, 2) + "</td><td>" + CT.DOF() + "</td><td>" + HelperFunctions.formatFloat(CT.testStatistics(), 4) + "</td><td>" + HelperFunctions.formatFloat(CT.criticalValue(confidenceLevel), 4) + "</td><td>" + HelperFunctions.formatFloat(CT.pValue(), 4) + "</td></tr>";
        text = text + "</table>";
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void VarListValueChanged(ListSelectionEvent evt) {
        if (this.VarList.getSelectedIndex() != -1) {
            this.RemoveButton1.setEnabled(true);
        } else {
            this.RemoveButton1.setEnabled(false);
        }
    }

    private void RemoveButton1ActionPerformed(ActionEvent evt) {
        Object[] list = this.VarList.getSelectedValues();
        for (int i = 0; i < list.length; ++i) {
            String x = (String)list[i];
            ((DefaultListModel)this.ColList.getModel()).addElement(x);
            ((DefaultListModel)this.VarList.getModel()).removeElement(x);
        }
        this.OKButton.requestFocusInWindow();
    }

    private void ColListValueChanged(ListSelectionEvent evt) {
        if (this.ColList.getSelectedIndex() != -1) {
            this.AddButton1.setEnabled(true);
        } else {
            this.AddButton1.setEnabled(false);
        }
    }

    private void AddButton1ActionPerformed(ActionEvent evt) {
        Object[] list = this.ColList.getSelectedValues();
        for (int i = 0; i < list.length; ++i) {
            String x = (String)list[i];
            ((DefaultListModel)this.VarList.getModel()).addElement(x);
            ((DefaultListModel)this.ColList.getModel()).removeElement(x);
        }
        this.OKButton.requestFocusInWindow();
    }

    private void ClearButton1ActionPerformed(ActionEvent evt) {
        this.clearMutableColumnsList(this.ColList);
        this.clearMutableColumnsList(this.VarList);
        this.ParentSpreadsheet.populateMutableColumnsList(this.ColList);
    }
}

