/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.hytest;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.BasicStatistics;
import org.statcato.statistics.inferential.HypothesisTest;
import org.statcato.statistics.inferential.HypothesisTestMatchedPairs;
import org.statcato.utils.HelperFunctions;

public class HyTestMatchedPairsDialog
extends StatcatoDialog {
    private JComboBox AltComboBox;
    private JButton CancelButton;
    private JLabel ConfLabel;
    private JRadioButton ConfRadioButton;
    private JTextField ConfidenceTextField;
    private JTextField HyMeanTextField;
    private JTextField MeanTextField;
    private JButton OKButton;
    private JComboBox Sample1ComboBox;
    private JComboBox Sample2ComboBox;
    private JRadioButton SampleRadioButton;
    private JLabel SigLabel;
    private JPanel SigPanel;
    private JRadioButton SigRadioButton;
    private JTextField SigTextField;
    private JTextField SizeTextField;
    private JTextField StdevTextField;
    private JRadioButton SummaryRadioButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel3;

    public HyTestMatchedPairsDialog(Frame parent, boolean modal, Statcato mTab) {
        super(parent, modal);
        this.initComponents();
        this.app = mTab;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.SampleRadioButton);
        group1.add(this.SummaryRadioButton);
        ButtonGroup group4 = new ButtonGroup();
        group4.add(this.SigRadioButton);
        group4.add(this.ConfRadioButton);
        this.ParentSpreadsheet.populateComboBox(this.Sample1ComboBox);
        this.ParentSpreadsheet.populateComboBox(this.Sample2ComboBox);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("stat-hytest-matched");
        this.name = "Hypothesis Test: Matched Pairs";
        this.description = "For performing calculations for testing claims about the mean of the differences between a population of matched pairs.";
        this.helpStrings.add("The sample data can be inputted in one of two ways...");
        this.helpStrings.add("Samples in columns: The sample matched pairs are provided in two columns, and the two values in a matched pair are provided in the same row.");
        this.helpStrings.add("Summarized Sample Data: The sample size, mean, and standard deviation are provided.");
        this.helpStrings.add("Specify the significance or confidence level.");
        this.helpStrings.add("Select the form of alternative hypothesis.");
        this.helpStrings.add("Enter the hypothesized mean difference (hypothesized mean of differences for the population of all matched pairs).");
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.Sample1ComboBox);
        this.updateComboBox(this.Sample2ComboBox);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.SizeTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.Sample2ComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.SampleRadioButton = new JRadioButton();
        this.StdevTextField = new JTextField();
        this.Sample1ComboBox = new JComboBox();
        this.MeanTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.SummaryRadioButton = new JRadioButton();
        this.jLabel3 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel8 = new JLabel();
        this.HyMeanTextField = new JTextField();
        this.AltComboBox = new JComboBox();
        this.jLabel9 = new JLabel();
        this.SigPanel = new JPanel();
        this.SigLabel = new JLabel();
        this.ConfidenceTextField = new JTextField();
        this.ConfRadioButton = new JRadioButton();
        this.SigRadioButton = new JRadioButton();
        this.SigTextField = new JTextField();
        this.ConfLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Hypothesis Test: Matched Pairs");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HyTestMatchedPairsDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HyTestMatchedPairsDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.SizeTextField.setEnabled(false);
        this.jLabel2.setText("Second Sample:");
        this.jLabel1.setText("First Sample:");
        this.jLabel4.setText("Mean:");
        this.SampleRadioButton.setSelected(true);
        this.SampleRadioButton.setText("Samples in Columns");
        this.SampleRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTestMatchedPairsDialog.this.SampleRadioButtonStateChanged(evt);
            }
        });
        this.StdevTextField.setEnabled(false);
        this.MeanTextField.setEnabled(false);
        this.jLabel5.setText("Standard Deviation:");
        this.SummaryRadioButton.setText("Summarized Sample Data");
        this.SummaryRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTestMatchedPairsDialog.this.SummaryRadioButtonStateChanged(evt);
            }
        });
        this.jLabel3.setText("Sample Size:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SummaryRadioButton).addComponent(this.SampleRadioButton).addGroup(jPanel1Layout.createSequentialGroup().addGap(38, 38, 38).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.StdevTextField, -1, 76, Short.MAX_VALUE).addComponent(this.MeanTextField, -1, 78, Short.MAX_VALUE).addComponent(this.SizeTextField, -1, 78, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.Sample2ComboBox, 0, 98, Short.MAX_VALUE).addComponent(this.Sample1ComboBox, 0, 98, Short.MAX_VALUE)))))).addContainerGap(27, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.SampleRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.Sample1ComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.Sample2ComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SummaryRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.SizeTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.MeanTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.StdevTextField, -2, -1, -2)).addContainerGap()));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Alternative Hypothesis"));
        this.jLabel8.setText("Alternative Hypothesis:");
        this.HyMeanTextField.setText("0");
        this.AltComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Less than", "Not Equal to", "Greater than"}));
        this.AltComboBox.setSelectedIndex(1);
        this.jLabel9.setText("Hypothesized Mean:");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.AltComboBox, -2, -1, -2)).addGroup(jPanel3Layout.createSequentialGroup().addGap(38, 38, 38).addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.HyMeanTextField, -2, 78, -2))).addContainerGap(115, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.AltComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.HyMeanTextField, -2, -1, -2)).addContainerGap(23, Short.MAX_VALUE)));
        this.SigPanel.setBorder(BorderFactory.createTitledBorder("Significance"));
        this.SigLabel.setText("0 - 1.00 (e.g. 0.05)");
        this.ConfidenceTextField.setText("0.95");
        this.ConfidenceTextField.setEnabled(false);
        this.ConfidenceTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                HyTestMatchedPairsDialog.this.ConfidenceTextFieldFocusLost(evt);
            }
        });
        this.ConfRadioButton.setText("Confidence Level:");
        this.ConfRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTestMatchedPairsDialog.this.ConfRadioButtonStateChanged(evt);
            }
        });
        this.SigRadioButton.setSelected(true);
        this.SigRadioButton.setText("Significance Level:");
        this.SigRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTestMatchedPairsDialog.this.SigRadioButtonStateChanged(evt);
            }
        });
        this.SigTextField.setText("0.05");
        this.SigTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                HyTestMatchedPairsDialog.this.SigTextFieldFocusLost(evt);
            }
        });
        this.ConfLabel.setText("0 - 1.00 (e.g. 0.95)");
        this.ConfLabel.setEnabled(false);
        GroupLayout SigPanelLayout = new GroupLayout(this.SigPanel);
        this.SigPanel.setLayout(SigPanelLayout);
        SigPanelLayout.setHorizontalGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(SigPanelLayout.createSequentialGroup().addContainerGap().addGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ConfRadioButton).addComponent(this.SigRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ConfidenceTextField, -2, 81, -2).addComponent(this.SigTextField, -2, 79, -2)).addGap(18, 18, 18).addGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SigLabel).addComponent(this.ConfLabel)).addGap(29, 29, 29)));
        SigPanelLayout.setVerticalGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(SigPanelLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.SigRadioButton).addComponent(this.SigTextField, -2, -1, -2).addComponent(this.SigLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ConfRadioButton).addComponent(this.ConfidenceTextField, -2, -1, -2).addComponent(this.ConfLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.SigPanel, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGap(258, 258, 258).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton))).addContainerGap()));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel1, -2, -1, -2).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.SigPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.CancelButton).addComponent(this.OKButton)).addContainerGap()));
        this.pack();
    }

    private void SummaryRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SummaryRadioButton.isSelected()) {
            this.SizeTextField.setEnabled(true);
            this.MeanTextField.setEnabled(true);
            this.StdevTextField.setEnabled(true);
        } else {
            this.SizeTextField.setEnabled(false);
            this.MeanTextField.setEnabled(false);
            this.StdevTextField.setEnabled(false);
        }
    }

    private void SampleRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SampleRadioButton.isSelected()) {
            this.Sample1ComboBox.setEnabled(true);
            this.Sample2ComboBox.setEnabled(true);
        } else {
            this.Sample1ComboBox.setEnabled(false);
            this.Sample2ComboBox.setEnabled(false);
        }
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        double confidenceLevel;
        this.app.compoundEdit = new DialogEdit("hypothesis test matched pairs");
        int n = 0;
        double s = 0.0;
        double mean = 0.0;
        String heading = "Hypothesis Test - Matched Pairs:";
        String text = "";
        if (this.ConfRadioButton.isSelected()) {
            try {
                confidenceLevel = Double.parseDouble(this.ConfidenceTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
                return;
            }
            if (confidenceLevel <= 0.0 || confidenceLevel >= 1.0) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
                return;
            }
        } else {
            try {
                confidenceLevel = 1.0 - Double.parseDouble(this.SigTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the significance level.");
                return;
            }
            if (confidenceLevel <= 0.0 || confidenceLevel >= 1.0) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the significance level.");
                return;
            }
        }
        heading = heading + "  confidence level = " + String.format("%." + HelperFunctions.getNumDecimalPlaces(this.ConfidenceTextField.getText()) + "f", confidenceLevel);
        String columnLabel1 = "";
        String columnLabel2 = "";
        if (this.SampleRadioButton.isSelected()) {
            columnLabel1 = this.Sample1ComboBox.getSelectedItem().toString();
            Vector<Double> ColumnVector1 = new Vector();
            Vector<Double> ColumnVector2 = new Vector();
            if (columnLabel1.equals("")) {
                this.app.showErrorDialog("Select sample 1 input column.");
                return;
            }
            int column = this.ParentSpreadsheet.parseColumnNumber(columnLabel1);
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(column);
            ColumnVector1 = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (ColumnVector1 == null) {
                this.app.showErrorDialog("Invalid input column " + columnLabel1 + ": all data must be numbers.");
                return;
            }
            text = text + "Sample 1: " + columnLabel1 + "<br>";
            columnLabel2 = this.Sample2ComboBox.getSelectedItem().toString();
            if (columnLabel2.equals("")) {
                this.app.showErrorDialog("Select sample 2 input column.");
                return;
            }
            column = this.ParentSpreadsheet.parseColumnNumber(columnLabel2);
            StrColumnVector = this.ParentSpreadsheet.getColumn(column);
            ColumnVector2 = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (ColumnVector2 == null) {
                this.app.showErrorDialog("Invalid input column " + columnLabel2 + ": all data must be numbers.");
                return;
            }
            text = text + "Sample 2: " + columnLabel2 + "<br>";
            Vector<Double> DiffVector = HelperFunctions.ComputeDiffVector(ColumnVector1, ColumnVector2);
            if (DiffVector == null) {
                this.app.showErrorDialog("There are unmatched pairs in the sample.");
                return;
            }
            text = text + "Difference of Matched Pairs " + columnLabel1 + " - " + columnLabel2 + "<br>";
            n = BasicStatistics.Nnonmissing(DiffVector);
            mean = BasicStatistics.mean(DiffVector);
            s = BasicStatistics.stdev(DiffVector);
        } else {
            try {
                n = Integer.parseInt(this.SizeTextField.getText());
                if (n < 1) {
                    throw new NumberFormatException();
                }
                mean = Double.parseDouble(this.MeanTextField.getText());
                s = Double.parseDouble(this.StdevTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Invalid summary data.");
                return;
            }
            text = text + "Input: Summary data<br>";
        }
        double mu = 0.0;
        try {
            mu = Double.parseDouble(this.HyMeanTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a valid number for the hypothesized mean.");
            return;
        }
        int typeTest = this.AltComboBox.getSelectedIndex();
        HypothesisTestMatchedPairs ht = new HypothesisTestMatchedPairs(n, mu, s, confidenceLevel, typeTest);
        text = text + "Null hypothesis: &mu; = " + mu + "<br>";
        text = text + "Alternative hypothesis: &mu; ";
        text = typeTest == HypothesisTest.LEFT_TAIL ? text + "&lt;" : (typeTest == HypothesisTest.RIGHT_TAIL ? text + "&gt;" : text + "&ne;");
        text = text + " " + mu + "<br>";
        text = text + "<br><table border='1'>";
        text = text + "<tr><td>N</td><td>Sample Mean</td><td>Stdev</td>";
        text = text + "<td>Significance Level</td></td><td>Critical Value</td><td>Test Statistic t</td><td>p-Value</td></tr>";
        text = text + "<tr><td>" + n + "</td><td>" + HelperFunctions.formatFloat(mean, 3) + "</td><td>" + HelperFunctions.formatFloat(s, 3) + "</td><td>" + HelperFunctions.formatFloat(1.0 - confidenceLevel, 2) + "</td><td>" + ht.criticalValue() + "</td><td>" + HelperFunctions.formatFloat(ht.testStatistics(mean), 3) + "</td><td>" + HelperFunctions.formatFloat(ht.pValue(mean), 4) + "</td></tr></table>";
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void ConfidenceTextFieldFocusLost(FocusEvent evt) {
        try {
            String confString = this.ConfidenceTextField.getText();
            double conf = Double.parseDouble(confString);
            double sig = 1.0 - conf;
            this.SigTextField.setText(String.format("%." + HelperFunctions.getNumDecimalPlaces(confString) + "f", sig));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void ConfRadioButtonStateChanged(ChangeEvent evt) {
        if (this.ConfRadioButton.isSelected()) {
            this.ConfidenceTextField.setEnabled(true);
            this.ConfLabel.setEnabled(true);
        } else {
            this.ConfidenceTextField.setEnabled(false);
            this.ConfLabel.setEnabled(false);
        }
    }

    private void SigRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SigRadioButton.isSelected()) {
            this.SigTextField.setEnabled(true);
            this.SigLabel.setEnabled(true);
        } else {
            this.SigTextField.setEnabled(false);
            this.SigLabel.setEnabled(false);
        }
    }

    private void SigTextFieldFocusLost(FocusEvent evt) {
        try {
            String sigString = this.SigTextField.getText();
            double sig = Double.parseDouble(sigString);
            double conf = 1.0 - sig;
            this.ConfidenceTextField.setText(String.format("%." + HelperFunctions.getNumDecimalPlaces(sigString) + "f", conf));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

