/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.hytest;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.BasicStatistics;
import org.statcato.statistics.inferential.HypothesisTest;
import org.statcato.statistics.inferential.HypothesisTest2Var;
import org.statcato.utils.HelperFunctions;

public class HyTest2PopVarDialog
extends StatcatoDialog {
    private JComboBox AltComboBox;
    private JButton CancelButton;
    private JLabel ConfLabel;
    private JRadioButton ConfRadioButton;
    private JTextField ConfidenceTextField;
    private JComboBox LabelsComboBox;
    private JButton OKButton;
    private JComboBox Pop1ComboBox;
    private JComboBox Pop2ComboBox;
    private JRadioButton Sample1ColRadioButton;
    private JRadioButton Sample2ColRadioButton;
    private JLabel SigLabel;
    private JPanel SigPanel;
    private JRadioButton SigRadioButton;
    private JTextField SigTextField;
    private JTextField Stdev1TextField;
    private JTextField Stdev2TextField;
    private JRadioButton StdevRadioButton;
    private JRadioButton SummaryRadioButton;
    private JComboBox ValuesComboBox;
    private JTextField Var1TextField;
    private JTextField Var2TextField;
    private JRadioButton VarRadioButton;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTextField n1TextField;
    private JTextField n2TextField;

    public HyTest2PopVarDialog(Frame parent, boolean modal, Statcato mTab) {
        super(parent, modal);
        this.initComponents();
        this.app = mTab;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.Sample1ColRadioButton);
        group1.add(this.Sample2ColRadioButton);
        group1.add(this.SummaryRadioButton);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.StdevRadioButton);
        group2.add(this.VarRadioButton);
        ButtonGroup group4 = new ButtonGroup();
        group4.add(this.SigRadioButton);
        group4.add(this.ConfRadioButton);
        this.ParentSpreadsheet.populateComboBox(this.LabelsComboBox);
        this.ParentSpreadsheet.populateComboBox(this.ValuesComboBox);
        this.ParentSpreadsheet.populateComboBox(this.Pop1ComboBox);
        this.ParentSpreadsheet.populateComboBox(this.Pop2ComboBox);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("stat-hytest-2var");
        this.name = "Hypothesis Test: 2-Population Variances";
        this.description = "For performing calculations for testing claims about the two population variances.";
        this.helpStrings.add("The sample data can be inputted in one of three ways...");
        this.helpStrings.add("Samples in one column: The population labels of samples are in one column of the datasheet, and the individual samples are in another column.");
        this.helpStrings.add("Samples in two columns: The samples of the two population are in two separate columns.");
        this.helpStrings.add("Summarized sample data: The sample size and standard deviation/variance of each sample are provided.");
        this.helpStrings.add("Specify the significance or confidence level.");
        this.helpStrings.add("Select the form of the alternative hypothesis.");
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.LabelsComboBox);
        this.updateComboBox(this.ValuesComboBox);
        this.updateComboBox(this.Pop1ComboBox);
        this.updateComboBox(this.Pop2ComboBox);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel2 = new JPanel();
        this.AltComboBox = new JComboBox();
        this.jLabel11 = new JLabel();
        this.jPanel3 = new JPanel();
        this.SummaryRadioButton = new JRadioButton();
        this.Var1TextField = new JTextField();
        this.VarRadioButton = new JRadioButton();
        this.n1TextField = new JTextField();
        this.Stdev1TextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.n2TextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel7 = new JLabel();
        this.StdevRadioButton = new JRadioButton();
        this.ValuesComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.Sample1ColRadioButton = new JRadioButton();
        this.Pop1ComboBox = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jLabel3 = new JLabel();
        this.LabelsComboBox = new JComboBox();
        this.Stdev2TextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.Var2TextField = new JTextField();
        this.Pop2ComboBox = new JComboBox();
        this.Sample2ColRadioButton = new JRadioButton();
        this.SigPanel = new JPanel();
        this.SigLabel = new JLabel();
        this.ConfidenceTextField = new JTextField();
        this.ConfRadioButton = new JRadioButton();
        this.SigRadioButton = new JRadioButton();
        this.SigTextField = new JTextField();
        this.ConfLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Hypothesis Test: 2-Population Variances");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HyTest2PopVarDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HyTest2PopVarDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Alternative Hypothesis"));
        this.AltComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Less than", "Not Equal to", "Greater than"}));
        this.AltComboBox.setSelectedIndex(1);
        this.jLabel11.setText("Alternative Hypothesis:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.AltComboBox, -2, -1, -2).addContainerGap(85, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.AltComboBox, -2, -1, -2)).addContainerGap()));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.SummaryRadioButton.setText("Summarized sample data");
        this.SummaryRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest2PopVarDialog.this.SummaryRadioButtonStateChanged(evt);
            }
        });
        this.Var1TextField.setEnabled(false);
        this.VarRadioButton.setText("Variance");
        this.VarRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest2PopVarDialog.this.VarRadioButtonStateChanged(evt);
            }
        });
        this.n1TextField.setEnabled(false);
        this.Stdev1TextField.setEnabled(false);
        this.jLabel2.setText("Values in column:");
        this.n2TextField.setEnabled(false);
        this.jLabel4.setText("Population 2:");
        this.jLabel7.setText("Sample Size");
        this.StdevRadioButton.setSelected(true);
        this.StdevRadioButton.setText("Standard Deviation");
        this.StdevRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest2PopVarDialog.this.StdevRadioButtonStateChanged(evt);
            }
        });
        this.jLabel1.setText("Labels in column:");
        this.Sample1ColRadioButton.setSelected(true);
        this.Sample1ColRadioButton.setText("Samples in one column");
        this.Sample1ColRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest2PopVarDialog.this.Sample1ColRadioButtonStateChanged(evt);
            }
        });
        this.Pop1ComboBox.setEnabled(false);
        this.jLabel6.setText("Population 2:");
        this.jLabel3.setText("Population 1:");
        this.Stdev2TextField.setEnabled(false);
        this.jLabel5.setText("Population 1:");
        this.Var2TextField.setEnabled(false);
        this.Pop2ComboBox.setEnabled(false);
        this.Sample2ColRadioButton.setText("Samples in two columns");
        this.Sample2ColRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest2PopVarDialog.this.Sample2ColRadioButtonStateChanged(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel6)).addGap(27, 27, 27).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.n2TextField, -2, 68, -2).addComponent(this.n1TextField, -2, 69, -2))).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.StdevRadioButton).addGroup(jPanel3Layout.createSequentialGroup().addGap(29, 29, 29).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.Stdev2TextField, -2, 69, -2).addComponent(this.Stdev1TextField, -2, 71, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.VarRadioButton).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.Var2TextField, GroupLayout.Alignment.LEADING).addComponent(this.Var1TextField, GroupLayout.Alignment.LEADING, -2, 69, -2)))).addComponent(this.SummaryRadioButton).addComponent(this.Sample1ColRadioButton).addComponent(this.Sample2ColRadioButton).addGroup(jPanel3Layout.createSequentialGroup().addGap(21, 21, 21).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.ValuesComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.LabelsComboBox, -2, 93, -2))).addGroup(GroupLayout.Alignment.LEADING, jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel3)).addGap(26, 26, 26).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.Pop2ComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.Pop1ComboBox, -2, 89, -2)))))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.Sample1ColRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.LabelsComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.ValuesComboBox, -2, -1, -2)).addGap(23, 23, 23).addComponent(this.Sample2ColRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, GroupLayout.Alignment.TRAILING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.Pop1ComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.Pop2ComboBox, -2, -1, -2))).addGap(18, 18, 18).addComponent(this.SummaryRadioButton).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.StdevRadioButton).addComponent(this.VarRadioButton).addComponent(this.jLabel7)).addGap(28, 28, 28).addComponent(this.Var2TextField, -2, -1, -2)).addGroup(jPanel3Layout.createSequentialGroup().addGap(25, 25, 25).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.n1TextField, -2, -1, -2).addComponent(this.Stdev1TextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.n2TextField, -2, -1, -2).addComponent(this.Stdev2TextField, -2, -1, -2))).addComponent(this.Var1TextField, -2, -1, -2)))).addContainerGap()));
        this.SigPanel.setBorder(BorderFactory.createTitledBorder("Significance"));
        this.SigLabel.setText("0 - 1.00 (e.g. 0.05)");
        this.ConfidenceTextField.setText("0.95");
        this.ConfidenceTextField.setEnabled(false);
        this.ConfidenceTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                HyTest2PopVarDialog.this.ConfidenceTextFieldFocusLost(evt);
            }
        });
        this.ConfRadioButton.setText("Confidence Level:");
        this.ConfRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest2PopVarDialog.this.ConfRadioButtonStateChanged(evt);
            }
        });
        this.SigRadioButton.setSelected(true);
        this.SigRadioButton.setText("Significance Level:");
        this.SigRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest2PopVarDialog.this.SigRadioButtonStateChanged(evt);
            }
        });
        this.SigTextField.setText("0.05");
        this.SigTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                HyTest2PopVarDialog.this.SigTextFieldFocusLost(evt);
            }
        });
        this.ConfLabel.setText("0 - 1.00 (e.g. 0.95)");
        this.ConfLabel.setEnabled(false);
        GroupLayout SigPanelLayout = new GroupLayout(this.SigPanel);
        this.SigPanel.setLayout(SigPanelLayout);
        SigPanelLayout.setHorizontalGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(SigPanelLayout.createSequentialGroup().addContainerGap().addGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ConfRadioButton).addComponent(this.SigRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ConfidenceTextField, -2, 81, -2).addComponent(this.SigTextField, -2, 79, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ConfLabel).addComponent(this.SigLabel))));
        SigPanelLayout.setVerticalGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(SigPanelLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.SigRadioButton).addComponent(this.SigTextField, -2, -1, -2).addComponent(this.SigLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ConfRadioButton).addComponent(this.ConfidenceTextField, -2, -1, -2).addComponent(this.ConfLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -2, -1, -2).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.SigPanel, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGap(324, 324, 324).addComponent(this.OKButton, -2, 58, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.SigPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2)).addComponent(this.jPanel3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 39, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton))));
        this.pack();
    }

    private void SummaryRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SummaryRadioButton.isSelected()) {
            this.n1TextField.setEnabled(true);
            this.n2TextField.setEnabled(true);
            if (this.StdevRadioButton.isSelected()) {
                this.Stdev1TextField.setEnabled(true);
                this.Stdev2TextField.setEnabled(true);
                this.Var1TextField.setEnabled(false);
                this.Var2TextField.setEnabled(false);
            } else {
                this.Stdev1TextField.setEnabled(false);
                this.Stdev2TextField.setEnabled(false);
                this.Var1TextField.setEnabled(true);
                this.Var2TextField.setEnabled(true);
            }
        } else {
            this.n1TextField.setEnabled(false);
            this.n2TextField.setEnabled(false);
            this.Stdev1TextField.setEnabled(false);
            this.Stdev2TextField.setEnabled(false);
            this.Var1TextField.setEnabled(false);
            this.Var2TextField.setEnabled(false);
        }
    }

    private void Sample1ColRadioButtonStateChanged(ChangeEvent evt) {
        if (this.Sample1ColRadioButton.isSelected()) {
            this.LabelsComboBox.setEnabled(true);
            this.ValuesComboBox.setEnabled(true);
        } else {
            this.LabelsComboBox.setEnabled(false);
            this.ValuesComboBox.setEnabled(false);
        }
    }

    private void Sample2ColRadioButtonStateChanged(ChangeEvent evt) {
        if (this.Sample2ColRadioButton.isSelected()) {
            this.Pop1ComboBox.setEnabled(true);
            this.Pop2ComboBox.setEnabled(true);
        } else {
            this.Pop1ComboBox.setEnabled(false);
            this.Pop2ComboBox.setEnabled(false);
        }
    }

    private void StdevRadioButtonStateChanged(ChangeEvent evt) {
        if (this.StdevRadioButton.isSelected()) {
            if (this.SummaryRadioButton.isSelected()) {
                this.Stdev1TextField.setEnabled(true);
                this.Stdev2TextField.setEnabled(true);
            } else {
                this.Stdev1TextField.setEnabled(false);
                this.Stdev2TextField.setEnabled(false);
            }
        } else {
            this.Stdev1TextField.setEnabled(false);
            this.Stdev2TextField.setEnabled(false);
        }
    }

    private void VarRadioButtonStateChanged(ChangeEvent evt) {
        if (this.VarRadioButton.isSelected()) {
            if (this.SummaryRadioButton.isSelected()) {
                this.Var1TextField.setEnabled(true);
                this.Var2TextField.setEnabled(true);
            } else {
                this.Var1TextField.setEnabled(false);
                this.Var2TextField.setEnabled(false);
            }
        } else {
            this.Var1TextField.setEnabled(false);
            this.Var2TextField.setEnabled(false);
        }
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        double confidenceLevel;
        this.app.compoundEdit = new DialogEdit("hypothesis test 2 variance");
        int n1 = 0;
        int n2 = 0;
        double var1 = 0.0;
        double var2 = 0.0;
        double stdev1 = 0.0;
        double stdev2 = 0.0;
        String heading = "Hypothesis Test - Two population variances:";
        String text = "";
        if (this.ConfRadioButton.isSelected()) {
            try {
                confidenceLevel = Double.parseDouble(this.ConfidenceTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
                return;
            }
            if (confidenceLevel <= 0.0 || confidenceLevel >= 1.0) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
                return;
            }
        } else {
            try {
                confidenceLevel = 1.0 - Double.parseDouble(this.SigTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the significance level.");
                return;
            }
            if (confidenceLevel <= 0.0 || confidenceLevel >= 1.0) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the significance level.");
                return;
            }
        }
        heading = heading + "  confidence level = " + String.format("%." + HelperFunctions.getNumDecimalPlaces(this.ConfidenceTextField.getText()) + "f", confidenceLevel);
        if (this.SummaryRadioButton.isSelected()) {
            try {
                n1 = Integer.parseInt(this.n1TextField.getText());
                n2 = Integer.parseInt(this.n2TextField.getText());
                if (n1 < 1 || n2 < 1) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a positive integer for the sample sizes.");
                return;
            }
            if (this.StdevRadioButton.isSelected()) {
                try {
                    stdev1 = Double.parseDouble(this.Stdev1TextField.getText());
                    stdev2 = Double.parseDouble(this.Stdev2TextField.getText());
                    if (stdev1 < 0.0 || stdev2 < 0.0) {
                        throw new NumberFormatException();
                    }
                    var1 = stdev1 * stdev1;
                    var2 = stdev2 * stdev2;
                }
                catch (NumberFormatException e) {
                    this.app.showErrorDialog("Enter valid sample standard deviations.");
                    return;
                }
            } else {
                try {
                    var1 = Double.parseDouble(this.Var1TextField.getText());
                    var2 = Double.parseDouble(this.Var2TextField.getText());
                    if (var1 < 0.0 || var2 < 0.0) {
                        throw new NumberFormatException();
                    }
                    stdev1 = Math.sqrt(var1);
                    stdev2 = Math.sqrt(var2);
                }
                catch (NumberFormatException e) {
                    this.app.showErrorDialog("Enter valid sample variances.");
                    return;
                }
            }
        } else {
            Vector<Double> InputVector2;
            Vector<Double> InputVector1;
            block33: {
                Vector Vector1 = null;
                Vector Vector2 = null;
                InputVector1 = null;
                InputVector2 = null;
                if (this.Sample1ColRadioButton.isSelected()) {
                    String columnLabel = this.LabelsComboBox.getSelectedItem().toString();
                    text = text + "Population labels in " + columnLabel + "<br>";
                    if (columnLabel.equals("")) {
                        this.app.showErrorDialog("Select the column containing category labels.");
                        return;
                    }
                    int column = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
                    Vector<Cell> LabelsVector = this.ParentSpreadsheet.getColumn(column);
                    columnLabel = this.ValuesComboBox.getSelectedItem().toString();
                    text = text + "Samples values in " + columnLabel + "<br>";
                    if (columnLabel.equals("")) {
                        this.app.showErrorDialog("Select the column containing sample values.");
                        return;
                    }
                    column = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
                    Vector<Cell> ValuesVector = this.ParentSpreadsheet.getColumn(column);
                    try {
                        Object[] returnValues = HelperFunctions.splitValuesVectorByLabels(LabelsVector, ValuesVector);
                        text = text + "Population 1 = " + returnValues[0] + "<br>";
                        text = text + "Population 2 = " + returnValues[2] + "<br>";
                        Vector1 = (Vector)returnValues[1];
                        Vector2 = (Vector)returnValues[3];
                        InputVector1 = HelperFunctions.ConvertInputVectorToDoubles(Vector1);
                        if (InputVector1 == null) {
                            this.app.showErrorDialog("Invalid input column " + returnValues[0] + ": all data must be numbers.");
                            return;
                        }
                        InputVector2 = HelperFunctions.ConvertInputVectorToDoubles(Vector2);
                        if (InputVector2 == null) {
                            this.app.showErrorDialog("Invalid input column " + returnValues[2] + ": all data must be numbers.");
                            return;
                        }
                        break block33;
                    }
                    catch (Exception e) {
                        this.app.showErrorDialog(e.getMessage());
                        return;
                    }
                }
                if (this.Sample2ColRadioButton.isSelected()) {
                    String columnLabel = this.Pop1ComboBox.getSelectedItem().toString();
                    text = text + "Samples of population 1 in " + columnLabel + "<br>";
                    if (columnLabel.equals("")) {
                        this.app.showErrorDialog("Select the column containing sample values for the first population.");
                        return;
                    }
                    int column = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
                    Vector1 = this.ParentSpreadsheet.getColumn(column);
                    InputVector1 = HelperFunctions.ConvertInputVectorToDoubles(Vector1);
                    if (InputVector1 == null) {
                        this.app.showErrorDialog("Invalid input column " + columnLabel + ": all data must be numbers.");
                        return;
                    }
                    columnLabel = this.Pop2ComboBox.getSelectedItem().toString();
                    text = text + "Samples of population 2 in " + columnLabel + "<br>";
                    if (columnLabel.equals("")) {
                        this.app.showErrorDialog("Select the column containing sample values for the second population.");
                        return;
                    }
                    column = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
                    Vector2 = this.ParentSpreadsheet.getColumn(column);
                    InputVector2 = HelperFunctions.ConvertInputVectorToDoubles(Vector2);
                    if (InputVector2 == null) {
                        this.app.showErrorDialog("Invalid input column " + columnLabel + ": all data must be numbers.");
                        return;
                    }
                }
            }
            n1 = BasicStatistics.Nnonmissing(InputVector1);
            var1 = BasicStatistics.variance(InputVector1);
            stdev1 = BasicStatistics.stdev(InputVector1);
            n2 = BasicStatistics.Nnonmissing(InputVector2);
            var2 = BasicStatistics.variance(InputVector2);
            stdev2 = BasicStatistics.stdev(InputVector2);
        }
        int typeTest = this.AltComboBox.getSelectedIndex();
        text = text + "<br><table border='1'>";
        text = text + "<tr><td>&nbsp;</td><td>N</td>";
        text = text + "<td>Stdev</td><td>Variance</td>";
        text = text + "</tr>";
        text = text + "<tr><td>Population 1</td><td>" + n1 + "</td><td>" + HelperFunctions.formatFloat(stdev1, 5) + "</td>" + "<td>" + HelperFunctions.formatFloat(var1, 5) + "</td>";
        text = text + "</tr>";
        text = text + "<tr><td>Population 2</td><td>" + n2 + "</td><td>" + HelperFunctions.formatFloat(stdev2, 5) + "</td>" + "<td>" + HelperFunctions.formatFloat(var2, 5) + "</td>";
        text = text + "</tr></table><br>";
        text = text + "Null hypothesis: &sigma;<sub>1</sub><sup>2</sup> = &sigma;<sub>2</sub><sup>2</sup><br>";
        text = text + "Alternative hypothesis: &sigma;<sub>1</sub><sup>2</sup> ";
        text = typeTest == HypothesisTest.LEFT_TAIL ? text + "&lt;" : (typeTest == HypothesisTest.RIGHT_TAIL ? text + "&gt;" : text + "&ne;");
        text = text + "&sigma;<sub>2</sub><sup>2</sup> <br>";
        HypothesisTest2Var ht = new HypothesisTest2Var(n1, n2, var1, var2, confidenceLevel, typeTest);
        text = text + "<br><table border='1'>";
        text = text + "<tr><td>Significance Level</td></td><td>Critical Value</td><td>Test Statistic F</td><td>p-Value</td></tr>";
        text = text + "<tr><td>" + HelperFunctions.formatFloat(1.0 - confidenceLevel, 2) + "</td><td>" + ht.criticalValue() + "</td><td>" + HelperFunctions.formatFloat(ht.testStatistics(), 3) + "</td><td>" + HelperFunctions.formatFloat(ht.pValue(), 4) + "</td></tr></table>";
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void ConfidenceTextFieldFocusLost(FocusEvent evt) {
        try {
            String confString = this.ConfidenceTextField.getText();
            double conf = Double.parseDouble(confString);
            double sig = 1.0 - conf;
            this.SigTextField.setText(String.format("%." + HelperFunctions.getNumDecimalPlaces(confString) + "f", sig));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void ConfRadioButtonStateChanged(ChangeEvent evt) {
        if (this.ConfRadioButton.isSelected()) {
            this.ConfidenceTextField.setEnabled(true);
            this.ConfLabel.setEnabled(true);
        } else {
            this.ConfidenceTextField.setEnabled(false);
            this.ConfLabel.setEnabled(false);
        }
    }

    private void SigRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SigRadioButton.isSelected()) {
            this.SigTextField.setEnabled(true);
            this.SigLabel.setEnabled(true);
        } else {
            this.SigTextField.setEnabled(false);
            this.SigLabel.setEnabled(false);
        }
    }

    private void SigTextFieldFocusLost(FocusEvent evt) {
        try {
            String sigString = this.SigTextField.getText();
            double sig = Double.parseDouble(sigString);
            double conf = 1.0 - sig;
            this.ConfidenceTextField.setText(String.format("%." + HelperFunctions.getNumDecimalPlaces(sigString) + "f", conf));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

