/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.hytest;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.BasicStatistics;
import org.statcato.statistics.inferential.HypothesisTest;
import org.statcato.statistics.inferential.HypothesisTest2MeanSigmaKnown;
import org.statcato.statistics.inferential.HypothesisTest2MeanSigmaUnknown;
import org.statcato.utils.HelperFunctions;

public class HyTest2PopMeanDialog
extends StatcatoDialog {
    private JComboBox AltComboBox;
    private JButton CancelButton;
    private JLabel ConfLabel;
    private JRadioButton ConfRadioButton;
    private JTextField ConfidenceTextField;
    private JTextField HyTextField;
    private JComboBox LabelsComboBox;
    private JButton OKButton;
    private JComboBox Pop1ComboBox;
    private JComboBox Pop2ComboBox;
    private JRadioButton Sample1ColRadioButton;
    private JRadioButton Sample2ColRadioButton;
    private JLabel SigLabel;
    private JPanel SigPanel;
    private JRadioButton SigRadioButton;
    private JTextField SigTextField;
    private JTextField Sigma1TextField;
    private JTextField Sigma2TextField;
    private JCheckBox SigmaKnownCheckBox;
    private JRadioButton SummaryRadioButton;
    private JComboBox ValuesComboBox;
    private JCheckBox VarEqualCheckBox;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTextField mean1TextField;
    private JTextField mean2TextField;
    private JTextField n1TextField;
    private JTextField n2TextField;
    private JTextField stdev1TextField;
    private JTextField stdev2TextField;

    public HyTest2PopMeanDialog(Frame parent, boolean modal, Statcato mTab) {
        super(parent, modal);
        this.initComponents();
        this.app = mTab;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.Sample1ColRadioButton);
        group1.add(this.Sample2ColRadioButton);
        group1.add(this.SummaryRadioButton);
        ButtonGroup group3 = new ButtonGroup();
        group3.add(this.SigRadioButton);
        group3.add(this.ConfRadioButton);
        this.ParentSpreadsheet.populateComboBox(this.LabelsComboBox);
        this.ParentSpreadsheet.populateComboBox(this.ValuesComboBox);
        this.ParentSpreadsheet.populateComboBox(this.Pop1ComboBox);
        this.ParentSpreadsheet.populateComboBox(this.Pop2ComboBox);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("stat-hytest-2mean");
        this.name = "Hypothesis Test: 2-Population Means";
        this.description = "For performing calculations for testing claims about the difference of two population means from two independent samples. ";
        this.helpStrings.add("The sample data can be provided in one of three ways...");
        this.helpStrings.add("Samples in one column: The population labels of samples are in one column of the Datasheet, and the individual samples are in another column.");
        this.helpStrings.add("Samples in two columns: The samples of the two population are in two separate columns.");
        this.helpStrings.add("Summarized sample data: The sample size, mean, and standard deviation of each of the two populations are provided.");
        this.helpStrings.add("If population standard deviations are known, check the appropriate check box and provide the standard deviations.");
        this.helpStrings.add("Check the Assume population variances are equal check box if the population variances are assumed equal.");
        this.helpStrings.add("Specify the signficance or confidence level.");
        this.helpStrings.add("Select the form of alternative hypothesis and enter the Hypothesized Mean in the provided text box.");
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.LabelsComboBox);
        this.updateComboBox(this.ValuesComboBox);
        this.updateComboBox(this.Pop1ComboBox);
        this.updateComboBox(this.Pop2ComboBox);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.Sample2ColRadioButton = new JRadioButton();
        this.n2TextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.Pop2ComboBox = new JComboBox();
        this.jLabel8 = new JLabel();
        this.stdev1TextField = new JTextField();
        this.stdev2TextField = new JTextField();
        this.SummaryRadioButton = new JRadioButton();
        this.n1TextField = new JTextField();
        this.LabelsComboBox = new JComboBox();
        this.Pop1ComboBox = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.mean2TextField = new JTextField();
        this.Sample1ColRadioButton = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel3 = new JLabel();
        this.ValuesComboBox = new JComboBox();
        this.mean1TextField = new JTextField();
        this.jPanel2 = new JPanel();
        this.Sigma2TextField = new JTextField();
        this.Sigma1TextField = new JTextField();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.VarEqualCheckBox = new JCheckBox();
        this.SigmaKnownCheckBox = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.HyTextField = new JTextField();
        this.jLabel15 = new JLabel();
        this.AltComboBox = new JComboBox();
        this.jLabel14 = new JLabel();
        this.SigPanel = new JPanel();
        this.SigLabel = new JLabel();
        this.ConfidenceTextField = new JTextField();
        this.ConfRadioButton = new JRadioButton();
        this.SigRadioButton = new JRadioButton();
        this.SigTextField = new JTextField();
        this.ConfLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Hypothesis Test: 2-Population Means");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HyTest2PopMeanDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HyTest2PopMeanDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.jLabel1.setText("Labels in column:");
        this.Sample2ColRadioButton.setText("Samples in two columns");
        this.Sample2ColRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest2PopMeanDialog.this.Sample2ColRadioButtonStateChanged(evt);
            }
        });
        this.n2TextField.setEnabled(false);
        this.jLabel5.setText("Population 1:");
        this.Pop2ComboBox.setEnabled(false);
        this.jLabel8.setText("Mean");
        this.stdev1TextField.setEnabled(false);
        this.stdev2TextField.setEnabled(false);
        this.SummaryRadioButton.setText("Summarized sample data");
        this.SummaryRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest2PopMeanDialog.this.SummaryRadioButtonStateChanged(evt);
            }
        });
        this.n1TextField.setEnabled(false);
        this.Pop1ComboBox.setEnabled(false);
        this.jLabel4.setText("Population 2:");
        this.jLabel6.setText("Population 2:");
        this.jLabel7.setText("Sample Size");
        this.mean2TextField.setEnabled(false);
        this.Sample1ColRadioButton.setSelected(true);
        this.Sample1ColRadioButton.setText("Samples in one column");
        this.Sample1ColRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest2PopMeanDialog.this.Sample1ColRadioButtonStateChanged(evt);
            }
        });
        this.jLabel2.setText("Values in column:");
        this.jLabel9.setText("Standard Deviation");
        this.jLabel3.setText("Population 1:");
        this.mean1TextField.setEnabled(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(21, 21, 21).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel5)).addGap(35, 35, 35).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.n1TextField, GroupLayout.Alignment.LEADING).addComponent(this.n2TextField, GroupLayout.Alignment.LEADING, -2, 68, -2)).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel8, -1, 65, Short.MAX_VALUE).addComponent(this.mean1TextField).addComponent(this.mean2TextField)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.stdev2TextField, -2, -1, -2).addComponent(this.jLabel9).addComponent(this.stdev1TextField, -2, 69, -2)).addGap(254, 254, 254)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SummaryRadioButton).addComponent(this.Sample1ColRadioButton).addComponent(this.Sample2ColRadioButton).addGroup(jPanel1Layout.createSequentialGroup().addGap(21, 21, 21).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.ValuesComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.LabelsComboBox, -2, 93, -2))).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel3)).addGap(26, 26, 26).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.Pop2ComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.Pop1ComboBox, -2, 89, -2)))))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 137, -2))).addContainerGap()));
        jPanel1Layout.linkSize(0, this.n1TextField, this.n2TextField);
        jPanel1Layout.linkSize(0, this.stdev1TextField, this.stdev2TextField);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.Sample1ColRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.LabelsComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.ValuesComboBox, -2, -1, -2)).addGap(23, 23, 23).addComponent(this.Sample2ColRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.Pop1ComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.Pop2ComboBox, -2, -1, -2))).addGap(18, 18, 18).addComponent(this.SummaryRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jLabel8).addComponent(this.jLabel9)).addGap(11, 11, 11).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.n1TextField, -2, -1, -2).addComponent(this.mean1TextField, -2, -1, -2).addComponent(this.stdev1TextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.n2TextField, -2, -1, -2).addComponent(this.mean2TextField, -2, -1, -2).addComponent(this.stdev2TextField, -2, -1, -2)).addContainerGap(41, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Population Standard Deviations/Variances"));
        this.Sigma2TextField.setEnabled(false);
        this.Sigma1TextField.setEnabled(false);
        this.jLabel10.setText("<html>&sigma;<sub>1</sub>:</html>");
        this.jLabel11.setText("<html>&sigma;<sub>2</sub>:</html>");
        this.VarEqualCheckBox.setText("Assume population variances are equal");
        this.SigmaKnownCheckBox.setText("Population standard deviations known");
        this.SigmaKnownCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest2PopMeanDialog.this.SigmaKnownCheckBoxStateChanged(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.VarEqualCheckBox).addGroup(jPanel2Layout.createSequentialGroup().addGap(32, 32, 32).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel10, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.Sigma1TextField, -2, 90, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel11, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.Sigma2TextField)))).addComponent(this.SigmaKnownCheckBox)).addContainerGap(91, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(0, this.Sigma1TextField, this.Sigma2TextField);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.SigmaKnownCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10, -2, -1, -2).addComponent(this.Sigma1TextField, -2, -1, -2)).addGap(8, 8, 8).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11, -2, -1, -2).addComponent(this.Sigma2TextField, -2, -1, -2)).addGap(13, 13, 13).addComponent(this.VarEqualCheckBox).addContainerGap(7, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Alternative Hypothesis"));
        this.HyTextField.setText("0");
        this.jLabel15.setText("Hypothesized Mean Difference:");
        this.AltComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Less than", "Not Equal to", "Greater than"}));
        this.AltComboBox.setSelectedIndex(1);
        this.jLabel14.setText("Alternative Hypothesis:");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.HyTextField, -2, 78, -2)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.AltComboBox, -2, -1, -2))).addContainerGap(70, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.AltComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel15).addComponent(this.HyTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.SigPanel.setBorder(BorderFactory.createTitledBorder("Significance"));
        this.SigLabel.setText("0 - 1.00 (e.g. 0.05)");
        this.ConfidenceTextField.setText("0.95");
        this.ConfidenceTextField.setEnabled(false);
        this.ConfidenceTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                HyTest2PopMeanDialog.this.ConfidenceTextFieldFocusLost(evt);
            }
        });
        this.ConfRadioButton.setText("Confidence Level:");
        this.ConfRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest2PopMeanDialog.this.ConfRadioButtonStateChanged(evt);
            }
        });
        this.SigRadioButton.setSelected(true);
        this.SigRadioButton.setText("Significance Level:");
        this.SigRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest2PopMeanDialog.this.SigRadioButtonStateChanged(evt);
            }
        });
        this.SigTextField.setText("0.05");
        this.SigTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                HyTest2PopMeanDialog.this.SigTextFieldFocusLost(evt);
            }
        });
        this.ConfLabel.setText("0 - 1.00 (e.g. 0.95)");
        this.ConfLabel.setEnabled(false);
        GroupLayout SigPanelLayout = new GroupLayout(this.SigPanel);
        this.SigPanel.setLayout(SigPanelLayout);
        SigPanelLayout.setHorizontalGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(SigPanelLayout.createSequentialGroup().addContainerGap().addGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ConfRadioButton).addComponent(this.SigRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SigTextField, -2, 79, -2).addComponent(this.ConfidenceTextField, -2, 81, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ConfLabel).addComponent(this.SigLabel)).addContainerGap()));
        SigPanelLayout.linkSize(0, this.ConfidenceTextField, this.SigTextField);
        SigPanelLayout.setVerticalGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(SigPanelLayout.createSequentialGroup().addGap(11, 11, 11).addGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.SigRadioButton).addComponent(this.SigTextField, -2, -1, -2).addComponent(this.SigLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ConfRadioButton).addComponent(this.ConfidenceTextField, -2, -1, -2).addComponent(this.ConfLabel)).addContainerGap(21, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, 443, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.SigPanel, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jPanel3, -2, -1, -2))).addGroup(layout.createSequentialGroup().addGap(283, 283, 283).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addGap(1, 1, 1).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SigPanel, -2, -1, -2))).addGap(27, 27, 27).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.CancelButton).addComponent(this.OKButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void SummaryRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SummaryRadioButton.isSelected()) {
            this.n1TextField.setEnabled(true);
            this.n2TextField.setEnabled(true);
            this.mean1TextField.setEnabled(true);
            this.mean2TextField.setEnabled(true);
            if (this.SigmaKnownCheckBox.isSelected()) {
                this.stdev1TextField.setEnabled(false);
                this.stdev2TextField.setEnabled(false);
            } else {
                this.stdev1TextField.setEnabled(true);
                this.stdev2TextField.setEnabled(true);
            }
        } else {
            this.n1TextField.setEnabled(false);
            this.n2TextField.setEnabled(false);
            this.mean1TextField.setEnabled(false);
            this.mean2TextField.setEnabled(false);
            this.stdev1TextField.setEnabled(false);
            this.stdev2TextField.setEnabled(false);
        }
    }

    private void Sample1ColRadioButtonStateChanged(ChangeEvent evt) {
        if (this.Sample1ColRadioButton.isSelected()) {
            this.LabelsComboBox.setEnabled(true);
            this.ValuesComboBox.setEnabled(true);
        } else {
            this.LabelsComboBox.setEnabled(false);
            this.ValuesComboBox.setEnabled(false);
        }
    }

    private void Sample2ColRadioButtonStateChanged(ChangeEvent evt) {
        if (this.Sample2ColRadioButton.isSelected()) {
            this.Pop1ComboBox.setEnabled(true);
            this.Pop2ComboBox.setEnabled(true);
        } else {
            this.Pop1ComboBox.setEnabled(false);
            this.Pop2ComboBox.setEnabled(false);
        }
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        double confidenceLevel;
        this.app.compoundEdit = new DialogEdit("hypothesis test 2 mean");
        int n1 = 0;
        int n2 = 0;
        double xBar1 = 0.0;
        double xBar2 = 0.0;
        double stdev1 = 0.0;
        double stdev2 = 0.0;
        String heading = "Hypothesis Test - Two population means:";
        String text = "";
        if (this.ConfRadioButton.isSelected()) {
            try {
                confidenceLevel = Double.parseDouble(this.ConfidenceTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
                return;
            }
            if (confidenceLevel <= 0.0 || confidenceLevel >= 1.0) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
                return;
            }
        } else {
            try {
                confidenceLevel = 1.0 - Double.parseDouble(this.SigTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the significance level.");
                return;
            }
            if (confidenceLevel <= 0.0 || confidenceLevel >= 1.0) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the significance level.");
                return;
            }
        }
        heading = heading + "  confidence level = " + String.format("%." + HelperFunctions.getNumDecimalPlaces(this.ConfidenceTextField.getText()) + "f", confidenceLevel);
        if (this.SummaryRadioButton.isSelected()) {
            try {
                n1 = Integer.parseInt(this.n1TextField.getText());
                n2 = Integer.parseInt(this.n2TextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter an integer for the sample sizes.");
                return;
            }
            try {
                xBar1 = Double.parseDouble(this.mean1TextField.getText());
                xBar2 = Double.parseDouble(this.mean2TextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter valid sample means.");
                return;
            }
            if (!this.SigmaKnownCheckBox.isSelected()) {
                try {
                    stdev1 = Double.parseDouble(this.stdev1TextField.getText());
                    stdev2 = Double.parseDouble(this.stdev2TextField.getText());
                }
                catch (NumberFormatException e) {
                    this.app.showErrorDialog("Enter valid sample standard deviations.");
                    return;
                }
            }
        } else {
            Vector<Double> InputVector2;
            Vector<Double> InputVector1;
            block39: {
                int column;
                Vector Vector1 = null;
                Vector Vector2 = null;
                InputVector1 = null;
                InputVector2 = null;
                if (this.Sample1ColRadioButton.isSelected()) {
                    String columnLabel = this.LabelsComboBox.getSelectedItem().toString();
                    text = text + "Population labels in " + columnLabel + "<br>";
                    if (columnLabel.equals("")) {
                        this.app.showErrorDialog("Select the column containing category labels.");
                        return;
                    }
                    column = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
                    Vector<Cell> LabelsVector = this.ParentSpreadsheet.getColumn(column);
                    columnLabel = this.ValuesComboBox.getSelectedItem().toString();
                    text = text + "Samples values in " + columnLabel + "<br>";
                    if (columnLabel.equals("")) {
                        this.app.showErrorDialog("Select the column containing sample values.");
                        return;
                    }
                    column = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
                    Vector<Cell> ValuesVector = this.ParentSpreadsheet.getColumn(column);
                    try {
                        Object[] returnValues = HelperFunctions.splitValuesVectorByLabels(LabelsVector, ValuesVector);
                        text = text + "Population 1 = " + returnValues[0] + "<br>";
                        text = text + "Population 2 = " + returnValues[2] + "<br>";
                        Vector1 = (Vector)returnValues[1];
                        Vector2 = (Vector)returnValues[3];
                        InputVector1 = HelperFunctions.ConvertInputVectorToDoubles(Vector1);
                        if (InputVector1 == null) {
                            this.app.showErrorDialog("Invalid input column " + returnValues[0] + ": all data must be numbers.");
                            return;
                        }
                        InputVector2 = HelperFunctions.ConvertInputVectorToDoubles(Vector2);
                        if (InputVector2 == null) {
                            this.app.showErrorDialog("Invalid input column " + returnValues[2] + ": all data must be numbers.");
                            return;
                        }
                        break block39;
                    }
                    catch (Exception e) {
                        this.app.showErrorDialog(e.getMessage());
                        return;
                    }
                }
                if (this.Sample2ColRadioButton.isSelected()) {
                    String columnLabel = this.Pop1ComboBox.getSelectedItem().toString();
                    text = text + "Samples of population 1 in " + columnLabel + "<br>";
                    if (columnLabel.equals("")) {
                        this.app.showErrorDialog("Select the column containing sample values for the first population.");
                        return;
                    }
                    column = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
                    Vector1 = this.ParentSpreadsheet.getColumn(column);
                    InputVector1 = HelperFunctions.ConvertInputVectorToDoubles(Vector1);
                    if (InputVector1 == null) {
                        this.app.showErrorDialog("Invalid input column " + columnLabel + ": all data must be numbers.");
                        return;
                    }
                    columnLabel = this.Pop2ComboBox.getSelectedItem().toString();
                    text = text + "Samples of population 2 in " + columnLabel + "<br>";
                    if (columnLabel.equals("")) {
                        this.app.showErrorDialog("Select the column containing sample values for the second population.");
                        return;
                    }
                    column = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
                    Vector2 = this.ParentSpreadsheet.getColumn(column);
                    InputVector2 = HelperFunctions.ConvertInputVectorToDoubles(Vector2);
                    if (InputVector2 == null) {
                        this.app.showErrorDialog("Invalid input column " + columnLabel + ": all data must be numbers.");
                        return;
                    }
                }
            }
            n1 = BasicStatistics.Nnonmissing(InputVector1);
            xBar1 = BasicStatistics.mean(InputVector1);
            stdev1 = BasicStatistics.stdev(InputVector1);
            n2 = BasicStatistics.Nnonmissing(InputVector2);
            xBar2 = BasicStatistics.mean(InputVector2);
            stdev2 = BasicStatistics.stdev(InputVector2);
        }
        text = text + "<br><table border='1'>";
        text = text + "<tr><td>&nbsp;</td><td>N</td><td>Mean</td>";
        if (!this.SigmaKnownCheckBox.isSelected()) {
            text = text + "<td>Stdev</td>";
        }
        text = text + "</tr>";
        text = text + "<tr><td>Population 1</td><td>" + n1 + "</td><td>" + HelperFunctions.formatFloat(xBar1, 3) + "</td>";
        if (!this.SigmaKnownCheckBox.isSelected()) {
            text = text + "<td>" + HelperFunctions.formatFloat(stdev1, 3) + "</td>";
        }
        text = text + "</tr>";
        text = text + "<tr><td>Population 2</td><td>" + n2 + "</td><td>" + HelperFunctions.formatFloat(xBar2, 3) + "</td>";
        if (!this.SigmaKnownCheckBox.isSelected()) {
            text = text + "<td>" + HelperFunctions.formatFloat(stdev2, 3) + "</td>";
        }
        text = text + "</tr></table><br>";
        double diff = 0.0;
        try {
            diff = Double.parseDouble(this.HyTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a valid hypothesized difference.");
            return;
        }
        int typeTest = this.AltComboBox.getSelectedIndex();
        text = text + "Null hypothesis: &mu;<sub>1</sub> - &mu;<sub>2</sub> = " + diff + "<br>";
        text = text + "Alternative hypothesis: &mu;<sub>1</sub> - &mu;<sub>2</sub> ";
        text = typeTest == HypothesisTest.LEFT_TAIL ? text + "&lt;" : (typeTest == HypothesisTest.RIGHT_TAIL ? text + "&gt;" : text + "&ne;");
        text = text + diff + " <br>";
        if (this.VarEqualCheckBox.isSelected()) {
            text = text + "* Population variances are assumed equal. *<br>";
        }
        if (this.SigmaKnownCheckBox.isSelected()) {
            double sigma1 = 0.0;
            double sigma2 = 0.0;
            try {
                sigma1 = Double.parseDouble(this.Sigma1TextField.getText());
                sigma2 = Double.parseDouble(this.Sigma2TextField.getText());
                text = text + "* Population standard deviations are known. *<br>";
                text = text + "  &sigma<sub>1</sub> = " + sigma1 + ", &sigma<sub>2</sub> = " + sigma2;
                HypothesisTest2MeanSigmaKnown ht = new HypothesisTest2MeanSigmaKnown(n1, n2, xBar1, xBar2, sigma1, sigma2, diff, confidenceLevel, typeTest);
                text = text + "<br><table border='1'>";
                text = text + "<tr><td>Significance Level</td></td><td>Critical Value</td><td>Test Statistic Z</td><td>p-Value</td></tr>";
                text = text + "<tr><td>" + HelperFunctions.formatFloat(1.0 - confidenceLevel, 2) + "</td><td>" + ht.criticalValue() + "</td><td>" + HelperFunctions.formatFloat(ht.testStatistics(), 3) + "</td><td>" + HelperFunctions.formatFloat(ht.pValue(), 4) + "</td></tr></table>";
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter valid population standard deviations.");
                return;
            }
        } else {
            text = text + "* Population standard deviations are unknown. *<br>";
            HypothesisTest2MeanSigmaUnknown ht = new HypothesisTest2MeanSigmaUnknown(n1, n2, xBar1, xBar2, stdev1, stdev2, diff, confidenceLevel, typeTest, this.VarEqualCheckBox.isSelected());
            text = text + "DOF = " + ht.DOF();
            text = text + "<br><table border='1'>";
            text = text + "<tr><td>Significance Level</td></td><td>Critical Value</td><td>Test Statistic t</td><td>p-Value</td></tr>";
            text = text + "<tr><td>" + HelperFunctions.formatFloat(1.0 - confidenceLevel, 2) + "</td><td>" + ht.criticalValue() + "</td><td>" + HelperFunctions.formatFloat(ht.testStatistics(), 3) + "</td><td>" + HelperFunctions.formatFloat(ht.pValue(), 4) + "</td></tr></table>";
        }
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void SigmaKnownCheckBoxStateChanged(ChangeEvent evt) {
        if (this.SigmaKnownCheckBox.isSelected()) {
            if (this.SummaryRadioButton.isSelected()) {
                this.stdev1TextField.setEnabled(false);
                this.stdev2TextField.setEnabled(false);
            }
            this.Sigma1TextField.setEnabled(true);
            this.Sigma2TextField.setEnabled(true);
            this.VarEqualCheckBox.setEnabled(false);
        } else {
            if (this.SummaryRadioButton.isSelected()) {
                this.stdev1TextField.setEnabled(true);
                this.stdev2TextField.setEnabled(true);
            }
            this.Sigma1TextField.setEnabled(false);
            this.Sigma2TextField.setEnabled(false);
            this.VarEqualCheckBox.setEnabled(true);
        }
    }

    private void ConfidenceTextFieldFocusLost(FocusEvent evt) {
        try {
            String confString = this.ConfidenceTextField.getText();
            double conf = Double.parseDouble(confString);
            double sig = 1.0 - conf;
            this.SigTextField.setText(String.format("%." + HelperFunctions.getNumDecimalPlaces(confString) + "f", sig));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void ConfRadioButtonStateChanged(ChangeEvent evt) {
        if (this.ConfRadioButton.isSelected()) {
            this.ConfidenceTextField.setEnabled(true);
            this.ConfLabel.setEnabled(true);
        } else {
            this.ConfidenceTextField.setEnabled(false);
            this.ConfLabel.setEnabled(false);
        }
    }

    private void SigRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SigRadioButton.isSelected()) {
            this.SigTextField.setEnabled(true);
            this.SigLabel.setEnabled(true);
        } else {
            this.SigTextField.setEnabled(false);
            this.SigLabel.setEnabled(false);
        }
    }

    private void SigTextFieldFocusLost(FocusEvent evt) {
        try {
            String sigString = this.SigTextField.getText();
            double sig = Double.parseDouble(sigString);
            double conf = 1.0 - sig;
            this.ConfidenceTextField.setText(String.format("%." + HelperFunctions.getNumDecimalPlaces(sigString) + "f", conf));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

