/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.hytest;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.BasicStatistics;
import org.statcato.statistics.inferential.HypothesisTest;
import org.statcato.statistics.inferential.HypothesisTest1Var;
import org.statcato.utils.HelperFunctions;

public class HyTest1PopVarDialog
extends StatcatoDialog {
    private JComboBox AltComboBox;
    private JButton CancelButton;
    private JComboBox ColumnComboBox;
    private JLabel ConfLabel;
    private JRadioButton ConfRadioButton;
    private JTextField ConfidenceTextField;
    private JRadioButton HyStdevRadioButton;
    private JTextField HyStdevTextField;
    private JRadioButton HyVarRadioButton;
    private JTextField HyVarTextField;
    private JButton OKButton;
    private JRadioButton SampleRadioButton;
    private JLabel SampleSizeLabel;
    private JTextField SampleSizeTextField;
    private JTextField SampleStdevTextField;
    private JTextField SampleVarTextField;
    private JLabel SigLabel;
    private JPanel SigPanel;
    private JRadioButton SigRadioButton;
    private JTextField SigTextField;
    private JRadioButton StdevRadioButton;
    private JRadioButton SummaryRadioButton;
    private JRadioButton VarRadioButton;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel3;

    public HyTest1PopVarDialog(Frame parent, boolean modal, Statcato mTab) {
        super(parent, modal);
        this.initComponents();
        this.app = mTab;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.SampleRadioButton);
        group1.add(this.SummaryRadioButton);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.VarRadioButton);
        group2.add(this.StdevRadioButton);
        ButtonGroup group3 = new ButtonGroup();
        group3.add(this.HyVarRadioButton);
        group3.add(this.HyStdevRadioButton);
        ButtonGroup group4 = new ButtonGroup();
        group4.add(this.SigRadioButton);
        group4.add(this.ConfRadioButton);
        this.ParentSpreadsheet.populateComboBox(this.ColumnComboBox);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("stat-hytest-var");
        this.name = "Hypothesis Test: 1-Population Variance";
        this.description = "For performing calculations for testing claims about a population variance (or standard deviation).";
        this.helpStrings.add("If individual samples are entered in a single column of the datasheet, select the Samples in column: radio button, and select the column name in the drop-down menu.");
        this.helpStrings.add("To use summary statistics of the sample data, select the Summarized sample data: radio button, and input the sample size and the sample variance or standard deviation.");
        this.helpStrings.add("Enter the significance or confidence level (between 0 and 1) ");
        this.helpStrings.add("Select the form of the alternative hypothesis and enter the hypothesized population variance in the provided text box.");
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.ColumnComboBox);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.VarRadioButton = new JRadioButton();
        this.SampleSizeTextField = new JTextField();
        this.SampleVarTextField = new JTextField();
        this.ColumnComboBox = new JComboBox();
        this.SampleStdevTextField = new JTextField();
        this.SampleSizeLabel = new JLabel();
        this.SampleRadioButton = new JRadioButton();
        this.SummaryRadioButton = new JRadioButton();
        this.StdevRadioButton = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.HyStdevRadioButton = new JRadioButton();
        this.AltComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.HyStdevTextField = new JTextField();
        this.HyVarTextField = new JTextField();
        this.HyVarRadioButton = new JRadioButton();
        this.SigPanel = new JPanel();
        this.SigLabel = new JLabel();
        this.ConfidenceTextField = new JTextField();
        this.ConfRadioButton = new JRadioButton();
        this.SigRadioButton = new JRadioButton();
        this.SigTextField = new JTextField();
        this.ConfLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Hypothesis Test: 1-Population Variance");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HyTest1PopVarDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HyTest1PopVarDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.VarRadioButton.setSelected(true);
        this.VarRadioButton.setText("Variance:");
        this.VarRadioButton.setEnabled(false);
        this.VarRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest1PopVarDialog.this.VarRadioButtonStateChanged(evt);
            }
        });
        this.SampleSizeTextField.setEnabled(false);
        this.SampleVarTextField.setEnabled(false);
        this.SampleStdevTextField.setEnabled(false);
        this.SampleSizeLabel.setText("Sample Size:");
        this.SampleSizeLabel.setEnabled(false);
        this.SampleRadioButton.setSelected(true);
        this.SampleRadioButton.setText("Samples in column:");
        this.SampleRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest1PopVarDialog.this.SampleRadioButtonStateChanged(evt);
            }
        });
        this.SummaryRadioButton.setText("Summarized sample data:");
        this.SummaryRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest1PopVarDialog.this.SummaryRadioButtonStateChanged(evt);
            }
        });
        this.StdevRadioButton.setText("Standard deviation:");
        this.StdevRadioButton.setEnabled(false);
        this.StdevRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest1PopVarDialog.this.StdevRadioButtonStateChanged(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(65, 65, 65).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SampleSizeLabel).addComponent(this.VarRadioButton).addComponent(this.StdevRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SampleSizeTextField, -2, 75, -2).addComponent(this.SampleVarTextField, -2, 79, -2).addComponent(this.SampleStdevTextField, -2, 85, -2))).addComponent(this.SummaryRadioButton).addComponent(this.SampleRadioButton).addGroup(jPanel1Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.ColumnComboBox, -2, 135, -2))).addContainerGap(39, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(0, this.SampleSizeTextField, this.SampleStdevTextField, this.SampleVarTextField);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.SampleRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ColumnComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SummaryRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.SampleSizeLabel).addComponent(this.SampleSizeTextField, -2, -1, -2)).addGap(14, 14, 14).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.SampleVarTextField, -2, -1, -2).addComponent(this.VarRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.SampleStdevTextField, -2, -1, -2).addComponent(this.StdevRadioButton)).addContainerGap(26, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Alternative Hypothesis"));
        this.HyStdevRadioButton.setText("Hypothesized standard deviation:");
        this.HyStdevRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest1PopVarDialog.this.HyStdevRadioButtonStateChanged(evt);
            }
        });
        this.AltComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Less than", "Not Equal to", "Greater than"}));
        this.AltComboBox.setSelectedIndex(1);
        this.jLabel3.setText("Alternative Hypothesis:");
        this.HyStdevTextField.setEnabled(false);
        this.HyVarRadioButton.setSelected(true);
        this.HyVarRadioButton.setText("Hypothesized variance:");
        this.HyVarRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest1PopVarDialog.this.HyVarRadioButtonStateChanged(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.AltComboBox, -2, -1, -2)).addGroup(jPanel3Layout.createSequentialGroup().addGap(19, 19, 19).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.HyStdevRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.HyStdevTextField, -2, 82, -2)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.HyVarRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.HyVarTextField, -2, 72, -2))))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.AltComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.HyVarRadioButton).addComponent(this.HyVarTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.HyStdevRadioButton).addComponent(this.HyStdevTextField, -2, -1, -2)).addContainerGap()));
        this.SigPanel.setBorder(BorderFactory.createTitledBorder("Significance"));
        this.SigLabel.setText("0 - 1.00 (e.g. 0.05)");
        this.ConfidenceTextField.setText("0.95");
        this.ConfidenceTextField.setEnabled(false);
        this.ConfidenceTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                HyTest1PopVarDialog.this.ConfidenceTextFieldFocusLost(evt);
            }
        });
        this.ConfRadioButton.setText("Confidence Level:");
        this.ConfRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest1PopVarDialog.this.ConfRadioButtonStateChanged(evt);
            }
        });
        this.SigRadioButton.setSelected(true);
        this.SigRadioButton.setText("Significance Level:");
        this.SigRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest1PopVarDialog.this.SigRadioButtonStateChanged(evt);
            }
        });
        this.SigTextField.setText("0.05");
        this.SigTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                HyTest1PopVarDialog.this.SigTextFieldFocusLost(evt);
            }
        });
        this.ConfLabel.setText("0 - 1.00 (e.g. 0.95)");
        this.ConfLabel.setEnabled(false);
        GroupLayout SigPanelLayout = new GroupLayout(this.SigPanel);
        this.SigPanel.setLayout(SigPanelLayout);
        SigPanelLayout.setHorizontalGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(SigPanelLayout.createSequentialGroup().addContainerGap().addGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(SigPanelLayout.createSequentialGroup().addComponent(this.ConfRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 10, Short.MAX_VALUE).addComponent(this.ConfidenceTextField, -2, 81, -2)).addGroup(SigPanelLayout.createSequentialGroup().addComponent(this.SigRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 10, Short.MAX_VALUE).addComponent(this.SigTextField, -2, 79, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SigLabel).addComponent(this.ConfLabel)).addContainerGap()));
        SigPanelLayout.setVerticalGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(SigPanelLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.SigRadioButton).addComponent(this.SigLabel).addComponent(this.SigTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ConfRadioButton).addComponent(this.ConfLabel).addComponent(this.ConfidenceTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.SigPanel, -1, -1, Short.MAX_VALUE).addGap(11, 11, 11)).addGroup(layout.createSequentialGroup().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addContainerGap()))).addGroup(layout.createSequentialGroup().addGap(258, 258, 258).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton).addContainerGap(293, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.SigPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, Short.MAX_VALUE)).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addContainerGap()));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        double confidenceLevel;
        this.app.compoundEdit = new DialogEdit("hypothesis test 1 variance");
        int n = 0;
        double s = 0.0;
        double s2 = 0.0;
        double s_0 = 0.0;
        double s2_0 = 0.0;
        Vector<Double> ColumnVector = new Vector();
        String heading = "Hypothesis Test - One population variance:";
        String text = "";
        if (this.ConfRadioButton.isSelected()) {
            try {
                confidenceLevel = Double.parseDouble(this.ConfidenceTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
                return;
            }
            if (confidenceLevel <= 0.0 || confidenceLevel >= 1.0) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
                return;
            }
        } else {
            try {
                confidenceLevel = 1.0 - Double.parseDouble(this.SigTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the significance level.");
                return;
            }
            if (confidenceLevel <= 0.0 || confidenceLevel >= 1.0) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the significance level.");
                return;
            }
        }
        heading = heading + "  confidence level = " + String.format("%." + HelperFunctions.getNumDecimalPlaces(this.ConfidenceTextField.getText()) + "f", confidenceLevel);
        if (this.SampleRadioButton.isSelected()) {
            String columnLabel = this.ColumnComboBox.getSelectedItem().toString();
            if (columnLabel.equals("")) {
                this.app.showErrorDialog("Select the input column.");
                return;
            }
            int column = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(column);
            ColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (ColumnVector == null) {
                this.app.showErrorDialog("Invalid input column " + columnLabel + ": all data must be numbers.");
                return;
            }
            text = text + "Input: " + columnLabel + "<br>";
            n = BasicStatistics.Nnonmissing(ColumnVector);
            s2 = BasicStatistics.variance(ColumnVector);
            s = BasicStatistics.stdev(ColumnVector);
        } else {
            try {
                n = Integer.parseInt(this.SampleSizeTextField.getText());
                if (this.VarRadioButton.isSelected()) {
                    s2 = Double.parseDouble(this.SampleVarTextField.getText());
                    s = Math.sqrt(s2);
                } else {
                    s = Double.parseDouble(this.SampleStdevTextField.getText());
                    s2 = s * s;
                }
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Invalid summary data.");
                return;
            }
            text = text + "Input: Summary data<br>";
        }
        if (this.HyVarRadioButton.isSelected()) {
            try {
                s2_0 = Double.parseDouble(this.HyVarTextField.getText());
                s_0 = Math.sqrt(s2_0);
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a valid number for the hypothesized variance.");
                return;
            }
        }
        try {
            s_0 = Double.parseDouble(this.HyStdevTextField.getText());
            s2_0 = s_0 * s_0;
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a valid number for the hypothesized standard deviation.");
            return;
        }
        int typeTest = this.AltComboBox.getSelectedIndex();
        HypothesisTest1Var ht = new HypothesisTest1Var(n, s2_0, confidenceLevel, typeTest);
        text = text + "Null hypothesis: &sigma;<sup>2</sup> = " + s2_0 + "<br>";
        text = text + "Alternative hypothesis: &sigma;<sup>2</sup> ";
        text = typeTest == HypothesisTest.LEFT_TAIL ? text + "&lt;" : (typeTest == HypothesisTest.RIGHT_TAIL ? text + "&gt;" : text + "&ne;");
        text = text + " " + s2_0 + "<br>";
        text = text + "<br><table border='1'>";
        text = text + "<tr><td>N</td><td>Sample Stdev s</td><td>Sample Var s<sup>2</sup></td>";
        text = text + "<td>Significance Level</td><td>Critical Value</td><td>Test Statistic</td><td>p-Value</td></tr>";
        text = text + "<tr><td>" + n + "</td><td>" + HelperFunctions.formatFloat(s, 3) + "</td><td>" + HelperFunctions.formatFloat(s2, 3) + "</td><td>" + HelperFunctions.formatFloat(1.0 - confidenceLevel, 2) + "</td><td>" + ht.criticalValue() + "</td><td>" + HelperFunctions.formatFloat(ht.testStatistics(s2), 3) + "</td><td>" + HelperFunctions.formatFloat(ht.pValue(s2), 4) + "</td></tr></table>";
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void SampleRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SampleRadioButton.isSelected()) {
            this.ColumnComboBox.setEnabled(true);
        } else {
            this.ColumnComboBox.setEnabled(false);
        }
    }

    private void SummaryRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SummaryRadioButton.isSelected()) {
            this.SampleSizeLabel.setEnabled(true);
            this.SampleSizeTextField.setEnabled(true);
            this.SampleStdevTextField.setEnabled(false);
            this.SampleVarTextField.setEnabled(true);
            this.VarRadioButton.setEnabled(true);
            this.StdevRadioButton.setEnabled(true);
            this.VarRadioButton.setSelected(true);
        } else {
            this.SampleSizeLabel.setEnabled(false);
            this.SampleSizeTextField.setEnabled(false);
            this.VarRadioButton.setEnabled(false);
            this.StdevRadioButton.setEnabled(false);
            this.SampleStdevTextField.setEnabled(false);
            this.SampleVarTextField.setEnabled(false);
        }
    }

    private void ConfidenceTextFieldFocusLost(FocusEvent evt) {
        try {
            String confString = this.ConfidenceTextField.getText();
            double conf = Double.parseDouble(confString);
            double sig = 1.0 - conf;
            this.SigTextField.setText(String.format("%." + HelperFunctions.getNumDecimalPlaces(confString) + "f", sig));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void ConfRadioButtonStateChanged(ChangeEvent evt) {
        if (this.ConfRadioButton.isSelected()) {
            this.ConfidenceTextField.setEnabled(true);
            this.ConfLabel.setEnabled(true);
        } else {
            this.ConfidenceTextField.setEnabled(false);
            this.ConfLabel.setEnabled(false);
        }
    }

    private void SigRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SigRadioButton.isSelected()) {
            this.SigTextField.setEnabled(true);
            this.SigLabel.setEnabled(true);
        } else {
            this.SigTextField.setEnabled(false);
            this.SigLabel.setEnabled(false);
        }
    }

    private void SigTextFieldFocusLost(FocusEvent evt) {
        try {
            String sigString = this.SigTextField.getText();
            double sig = Double.parseDouble(sigString);
            double conf = 1.0 - sig;
            this.ConfidenceTextField.setText(String.format("%." + HelperFunctions.getNumDecimalPlaces(sigString) + "f", conf));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void VarRadioButtonStateChanged(ChangeEvent evt) {
        if (this.VarRadioButton.isSelected()) {
            if (this.SummaryRadioButton.isSelected()) {
                this.SampleVarTextField.setEnabled(true);
            }
        } else {
            this.SampleVarTextField.setEnabled(false);
        }
    }

    private void StdevRadioButtonStateChanged(ChangeEvent evt) {
        if (this.StdevRadioButton.isSelected()) {
            if (this.SummaryRadioButton.isSelected()) {
                this.SampleStdevTextField.setEnabled(true);
            }
        } else {
            this.SampleStdevTextField.setEnabled(false);
        }
    }

    private void HyVarRadioButtonStateChanged(ChangeEvent evt) {
        if (this.HyVarRadioButton.isSelected()) {
            this.HyVarTextField.setEnabled(true);
        } else {
            this.HyVarTextField.setEnabled(false);
        }
    }

    private void HyStdevRadioButtonStateChanged(ChangeEvent evt) {
        if (this.HyStdevRadioButton.isSelected()) {
            this.HyStdevTextField.setEnabled(true);
        } else {
            this.HyStdevTextField.setEnabled(false);
        }
    }
}

