/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.hytest;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.BasicStatistics;
import org.statcato.statistics.inferential.HypothesisTest;
import org.statcato.statistics.inferential.HypothesisTest1MeanSigmaKnown;
import org.statcato.statistics.inferential.HypothesisTest1MeanSigmaUnknown;
import org.statcato.utils.HelperFunctions;

public class HyTest1PopMeanDialog
extends StatcatoDialog {
    private JComboBox AltComboBox;
    private JButton CancelButton;
    private JComboBox ColumnComboBox;
    private JLabel ConfLabel;
    private JRadioButton ConfRadioButton;
    private JTextField ConfidenceTextField;
    private JTextField HyMeanTextField;
    private JRadioButton KnownRadioButton;
    private JButton OKButton;
    private JLabel SampleMeanLabel;
    private JTextField SampleMeanTextField;
    private JRadioButton SampleRadioButton;
    private JLabel SampleSizeLabel;
    private JTextField SampleSizeTextField;
    private JLabel SigLabel;
    private JRadioButton SigRadioButton;
    private JTextField SigTextField;
    private JTextField SigmaTextField;
    private JRadioButton SummaryRadioButton;
    private JRadioButton UnknownRadioButton;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JLabel sLabel;
    private JTextField sTextField;

    public HyTest1PopMeanDialog(Frame parent, boolean modal, Statcato mTab) {
        super(parent, modal);
        this.initComponents();
        this.app = mTab;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.SampleRadioButton);
        group1.add(this.SummaryRadioButton);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.KnownRadioButton);
        group2.add(this.UnknownRadioButton);
        ButtonGroup group3 = new ButtonGroup();
        group3.add(this.SigRadioButton);
        group3.add(this.ConfRadioButton);
        this.ParentSpreadsheet.populateComboBox(this.ColumnComboBox);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("stat-hytest-mean");
        this.name = "Hypothesis Test: 1-Population Mean";
        this.description = "For performing calculations for testing claims about a population mean.";
        this.helpStrings.add("If individual samples are entered in a single column of the datasheet, select the Samples in column: radio button, and select the column name in the drop-down menu.");
        this.helpStrings.add("To use summary statistics of the sample data, select the Summarized sample data: radio button, and input the sample size, mean, and standard deviation in the provided text fields.");
        this.helpStrings.add("Indicate whether the population standard deviation is known.");
        this.helpStrings.add("Specify the significance or confidence level.");
        this.helpStrings.add("Select the form of the alternative hypothesis and enter the hypothesized population mean in the provided text box.");
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.ColumnComboBox);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.sTextField = new JTextField();
        this.SampleMeanTextField = new JTextField();
        this.sLabel = new JLabel();
        this.ColumnComboBox = new JComboBox();
        this.SampleMeanLabel = new JLabel();
        this.SampleSizeTextField = new JTextField();
        this.SampleRadioButton = new JRadioButton();
        this.SampleSizeLabel = new JLabel();
        this.SummaryRadioButton = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.SigmaTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel7 = new JLabel();
        this.KnownRadioButton = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.UnknownRadioButton = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.SigLabel = new JLabel();
        this.ConfidenceTextField = new JTextField();
        this.ConfRadioButton = new JRadioButton();
        this.SigRadioButton = new JRadioButton();
        this.SigTextField = new JTextField();
        this.ConfLabel = new JLabel();
        this.jPanel4 = new JPanel();
        this.HyMeanTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.AltComboBox = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Hypothesis Test: 1-Population Mean");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HyTest1PopMeanDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HyTest1PopMeanDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.sTextField.setEnabled(false);
        this.SampleMeanTextField.setEnabled(false);
        this.sLabel.setText("Standard deviation:");
        this.sLabel.setEnabled(false);
        this.SampleMeanLabel.setText("Mean:");
        this.SampleMeanLabel.setEnabled(false);
        this.SampleSizeTextField.setEnabled(false);
        this.SampleRadioButton.setSelected(true);
        this.SampleRadioButton.setText("Samples in column:");
        this.SampleRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest1PopMeanDialog.this.SampleRadioButtonStateChanged(evt);
            }
        });
        this.SampleSizeLabel.setText("Size:");
        this.SampleSizeLabel.setEnabled(false);
        this.SummaryRadioButton.setText("Summarized sample data:");
        this.SummaryRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest1PopMeanDialog.this.SummaryRadioButtonStateChanged(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SampleRadioButton).addGroup(jPanel1Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.ColumnComboBox, -2, 119, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.SummaryRadioButton).addGroup(jPanel1Layout.createSequentialGroup().addGap(13, 13, 13).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SampleMeanLabel).addComponent(this.SampleSizeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.SampleSizeTextField, -1, 70, Short.MAX_VALUE).addComponent(this.SampleMeanTextField, -1, 68, Short.MAX_VALUE).addComponent(this.sTextField))).addComponent(this.sLabel)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.SampleRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ColumnComboBox, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.SummaryRadioButton).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.SampleSizeLabel).addComponent(this.SampleSizeTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.SampleMeanLabel).addComponent(this.SampleMeanTextField, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sTextField, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Population Standard Deviation"));
        this.SigmaTextField.setEnabled(false);
        this.jLabel5.setText("- use z distribution");
        this.jLabel7.setText("- use t distribution");
        this.KnownRadioButton.setText("Known:");
        this.KnownRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest1PopMeanDialog.this.KnownRadioButtonStateChanged(evt);
            }
        });
        this.jLabel4.setText("Population standard deviation:");
        this.UnknownRadioButton.setSelected(true);
        this.UnknownRadioButton.setText("Unknown");
        this.UnknownRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest1PopMeanDialog.this.UnknownRadioButtonStateChanged(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addGroup(jPanel2Layout.createSequentialGroup().addGap(12, 12, 12).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.KnownRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SigmaTextField, -2, 73, -2)).addComponent(this.UnknownRadioButton)).addGap(26, 26, 26).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5).addComponent(this.jLabel7)))).addContainerGap(20, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.SigmaTextField, -2, -1, -2).addComponent(this.KnownRadioButton).addComponent(this.jLabel5)).addGap(5, 5, 5).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.UnknownRadioButton).addComponent(this.jLabel7)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Significance"));
        this.SigLabel.setText("0 - 1.00 (e.g. 0.05)");
        this.ConfidenceTextField.setText("0.95");
        this.ConfidenceTextField.setEnabled(false);
        this.ConfidenceTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                HyTest1PopMeanDialog.this.ConfidenceTextFieldFocusLost(evt);
            }
        });
        this.ConfRadioButton.setText("Confidence Level:");
        this.ConfRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest1PopMeanDialog.this.ConfRadioButtonStateChanged(evt);
            }
        });
        this.SigRadioButton.setSelected(true);
        this.SigRadioButton.setText("Significance Level:");
        this.SigRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest1PopMeanDialog.this.SigRadioButtonStateChanged(evt);
            }
        });
        this.SigTextField.setText("0.05");
        this.SigTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                HyTest1PopMeanDialog.this.SigTextFieldFocusLost(evt);
            }
        });
        this.ConfLabel.setText("0 - 1.00 (e.g. 0.95)");
        this.ConfLabel.setEnabled(false);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.ConfRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.ConfidenceTextField, -2, 81, -2)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.SigRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SigTextField, -2, 79, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SigLabel).addComponent(this.ConfLabel)).addContainerGap()));
        jPanel3Layout.linkSize(0, this.ConfidenceTextField, this.SigTextField);
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.SigRadioButton).addComponent(this.SigTextField, -2, -1, -2).addComponent(this.SigLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ConfidenceTextField, -2, -1, -2).addComponent(this.ConfRadioButton).addComponent(this.ConfLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Alternative Hypothesis"));
        this.jLabel3.setText("Alternative Hypothesis:");
        this.jLabel2.setText("Hypothesized Mean:");
        this.AltComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Less than", "Not Equal to", "Greater than"}));
        this.AltComboBox.setSelectedIndex(1);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.AltComboBox, -2, -1, -2).addComponent(this.HyMeanTextField, -2, 78, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.AltComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.HyMeanTextField, -2, -1, -2)).addContainerGap(7, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)).addContainerGap(33, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton).addGap(347, 347, 347)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)).addGap(39, 39, 39).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.CancelButton).addComponent(this.OKButton)).addContainerGap()));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("hypothesis test 1 mean");
        int n = 0;
        int typeTest = 0;
        double s = 0.0;
        double mean = 0.0;
        double confidenceLevel = 0.0;
        double mu = 0.0;
        Vector<Double> ColumnVector = new Vector();
        String heading = "Hypothesis Test - One Population Mean:";
        String text = "";
        if (this.ConfRadioButton.isSelected()) {
            try {
                confidenceLevel = Double.parseDouble(this.ConfidenceTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
                return;
            }
            if (confidenceLevel <= 0.0 || confidenceLevel >= 1.0) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
                return;
            }
        } else {
            try {
                confidenceLevel = 1.0 - Double.parseDouble(this.SigTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the significance level.");
                return;
            }
            if (confidenceLevel <= 0.0 || confidenceLevel >= 1.0) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the significance level.");
                return;
            }
        }
        heading = heading + "  confidence level = " + String.format("%." + HelperFunctions.getNumDecimalPlaces(this.ConfidenceTextField.getText()) + "f", confidenceLevel);
        if (this.SampleRadioButton.isSelected()) {
            String columnLabel = this.ColumnComboBox.getSelectedItem().toString();
            if (columnLabel.equals("")) {
                this.app.showErrorDialog("Select the input column.");
                return;
            }
            int column = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(column);
            ColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (ColumnVector == null) {
                this.app.showErrorDialog("Invalid input column " + columnLabel + ": all data must be numbers.");
                return;
            }
            text = text + "Input: " + columnLabel + "<br>";
            n = BasicStatistics.Nnonmissing(ColumnVector);
            mean = BasicStatistics.mean(ColumnVector);
            s = BasicStatistics.stdev(ColumnVector);
        } else {
            try {
                n = Integer.parseInt(this.SampleSizeTextField.getText());
                mean = Double.parseDouble(this.SampleMeanTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Invalid summary data.");
                return;
            }
            text = text + "Input: Summary data<br>";
        }
        try {
            mu = Double.parseDouble(this.HyMeanTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a valid number for the hypothesized mean.");
            return;
        }
        typeTest = this.AltComboBox.getSelectedIndex();
        if (this.KnownRadioButton.isSelected()) {
            text = text + "<b>&sigma; known</b> (using z distribution)<br>";
            try {
                double sigma = Double.parseDouble(this.SigmaTextField.getText());
                text = text + "Assumed population standard deviation &sigma; = " + sigma + "<br>";
                HypothesisTest1MeanSigmaKnown ht = new HypothesisTest1MeanSigmaKnown(n, mu, sigma, confidenceLevel, typeTest);
                text = text + "Null hypothesis: &mu; = " + mu + "<br>";
                text = text + "Alternative hypothesis: &mu; ";
                text = typeTest == HypothesisTest.LEFT_TAIL ? text + "&lt;" : (typeTest == HypothesisTest.RIGHT_TAIL ? text + "&gt;" : text + "&ne;");
                text = text + " " + mu + "<br>";
                text = text + "<br><table border='1'>";
                text = text + "<tr><td>N</td><td>Sample Mean</td><td>Stdev &sigma;</td>";
                text = text + "<td>Significance Level</td></td><td>Critical Value</td><td>Test Statistic</td><td>p-Value</td></tr>";
                text = text + "<tr><td>" + n + "</td><td>" + HelperFunctions.formatFloat(mean, 3) + "</td><td>" + HelperFunctions.formatFloat(sigma, 3) + "</td><td>" + HelperFunctions.formatFloat(1.0 - confidenceLevel, 2) + "</td><td>" + ht.criticalValue() + "</td><td>" + HelperFunctions.formatFloat(ht.testStatistics(mean), 3) + "</td><td>" + HelperFunctions.formatFloat(ht.pValue(mean), 4) + "</td></tr></table>";
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a valid population standard deviation.");
                return;
            }
        }
        text = text + "<b>&sigma; unknown</b> (using t distribution) <br>";
        if (this.SummaryRadioButton.isSelected()) {
            try {
                s = Double.parseDouble(this.sTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a valid sample standard deviation.");
                return;
            }
        }
        HypothesisTest1MeanSigmaUnknown ht = new HypothesisTest1MeanSigmaUnknown(n, mu, s, confidenceLevel, typeTest);
        text = text + "Null hypothesis: &mu; = " + mu + "<br>";
        text = text + "Alternative hypothesis: &mu; ";
        text = typeTest == HypothesisTest.LEFT_TAIL ? text + "&lt;" : (typeTest == HypothesisTest.RIGHT_TAIL ? text + "&gt;" : text + "&ne;");
        text = text + " " + mu + "<br>";
        text = text + "<br><table border='1'>";
        text = text + "<tr><td>N</td><td>Sample Mean</td><td>Stdev s</td>";
        text = text + "<td>Significance Level</td></td><td>Critical Value</td><td>Test Statistic</td><td>p-Value</td></tr>";
        text = text + "<tr><td>" + n + "</td><td>" + HelperFunctions.formatFloat(mean, 3) + "</td><td>" + HelperFunctions.formatFloat(s, 3) + "</td><td>" + HelperFunctions.formatFloat(1.0 - confidenceLevel, 2) + "</td><td>" + ht.criticalValue() + "</td><td>" + HelperFunctions.formatFloat(ht.testStatistics(mean), 3) + "</td><td>" + HelperFunctions.formatFloat(ht.pValue(mean), 4) + "</td></tr></table>";
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void SampleRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SampleRadioButton.isSelected()) {
            this.ColumnComboBox.setEnabled(true);
        } else {
            this.ColumnComboBox.setEnabled(false);
        }
    }

    private void SummaryRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SummaryRadioButton.isSelected()) {
            this.SampleSizeLabel.setEnabled(true);
            this.SampleSizeTextField.setEnabled(true);
            this.SampleMeanLabel.setEnabled(true);
            this.SampleMeanTextField.setEnabled(true);
            if (this.UnknownRadioButton.isSelected()) {
                this.sLabel.setEnabled(true);
                this.sTextField.setEnabled(true);
            } else {
                this.sLabel.setEnabled(false);
                this.sTextField.setEnabled(false);
            }
        } else {
            this.SampleSizeLabel.setEnabled(false);
            this.SampleSizeTextField.setEnabled(false);
            this.SampleMeanLabel.setEnabled(false);
            this.SampleMeanTextField.setEnabled(false);
            this.sLabel.setEnabled(false);
            this.sTextField.setEnabled(false);
        }
    }

    private void UnknownRadioButtonStateChanged(ChangeEvent evt) {
        if (this.UnknownRadioButton.isSelected()) {
            if (this.SummaryRadioButton.isSelected()) {
                this.sLabel.setEnabled(true);
                this.sTextField.setEnabled(true);
            } else {
                this.sLabel.setEnabled(false);
                this.sTextField.setEnabled(false);
            }
        } else {
            this.sLabel.setEnabled(false);
            this.sTextField.setEnabled(false);
        }
    }

    private void KnownRadioButtonStateChanged(ChangeEvent evt) {
        if (this.KnownRadioButton.isSelected()) {
            this.SigmaTextField.setEnabled(true);
        } else {
            this.SigmaTextField.setEnabled(false);
        }
    }

    private void SigRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SigRadioButton.isSelected()) {
            this.SigTextField.setEnabled(true);
            this.SigLabel.setEnabled(true);
        } else {
            this.SigTextField.setEnabled(false);
            this.SigLabel.setEnabled(false);
        }
    }

    private void ConfRadioButtonStateChanged(ChangeEvent evt) {
        if (this.ConfRadioButton.isSelected()) {
            this.ConfidenceTextField.setEnabled(true);
            this.ConfLabel.setEnabled(true);
        } else {
            this.ConfidenceTextField.setEnabled(false);
            this.ConfLabel.setEnabled(false);
        }
    }

    private void SigTextFieldFocusLost(FocusEvent evt) {
        try {
            String sigString = this.SigTextField.getText();
            double sig = Double.parseDouble(sigString);
            double conf = 1.0 - sig;
            this.ConfidenceTextField.setText(String.format("%." + HelperFunctions.getNumDecimalPlaces(sigString) + "f", conf));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void ConfidenceTextFieldFocusLost(FocusEvent evt) {
        try {
            String confString = this.ConfidenceTextField.getText();
            double conf = Double.parseDouble(confString);
            double sig = 1.0 - conf;
            this.SigTextField.setText(String.format("%." + HelperFunctions.getNumDecimalPlaces(confString) + "f", sig));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

