/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.correg;

import Jama.Matrix;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.JFreeChart;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.graph.GraphFactory;
import org.statcato.graph.StatcatoChartFrame;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.inferential.MultipleRegression2;
import org.statcato.utils.HelperFunctions;

public class NonLinearModelsDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JRadioButton CubicRadioButton;
    private JRadioButton ExpRadioButton;
    private JRadioButton FixedPowRadioButton;
    private JCheckBox GraphCheckBox;
    private JPanel GraphPanel;
    private JCheckBox LegendCheckBox;
    private JRadioButton LogRadioButton;
    private JButton OKButton;
    private JRadioButton PolyRadioButton;
    private JRadioButton PowerRadioButton;
    private JRadioButton QuadRadioButton;
    private JTextField TitleTextField;
    private JTextField XTextField;
    private JTextField YTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField nTextField;
    private JTextField powTextField;
    private JComboBox xComboBox;
    private JComboBox yComboBox;

    public NonLinearModelsDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.app = app;
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.initComponents();
        this.customInitComponents();
        this.setHelpFile("stat-reg-nonlinear");
        this.name = "Non-Linear Regression Models";
        this.description = "For performing computations that fit a non-linear mathematical regression model to two variables. ";
        this.helpStrings.add("Select x (independent/predictor variable): Select the column containing the x values.");
        this.helpStrings.add("Select y (dependent/response variable): Select the column containing the y values (the number of x and y values must be the same).");
        this.helpStrings.add("Type of Model: Select desired model type.");
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.xComboBox);
        this.updateComboBox(this.yComboBox);
    }

    public void customInitComponents() {
        this.ParentSpreadsheet.populateComboBox(this.xComboBox);
        this.ParentSpreadsheet.populateComboBox(this.yComboBox);
        this.getRootPane().setDefaultButton(this.OKButton);
        ButtonGroup group = new ButtonGroup();
        group.add(this.QuadRadioButton);
        group.add(this.CubicRadioButton);
        group.add(this.LogRadioButton);
        group.add(this.PolyRadioButton);
        group.add(this.PowerRadioButton);
        group.add(this.ExpRadioButton);
        group.add(this.FixedPowRadioButton);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.yComboBox = new JComboBox();
        this.xComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.LogRadioButton = new JRadioButton();
        this.PolyRadioButton = new JRadioButton();
        this.QuadRadioButton = new JRadioButton();
        this.PowerRadioButton = new JRadioButton();
        this.nTextField = new JTextField();
        this.ExpRadioButton = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.CubicRadioButton = new JRadioButton();
        this.FixedPowRadioButton = new JRadioButton();
        this.jLabel5 = new JLabel();
        this.powTextField = new JTextField();
        this.GraphCheckBox = new JCheckBox();
        this.GraphPanel = new JPanel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.LegendCheckBox = new JCheckBox();
        this.YTextField = new JTextField();
        this.TitleTextField = new JTextField();
        this.XTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Non-Linear Regression Models");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NonLinearModelsDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NonLinearModelsDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.jLabel3.setText("<html>Select <i>x</i> (independent/predictor variable):</html>");
        this.jLabel1.setText("<html>Select <i>y</i> (dependent/response variable):</html>");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -2, -1, -2).addComponent(this.jLabel1, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.xComboBox, -2, 130, -2).addComponent(this.yComboBox, -2, 132, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xComboBox, -2, -1, -2).addGap(28, 28, 28).addComponent(this.jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yComboBox, -2, -1, -2).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Models"));
        this.LogRadioButton.setText("<html>Logarithmic: y = a lnx + b</html>");
        this.PolyRadioButton.setText("<html>Polynomial: y = ax<sup>n</sup> + bx<sup>n-1</sup> + cx<sup>n-2</sup> + ...</html>");
        this.PolyRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                NonLinearModelsDialog.this.PolyRadioButtonStateChanged(evt);
            }
        });
        this.QuadRadioButton.setSelected(true);
        this.QuadRadioButton.setText("<html>Quadratic: y = ax<sup>2</sup> + bx + c</html>");
        this.PowerRadioButton.setText("<html>Power: y = a x<sup>b</sup></html>");
        this.nTextField.setText("4");
        this.nTextField.setEnabled(false);
        this.ExpRadioButton.setText("<html>Exponential: y = a b<sup>x</sup></html>");
        this.jLabel2.setText("Type of Model:");
        this.jLabel4.setText("n = ");
        this.CubicRadioButton.setText("<html>Cubic: y = ax<sup>3</sup> + bx<sup>2</sup> + cx + d</html>\n");
        this.FixedPowRadioButton.setText("<html>Fixed Power: y = a x<sup>n</sup></html>");
        this.FixedPowRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                NonLinearModelsDialog.this.FixedPowRadioButtonStateChanged(evt);
            }
        });
        this.jLabel5.setText("n = ");
        this.powTextField.setText("-1");
        this.powTextField.setEnabled(false);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.PolyRadioButton, -2, -1, -2).addComponent(this.CubicRadioButton, -2, -1, -2).addComponent(this.QuadRadioButton, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.LogRadioButton, -2, -1, -2).addComponent(this.PowerRadioButton, -2, -1, -2).addGroup(jPanel2Layout.createSequentialGroup().addGap(56, 56, 56).addComponent(this.powTextField, -2, 44, -2)).addComponent(this.FixedPowRadioButton, -2, -1, -2).addComponent(this.ExpRadioButton, -2, -1, -2))).addGroup(jPanel2Layout.createSequentialGroup().addGap(44, 44, 44).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nTextField, -2, 42, -2)).addGroup(jPanel2Layout.createSequentialGroup().addGap(42, 42, 42).addComponent(this.jLabel5))).addContainerGap(15, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.QuadRadioButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CubicRadioButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.PolyRadioButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.nTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.LogRadioButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.PowerRadioButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.FixedPowRadioButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.powTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ExpRadioButton, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.GraphCheckBox.setSelected(true);
        this.GraphCheckBox.setText("Show a scatterplot for data values with the regression curve");
        this.GraphCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                NonLinearModelsDialog.this.GraphCheckBoxStateChanged(evt);
            }
        });
        this.GraphPanel.setBorder(BorderFactory.createTitledBorder("Graph Options"));
        this.jLabel7.setText("Plot Title:");
        this.jLabel8.setText("X-axis Label:");
        this.LegendCheckBox.setSelected(true);
        this.LegendCheckBox.setText("Show legend");
        this.YTextField.setText("y");
        this.TitleTextField.setText("Plot");
        this.XTextField.setText("x");
        this.jLabel6.setText("Y-axis Label:");
        GroupLayout GraphPanelLayout = new GroupLayout(this.GraphPanel);
        this.GraphPanel.setLayout(GraphPanelLayout);
        GraphPanelLayout.setHorizontalGroup(GraphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GraphPanelLayout.createSequentialGroup().addContainerGap().addGroup(GraphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GraphPanelLayout.createSequentialGroup().addGroup(GraphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel7)).addGap(18, 18, 18).addGroup(GraphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.TitleTextField).addComponent(this.XTextField).addComponent(this.YTextField, -1, 188, Short.MAX_VALUE))).addComponent(this.jLabel8).addComponent(this.LegendCheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        GraphPanelLayout.setVerticalGroup(GraphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GraphPanelLayout.createSequentialGroup().addContainerGap().addGroup(GraphPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.XTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(GraphPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.YTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(GraphPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.TitleTextField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.LegendCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.GraphPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.GraphCheckBox, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(220, 220, 220).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton))).addContainerGap()));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.GraphCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.GraphPanel, -2, -1, -2)).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addGap(18, 36, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addContainerGap()));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("non linear models");
        Vector<Double> xVector = null;
        Vector<Double> yVector = null;
        String heading = "Non-Linear Modeling:";
        String text = "";
        String xColumnLabel = this.xComboBox.getSelectedItem().toString();
        if (xColumnLabel.equals("")) {
            this.app.showErrorDialog("Select the input column.");
            return;
        }
        int column = this.ParentSpreadsheet.parseColumnNumber(xColumnLabel);
        Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(column);
        xVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
        if (xVector == null) {
            this.app.showErrorDialog("Invalid input column " + xColumnLabel + ": all data must be numbers.");
            return;
        }
        text = text + "x (independent/predictor variable): " + xColumnLabel + "<br>";
        String yColumnLabel = this.yComboBox.getSelectedItem().toString();
        if (yColumnLabel.equals("")) {
            this.app.showErrorDialog("Select the input column.");
            return;
        }
        column = this.ParentSpreadsheet.parseColumnNumber(yColumnLabel);
        StrColumnVector = this.ParentSpreadsheet.getColumn(column);
        yVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
        if (yVector == null) {
            this.app.showErrorDialog("Invalid input column " + yColumnLabel + ": all data must be numbers.");
            return;
        }
        text = text + "y (dependent/response variable): " + yColumnLabel + "<br>";
        xVector = HelperFunctions.removeNullValues(xVector);
        yVector = HelperFunctions.removeNullValues(yVector);
        if (xVector.size() != yVector.size()) {
            this.app.showErrorDialog("The x and y variables must have the same number of values.");
            return;
        }
        XYSeriesCollection seriesCollection = new XYSeriesCollection();
        double min = 0.0;
        double max = 0.0;
        XYSeries series = new XYSeries((Comparable)((Object)(xColumnLabel.trim() + ", " + yColumnLabel.trim())));
        for (int j = 0; j < xVector.size(); ++j) {
            double x = xVector.elementAt(j);
            if (x < min) {
                min = x;
            }
            if (x > max) {
                max = x;
            }
            series.add(x, yVector.elementAt(j));
        }
        seriesCollection.addSeries(series);
        int regressionType = 0;
        double regressionArg = 0.0;
        Vector<Vector<Double>> vectors = new Vector<Vector<Double>>();
        int k = 0;
        boolean logTransform = false;
        if (this.QuadRadioButton.isSelected()) {
            text = text + "<b>Quadratic Model: y = b<sub>0</sub> + b<sub>1</sub>x + b<sub>2</sub>x<sup>2</sup></b><br>";
            vectors.addElement(xVector);
            vectors.addElement(HelperFunctions.powerVector(xVector, 2));
            k = 3;
            regressionType = 2;
        } else if (this.CubicRadioButton.isSelected()) {
            text = text + "<b>Cubic Model: y = b<sub>0</sub> + b<sub>1</sub>x + b<sub>2</sub>x<sup>2</sup> + b<sub>3</sub>x<sup>3</sup></b><br>";
            vectors.addElement(xVector);
            vectors.addElement(HelperFunctions.powerVector(xVector, 2));
            vectors.addElement(HelperFunctions.powerVector(xVector, 3));
            k = 4;
            regressionType = 3;
        } else if (this.PolyRadioButton.isSelected()) {
            text = text + "<b>Polynomial  Model: y = b<sub>0</sub> + b<sub>1</sub>x + b<sub>2</sub>x<sup>2</sup> + ... + b<sub>n</sub>x<sup>n</sup></b><br>";
            try {
                int n = Integer.parseInt(this.nTextField.getText());
                if (n <= 0) {
                    throw new NumberFormatException();
                }
                regressionArg = n;
                text = text + "Degree = " + n + "<br>";
                vectors.addElement(xVector);
                for (int i = 2; i <= n; ++i) {
                    vectors.addElement(HelperFunctions.powerVector(xVector, i));
                }
                k = n + 1;
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a positive integer for the degree of the polynomial model");
                return;
            }
            regressionType = 4;
        } else if (this.LogRadioButton.isSelected()) {
            text = text + "<b>Logarithmic Model: y = b<sub>0</sub> + b<sub>1</sub>ln x</b><br>";
            vectors.addElement(HelperFunctions.logVector(xVector));
            k = 2;
            regressionType = 5;
        } else if (this.PowerRadioButton.isSelected()) {
            text = text + "<b>Power Model: y = a x<sup>b</sup></b><br>";
            vectors.addElement(HelperFunctions.logVector(xVector));
            yVector = HelperFunctions.logVector(yVector);
            k = 2;
            logTransform = true;
            regressionType = 6;
        } else if (this.ExpRadioButton.isSelected()) {
            text = text + "<b>Exponential Model: y = a b<sup>x</sup></b><br>";
            vectors.addElement(xVector);
            yVector = HelperFunctions.logVector(yVector);
            k = 2;
            logTransform = true;
            regressionType = 8;
        } else if (this.FixedPowRadioButton.isSelected()) {
            text = text + "<b>Fixed Power Model: y = a x<sup>n</sup></b><br>";
            try {
                double n;
                regressionArg = n = Double.parseDouble(this.powTextField.getText());
                vectors.addElement(HelperFunctions.powerVector(xVector, n));
                text = text + "n = " + n + "<br>";
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a real number for the degree of the fixed power model");
                return;
            }
            k = 1;
            regressionType = 7;
        }
        try {
            MultipleRegression2 mr = new MultipleRegression2(vectors, yVector, !this.FixedPowRadioButton.isSelected());
            Matrix RegCoeff = mr.RegressionEqCoefficients();
            if (this.FixedPowRadioButton.isSelected()) {
                text = text + "a = " + HelperFunctions.formatFloat(RegCoeff.get(0, 0), 5) + "<br>";
            } else if (!logTransform) {
                for (int i = 0; i < k; ++i) {
                    text = text + "b<sub>" + i + "</sub> = " + HelperFunctions.formatFloat(RegCoeff.get(i, 0), 5) + "<br>";
                }
            } else if (this.PowerRadioButton.isSelected()) {
                text = text + "a = " + HelperFunctions.formatFloat(Math.exp(RegCoeff.get(0, 0)), 5) + "<br>";
                text = text + "b = " + HelperFunctions.formatFloat(RegCoeff.get(1, 0), 5) + "<br>";
            } else if (this.ExpRadioButton.isSelected()) {
                text = text + "a = " + HelperFunctions.formatFloat(Math.exp(RegCoeff.get(0, 0)), 5) + "<br>";
                text = text + "b = " + HelperFunctions.formatFloat(Math.exp(RegCoeff.get(1, 0)), 5) + "<br>";
            }
            if (this.GraphCheckBox.isSelected()) {
                JFreeChart chart = GraphFactory.createScatterplot(seriesCollection, this.TitleTextField.getText(), this.XTextField.getText(), this.YTextField.getText(), this.LegendCheckBox.isSelected(), regressionType, regressionArg, min, max);
                StatcatoChartFrame frame = new StatcatoChartFrame(this.TitleTextField.getText(), chart, this.app);
                frame.pack();
                frame.setVisible(true);
            }
            text = text + mr;
        }
        catch (RuntimeException e) {
            this.app.showErrorDialog(e.getMessage());
            return;
        }
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void FixedPowRadioButtonStateChanged(ChangeEvent evt) {
        if (this.FixedPowRadioButton.isSelected()) {
            this.powTextField.setEnabled(true);
        } else {
            this.powTextField.setEnabled(false);
        }
    }

    private void PolyRadioButtonStateChanged(ChangeEvent evt) {
        if (this.PolyRadioButton.isSelected()) {
            this.nTextField.setEnabled(true);
        } else {
            this.nTextField.setEnabled(false);
        }
    }

    private void GraphCheckBoxStateChanged(ChangeEvent evt) {
        if (this.GraphCheckBox.isSelected()) {
            this.GraphPanel.setVisible(true);
            this.pack();
        } else {
            this.GraphPanel.setVisible(false);
            this.pack();
        }
    }
}

