/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.correg;

import Jama.Matrix;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.inferential.MultipleRegression;
import org.statcato.utils.HelperFunctions;

public class MultipleRegressionDialog
extends StatcatoDialog {
    private JButton AddButton;
    private JButton CancelButton;
    private JButton ClearButton;
    private JList ColList;
    private JButton OKButton;
    private JButton RemoveButton;
    private JList VarList;
    private JComboBox YComboBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;

    public MultipleRegressionDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.app = app;
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.initComponents();
        this.customInitComponents();
    }

    private void customInitComponents() {
        this.ParentSpreadsheet.populateMutableColumnsList(this.ColList);
        this.ColList.setSelectionMode(2);
        this.ParentSpreadsheet.populateComboBox(this.YComboBox);
        this.VarList.setSelectionMode(2);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("stat-reg-multiple-regression");
        this.name = "Multiple Regression";
        this.description = "For performing computations that determine the linear regression between multiple variables. ";
        this.helpStrings.add("Select an independent variable under the Select the column containing an independent variable list. Click the Add to list button to add the column to the list of independent variables.");
        this.helpStrings.add("Select the dependent variable under the Select the column containing the dependent variable drop-down menu.");
    }

    @Override
    public void updateElements() {
        this.clearMutableColumnsList(this.ColList);
        this.clearMutableColumnsList(this.VarList);
        this.ParentSpreadsheet.populateMutableColumnsList(this.ColList);
        this.updateComboBox(this.YComboBox);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.RemoveButton = new JButton();
        this.jLabel4 = new JLabel();
        this.YComboBox = new JComboBox();
        this.jScrollPane2 = new JScrollPane();
        this.ColList = new JList(new DefaultListModel());
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.AddButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.VarList = new JList(new DefaultListModel());
        this.ClearButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Multiple Regression");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultipleRegressionDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultipleRegressionDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.RemoveButton.setText("Remove from list >>");
        this.RemoveButton.setEnabled(false);
        this.RemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultipleRegressionDialog.this.RemoveButtonActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Select the column variable containing the dependent variable:");
        this.ColList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MultipleRegressionDialog.this.ColListValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.ColList);
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Independent Variables:");
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText("Dependent Variable:");
        this.jLabel2.setText("<html>Select the column containing<br> \nan independent variable<br>\n(Ctrl-click or Shift-click to <br>\nselect multiple columns):");
        this.AddButton.setText("<< Add to list");
        this.AddButton.setEnabled(false);
        this.AddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultipleRegressionDialog.this.AddButtonActionPerformed(evt);
            }
        });
        this.VarList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MultipleRegressionDialog.this.VarListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.VarList);
        this.ClearButton.setText("Clear Input List");
        this.ClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultipleRegressionDialog.this.ClearButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 103, -2).addGap(26, 26, 26).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.RemoveButton).addComponent(this.AddButton))).addComponent(this.jLabel1)).addGap(31, 31, 31).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -2, -1, -2).addComponent(this.jScrollPane2, -2, 100, -2))).addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel4)).addComponent(this.jLabel3).addComponent(this.ClearButton))).addGroup(jPanel1Layout.createSequentialGroup().addGap(55, 55, 55).addComponent(this.YComboBox, -2, 132, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(0, this.AddButton, this.RemoveButton);
        jPanel1Layout.linkSize(0, this.jScrollPane1, this.jScrollPane2);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane2).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.AddButton).addGap(28, 28, 28).addComponent(this.RemoveButton).addGap(22, 22, 22)).addComponent(this.jScrollPane1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ClearButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 16, Short.MAX_VALUE).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.YComboBox, -2, -1, -2).addContainerGap()));
        jPanel1Layout.linkSize(1, this.jScrollPane1, this.jScrollPane2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(179, 179, 179).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 37, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton))));
        this.pack();
    }

    private void VarListValueChanged(ListSelectionEvent evt) {
        if (this.VarList.getSelectedIndex() != -1) {
            this.RemoveButton.setEnabled(true);
        } else {
            this.RemoveButton.setEnabled(false);
        }
    }

    private void RemoveButtonActionPerformed(ActionEvent evt) {
        Object[] list = this.VarList.getSelectedValues();
        for (int i = 0; i < list.length; ++i) {
            String x = (String)list[i];
            ((DefaultListModel)this.ColList.getModel()).addElement(x);
            ((DefaultListModel)this.VarList.getModel()).removeElement(x);
        }
        this.OKButton.requestFocusInWindow();
    }

    private void AddButtonActionPerformed(ActionEvent evt) {
        Object[] list = this.ColList.getSelectedValues();
        for (int i = 0; i < list.length; ++i) {
            String x = (String)list[i];
            ((DefaultListModel)this.VarList.getModel()).addElement(x);
            ((DefaultListModel)this.ColList.getModel()).removeElement(x);
        }
        this.OKButton.requestFocusInWindow();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("multiple regression");
        String heading = "Multiple Regression";
        String text = "";
        Vector<Vector<Double>> vectors = new Vector<Vector<Double>>();
        if (this.YComboBox.getSelectedIndex() == 0) {
            this.app.showErrorDialog("Select the column containing the dependent variable.");
            return;
        }
        if (this.VarList.getModel().getSize() == 0) {
            this.app.showErrorDialog("Select at least one column containing the independent variables.");
            return;
        }
        String yCol = (String)this.YComboBox.getSelectedItem();
        int yColumn = this.ParentSpreadsheet.parseColumnNumber(yCol);
        Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(yColumn);
        Vector<Double> YColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
        if (YColumnVector == null) {
            this.app.showErrorDialog("Invalid input column " + yCol + ": all data must be numbers.");
            return;
        }
        YColumnVector = HelperFunctions.removeNullValues(YColumnVector);
        int n = YColumnVector.size();
        text = text + "Dependent variable y = " + yCol + "<br>";
        text = text + "Independent variables:<br>";
        for (int i = 0; i < this.VarList.getModel().getSize(); ++i) {
            String x = (String)this.VarList.getModel().getElementAt(i);
            int selectedXColumn = this.ParentSpreadsheet.parseColumnNumber(x);
            StrColumnVector = this.ParentSpreadsheet.getColumn(selectedXColumn);
            Vector<Double> XColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (XColumnVector == null) {
                this.app.showErrorDialog("Invalid input column " + x + ": all data must be numbers.");
                return;
            }
            if (n != (XColumnVector = HelperFunctions.removeNullValues(XColumnVector)).size()) {
                this.app.showErrorDialog("All variables must have the same number of values.");
                return;
            }
            vectors.addElement(XColumnVector);
            text = text + "&nbsp;&nbsp;x<sub>" + (i + 1) + "</sub> = " + x + "<br>";
        }
        int k = vectors.size();
        try {
            int i;
            MultipleRegression mr = new MultipleRegression(vectors, YColumnVector, true);
            Matrix RegCoeff = mr.RegressionEqCoefficients();
            text = text + "Sample size = " + mr.SampleSize() + "<br>";
            text = text + "Number of independent variables = " + mr.NumIndepVar() + "<br><br>";
            text = text + "<u>Regression Equation</u>: Y = b<sub>0</sub> ";
            for (i = 1; i <= k; ++i) {
                text = text + " + b<sub>" + i + "</sub>x<sub>" + i + "</sub>";
            }
            text = text + "<br>";
            for (i = 0; i <= k; ++i) {
                text = text + "b<sub>" + i + "</sub> = " + HelperFunctions.formatFloat(RegCoeff.get(i, 0), 5) + "<br>";
            }
            text = text + "<br>";
            text = text + "<u>Variation</u>:<br>";
            text = text + "Explained variation = " + HelperFunctions.formatFloat(mr.ExplainedVariation(), 4) + "<br>";
            text = text + "Unexplained variation = " + HelperFunctions.formatFloat(mr.UnexplainedVariation(), 4) + "<br>";
            text = text + "Total variation = " + HelperFunctions.formatFloat(mr.TotalVariation(), 4) + "<br>";
            text = text + "Coefficient of determination r<sup>2</sup> = " + HelperFunctions.formatFloat(mr.CoefficientOfDetermination(), 4) + "<br>";
            text = text + "Adjusted Coefficient of determination r<sup>2</sup> = " + HelperFunctions.formatFloat(mr.AdjustedCoefficientOfDetermination(), 4) + "<br>";
            text = text + "Standard error of estimate = " + HelperFunctions.formatFloat(mr.StandardError(), 4) + "<br>";
            text = text + "Test statistics F = " + HelperFunctions.formatFloat(mr.TestStatistics(), 4) + "<br>";
            text = text + "p-Value = " + HelperFunctions.formatFloat(mr.PValue(), 5) + "<br><br>";
        }
        catch (RuntimeException e) {
            this.app.showErrorDialog(e.getMessage());
            return;
        }
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void ColListValueChanged(ListSelectionEvent evt) {
        if (this.ColList.getSelectedIndex() != -1) {
            this.AddButton.setEnabled(true);
        } else {
            this.AddButton.setEnabled(false);
        }
    }

    private void ClearButtonActionPerformed(ActionEvent evt) {
        this.clearMutableColumnsList(this.ColList);
        this.clearMutableColumnsList(this.VarList);
        this.ParentSpreadsheet.populateMutableColumnsList(this.ColList);
    }
}

