/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.ci;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.inferential.CIOnePopProp;
import org.statcato.statistics.inferential.ConfidenceInterval;
import org.statcato.utils.HelperFunctions;

public class CI1PopPropDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JComboBox ColumnComboBox;
    private JTextField ConfidenceTextField;
    private JLabel EventsLabel;
    private JTextField EventsTextField;
    private JButton OKButton;
    private JRadioButton SampleRadioButton;
    private JRadioButton SummaryRadioButton;
    private JLabel TrialsLabel;
    private JTextField TrialsTextField;
    private JLabel jLabel1;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;

    public CI1PopPropDialog(Frame parent, boolean modal, Statcato mTab) {
        super(parent, modal);
        this.initComponents();
        this.app = mTab;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.SampleRadioButton);
        group1.add(this.SummaryRadioButton);
        this.ParentSpreadsheet.populateComboBox(this.ColumnComboBox);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("stat-ci-1prop");
        this.name = "Confidence Interval: One Population Proportion";
        this.description = "For computing the confidence intervals for a population proportion in one population using normal approximation. ";
        this.helpStrings.add("If you provide sample data, put sample values of at most two categories in a column in the datasheet. Select the Samples in column: radio button, and select the column name in the given drop-down menu.");
        this.helpStrings.add("If individual sample data is not available, select the Summarized sample data radio button. Enter the number of trials and the number of events in the provided text boxes.");
        this.helpStrings.add("Enter the confidence level (between 0 and 1) in the Confidence level: text box.");
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.ColumnComboBox);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.ColumnComboBox = new JComboBox();
        this.TrialsTextField = new JTextField();
        this.SampleRadioButton = new JRadioButton();
        this.TrialsLabel = new JLabel();
        this.SummaryRadioButton = new JRadioButton();
        this.EventsLabel = new JLabel();
        this.EventsTextField = new JTextField();
        this.jPanel2 = new JPanel();
        this.ConfidenceTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Confidence Interval: One Population Proportion");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CI1PopPropDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CI1PopPropDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.TrialsTextField.setEnabled(false);
        this.SampleRadioButton.setSelected(true);
        this.SampleRadioButton.setText("Samples in column:");
        this.SampleRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CI1PopPropDialog.this.SampleRadioButtonStateChanged(evt);
            }
        });
        this.TrialsLabel.setText("Number of trials:");
        this.TrialsLabel.setEnabled(false);
        this.SummaryRadioButton.setText("Summarized sample data:");
        this.SummaryRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CI1PopPropDialog.this.SummaryRadioButtonStateChanged(evt);
            }
        });
        this.EventsLabel.setText("Number of events:");
        this.EventsLabel.setEnabled(false);
        this.EventsTextField.setEnabled(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(9, 9, 9).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.EventsLabel).addGroup(jPanel1Layout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.TrialsLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.TrialsTextField).addComponent(this.EventsTextField, -2, 106, -2))).addComponent(this.SampleRadioButton).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.ColumnComboBox, 0, -1, Short.MAX_VALUE)).addComponent(this.SummaryRadioButton, GroupLayout.Alignment.LEADING))).addContainerGap(99, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.SampleRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ColumnComboBox, -2, -1, -2).addGap(10, 10, 10).addComponent(this.SummaryRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.EventsLabel).addComponent(this.EventsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.TrialsLabel).addComponent(this.TrialsTextField, -2, -1, -2)).addContainerGap(16, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Confidence"));
        this.ConfidenceTextField.setText("0.95");
        this.jLabel6.setText("Confidence level:");
        this.jLabel1.setText("0 - 1.00 (e.g. 0.95)");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ConfidenceTextField, -2, 81, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addContainerGap(16, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ConfidenceTextField, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jLabel6)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(91, 91, 91).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2))).addContainerGap(10, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addGap(30, 30, 30).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addGap(20, 20, 20)));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        double confidenceLevel;
        this.app.compoundEdit = new DialogEdit("CI 1 proportion");
        int events = 0;
        int trials = 0;
        String heading = "Confidence Interval - One population proportion:";
        String text = "";
        try {
            confidenceLevel = Double.parseDouble(this.ConfidenceTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
            return;
        }
        if (confidenceLevel <= 0.0 || confidenceLevel >= 1.0) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
            return;
        }
        heading = heading + "  confidence level = " + confidenceLevel;
        if (this.SampleRadioButton.isSelected()) {
            String columnLabel = this.ColumnComboBox.getSelectedItem().toString();
            if (columnLabel.equals("")) {
                this.app.showErrorDialog("Select the input column.");
                return;
            }
            int column = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(column);
            String cat1 = "";
            String cat2 = "";
            int count1 = 0;
            int count2 = 0;
            for (int i = 0; i < StrColumnVector.size(); ++i) {
                String s = StrColumnVector.elementAt(i).getContents().trim();
                if (s.equals("")) continue;
                if (cat1.equals("")) {
                    cat1 = s;
                    ++count1;
                    continue;
                }
                if (s.equals(cat1)) {
                    ++count1;
                    continue;
                }
                if (cat2.equals("")) {
                    cat2 = s;
                    ++count2;
                    continue;
                }
                if (s.equals(cat2)) {
                    ++count2;
                    continue;
                }
                this.app.showErrorDialog("The input column contains more than two categories.");
                return;
            }
            trials = count1 + count2;
            if (trials == 0) {
                this.app.showErrorDialog("The input column is empty.");
                return;
            }
            events = count1;
            text = text + "Input: " + columnLabel + "<br>";
            text = text + "Event: " + cat1 + "<br>";
        } else {
            try {
                events = Integer.parseInt(this.EventsTextField.getText());
                trials = Integer.parseInt(this.TrialsTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Invalid summary data.");
                return;
            }
            if (events > trials) {
                this.app.showErrorDialog("The number of events must not be greater than the number of trials.");
                return;
            }
            text = text + "Input: Summary data<br>";
        }
        double p = (double)events / (double)trials;
        if ((double)trials * p < 5.0 || (double)trials * (1.0 - p) < 5.0) {
            text = text + "WARNING: The sample size is too small for normal approximation to be valid.<br>";
        }
        CIOnePopProp CI = new CIOnePopProp(confidenceLevel, trials, p, CIOnePopProp.NORMAL);
        text = text + "<br><table border='1'>";
        text = text + "<tr><td>Number of trials</td><td>Number of Events</td><td>Sample proportion</td><td>Margin of Error</td><td>" + HelperFunctions.formatFloat(confidenceLevel * 100.0, 2) + "%CI</td></tr>";
        text = text + "<tr><td>" + trials + "</td><td>" + events + "</td><td>" + HelperFunctions.formatFloat(p, 3) + "</td><td>" + HelperFunctions.formatFloat(((ConfidenceInterval)CI).marginOfError(), 3) + "</td><td>" + CI.toString() + "</td></tr></table>";
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void SampleRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SampleRadioButton.isSelected()) {
            this.ColumnComboBox.setEnabled(true);
        } else {
            this.ColumnComboBox.setEnabled(false);
        }
    }

    private void SummaryRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SummaryRadioButton.isSelected()) {
            this.EventsLabel.setEnabled(true);
            this.EventsTextField.setEnabled(true);
            this.TrialsLabel.setEnabled(true);
            this.TrialsTextField.setEnabled(true);
        } else {
            this.EventsLabel.setEnabled(false);
            this.EventsTextField.setEnabled(false);
            this.TrialsLabel.setEnabled(false);
            this.TrialsTextField.setEnabled(false);
        }
    }
}

