/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.basicstats;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.spreadsheet.Spreadsheet;
import org.statcato.statistics.BasicStatistics;
import org.statcato.utils.HelperFunctions;

public class DescriptiveStatisticsDialog
extends StatcatoDialog {
    private String header1 = "";
    private String header2 = "";
    private String header3 = "";
    private String header4 = "";
    private String header5 = "";
    private String header6 = "";
    boolean hasHeader1 = false;
    boolean hasHeader2 = false;
    boolean hasHeader3 = false;
    boolean hasHeader4 = false;
    boolean hasHeader5 = false;
    boolean hasHeader6 = false;
    private JComboBox ByVarComboBox;
    private JButton CancelButton;
    private JCheckBox CoeffVarCheckBox;
    private JCheckBox CumulativeNCheckBox;
    private JCheckBox CumulativePercentCheckBox;
    private JCheckBox FirstQuartileCheckBox;
    private JTextField InputTextField;
    private JCheckBox InterquartileRangeCheckBox;
    private JRadioButton KurtosisBiasedRadioButton;
    private JRadioButton KurtosisC0RadioButton;
    private JRadioButton KurtosisC3RadioButton;
    private JCheckBox KurtosisCheckBox;
    private JPanel KurtosisPanel;
    private JRadioButton KurtosisUnbiasedRadioButton;
    private JCheckBox MSSDCheckBox;
    private JCheckBox MaxCheckBox;
    private JCheckBox MeanCheckBox;
    private JCheckBox MedianCheckBox;
    private JCheckBox MinCheckBox;
    private JCheckBox ModeCheckBox;
    private JCheckBox NmissingCheckBox;
    private JCheckBox NnonmissingCheckBox;
    private JCheckBox NtotalCheckBox;
    private JButton OKButton;
    private JCheckBox PercentCheckBox;
    private JCheckBox PercentileCheckBox;
    private JTextField PercentileTextField;
    private JCheckBox RangeCheckBox;
    private JCheckBox SEMeanCheckBox;
    private JCheckBox SelectAllCheckBox;
    private JRadioButton SkewnessBiasedRadioButton;
    private JCheckBox SkewnessCheckBox;
    private JPanel SkewnessPanel;
    private JRadioButton SkewnessUnbiasedRadioButton;
    private JCheckBox StdevCheckBox;
    private JCheckBox StoreResultCheckBox;
    private JCheckBox SumCheckBox;
    private JCheckBox SumOfSqCheckBox;
    private JCheckBox ThirdQuartileCheckBox;
    private JCheckBox TrimmedMeanCheckBox;
    private JTextField TrimmedPercentTextField;
    private JCheckBox VarianceCheckBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;

    public DescriptiveStatisticsDialog(Frame parent, boolean modal, Statcato mTab) {
        super(parent, modal);
        this.app = mTab;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        this.initComponents();
        this.ParentSpreadsheet.populateComboBox(this.ByVarComboBox);
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.SkewnessBiasedRadioButton);
        group1.add(this.SkewnessUnbiasedRadioButton);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.KurtosisBiasedRadioButton);
        group2.add(this.KurtosisUnbiasedRadioButton);
        ButtonGroup group3 = new ButtonGroup();
        group3.add(this.KurtosisC3RadioButton);
        group3.add(this.KurtosisC0RadioButton);
        this.SkewnessPanel.setVisible(false);
        this.KurtosisPanel.setVisible(false);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("stat-basic-descriptive");
        this.name = "Descriptive Statistics";
        this.description = "For computing descriptive statistics for a set of input column variables or for groups of data within a set of input column variables. ";
        this.helpStrings.add("Specify the names of the input columns. (optional) Select the variable that will be used to group data values in each column.");
        this.helpStrings.add("Select the descriptive statistics to be computed by checking their corresponding check boxes.");
        this.helpStrings.add("Check the Store Results in New Datasheet box if you would like to store the statistics in new datasheet(s). Statistics for each input variable will be stored in separate datasheet.");
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.ByVarComboBox);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.ByVarComboBox = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jLabel1 = new JLabel();
        this.InputTextField = new JTextField();
        this.jLabel8 = new JLabel();
        this.jPanel2 = new JPanel();
        this.StoreResultCheckBox = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.jPanel3 = new JPanel();
        this.SelectAllCheckBox = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.VarianceCheckBox = new JCheckBox();
        this.StdevCheckBox = new JCheckBox();
        this.SEMeanCheckBox = new JCheckBox();
        this.MeanCheckBox = new JCheckBox();
        this.CoeffVarCheckBox = new JCheckBox();
        this.jPanel5 = new JPanel();
        this.InterquartileRangeCheckBox = new JCheckBox();
        this.ModeCheckBox = new JCheckBox();
        this.ThirdQuartileCheckBox = new JCheckBox();
        this.MedianCheckBox = new JCheckBox();
        this.FirstQuartileCheckBox = new JCheckBox();
        this.PercentileCheckBox = new JCheckBox();
        this.PercentileTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jPanel6 = new JPanel();
        this.jLabel5 = new JLabel();
        this.TrimmedPercentTextField = new JTextField();
        this.MinCheckBox = new JCheckBox();
        this.SumCheckBox = new JCheckBox();
        this.RangeCheckBox = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.TrimmedMeanCheckBox = new JCheckBox();
        this.MaxCheckBox = new JCheckBox();
        this.jPanel7 = new JPanel();
        this.NmissingCheckBox = new JCheckBox();
        this.CumulativeNCheckBox = new JCheckBox();
        this.NnonmissingCheckBox = new JCheckBox();
        this.NtotalCheckBox = new JCheckBox();
        this.CumulativePercentCheckBox = new JCheckBox();
        this.PercentCheckBox = new JCheckBox();
        this.jPanel8 = new JPanel();
        this.SkewnessCheckBox = new JCheckBox();
        this.SumOfSqCheckBox = new JCheckBox();
        this.KurtosisCheckBox = new JCheckBox();
        this.MSSDCheckBox = new JCheckBox();
        this.SkewnessPanel = new JPanel();
        this.SkewnessBiasedRadioButton = new JRadioButton();
        this.SkewnessUnbiasedRadioButton = new JRadioButton();
        this.KurtosisPanel = new JPanel();
        this.KurtosisC0RadioButton = new JRadioButton();
        this.KurtosisC3RadioButton = new JRadioButton();
        this.KurtosisUnbiasedRadioButton = new JRadioButton();
        this.KurtosisBiasedRadioButton = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Descriptive Statistics");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DescriptiveStatisticsDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DescriptiveStatisticsDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.ByVarComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DescriptiveStatisticsDialog.this.ByVarComboBoxActionPerformed(evt);
            }
        });
        this.jLabel4.setFont(new Font("Tahoma", 1, 11));
        this.jLabel4.setText("By Variable (optional):");
        this.jLabel4.setToolTipText("By Variable");
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Input Variable(s):");
        this.jLabel1.setToolTipText("Input variables");
        this.jLabel8.setText("<html>\nEnter valid column names separated <br>\nby space. For a continuous range of <br>\ncolumns, separate using dash<br>\n (e.g. C1-C30).\n</html>\n");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.InputTextField, -2, 169, -2).addComponent(this.ByVarComboBox, -2, 172, -2).addComponent(this.jLabel8, -2, 189, -2)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.InputTextField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel8, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ByVarComboBox, -2, -1, -2).addContainerGap(21, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Results"));
        this.StoreResultCheckBox.setText("New datasheet");
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText("Store Results in:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.StoreResultCheckBox).addComponent(this.jLabel3)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.StoreResultCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Statistics"));
        this.SelectAllCheckBox.setText("Select all statistics");
        this.SelectAllCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DescriptiveStatisticsDialog.this.SelectAllCheckBoxActionPerformed(evt);
            }
        });
        this.VarianceCheckBox.setText("Variance");
        this.VarianceCheckBox.setToolTipText("Variance");
        this.StdevCheckBox.setText("Standard deviation");
        this.StdevCheckBox.setToolTipText("Standard deviation");
        this.SEMeanCheckBox.setText("SE of mean");
        this.SEMeanCheckBox.setToolTipText("Standard error of the mean");
        this.MeanCheckBox.setText("Mean");
        this.MeanCheckBox.setToolTipText("Arithmetic mean");
        this.CoeffVarCheckBox.setText("Coefficient of variation");
        this.CoeffVarCheckBox.setToolTipText("Coefficient of variation");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.MeanCheckBox).addComponent(this.SEMeanCheckBox).addComponent(this.StdevCheckBox).addComponent(this.VarianceCheckBox).addComponent(this.CoeffVarCheckBox)).addContainerGap()));
        jPanel4Layout.linkSize(0, this.CoeffVarCheckBox, this.MeanCheckBox, this.SEMeanCheckBox, this.StdevCheckBox, this.VarianceCheckBox);
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.MeanCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SEMeanCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.StdevCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.VarianceCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CoeffVarCheckBox).addContainerGap()));
        jPanel4Layout.linkSize(1, this.CoeffVarCheckBox, this.MeanCheckBox, this.SEMeanCheckBox, this.StdevCheckBox, this.VarianceCheckBox);
        this.InterquartileRangeCheckBox.setText("Interquartile range");
        this.InterquartileRangeCheckBox.setToolTipText("Interquartile range: the difference between the first and third quartiles");
        this.ModeCheckBox.setText("Mode");
        this.ModeCheckBox.setToolTipText("Mode");
        this.ThirdQuartileCheckBox.setText("Third quartile");
        this.ThirdQuartileCheckBox.setToolTipText("Third quartile");
        this.MedianCheckBox.setText("Median");
        this.MedianCheckBox.setToolTipText("Median");
        this.FirstQuartileCheckBox.setText("First quartile");
        this.FirstQuartileCheckBox.setToolTipText("First quartile");
        this.PercentileCheckBox.setText("Percentile:");
        this.PercentileCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DescriptiveStatisticsDialog.this.PercentileCheckBoxStateChanged(evt);
            }
        });
        this.PercentileTextField.setEnabled(false);
        this.jLabel2.setText("<html>e.g. 10 for the <br>\n10<sup>th</sup> percentile</html>\n");
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.PercentileCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.PercentileTextField)).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jLabel2, -2, -1, -2)).addComponent(this.FirstQuartileCheckBox).addComponent(this.MedianCheckBox).addComponent(this.ThirdQuartileCheckBox).addComponent(this.InterquartileRangeCheckBox).addComponent(this.ModeCheckBox)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.FirstQuartileCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.MedianCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ThirdQuartileCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.InterquartileRangeCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ModeCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.PercentileCheckBox).addComponent(this.PercentileTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, -1, -2).addContainerGap(13, Short.MAX_VALUE)));
        this.jLabel5.setText("(between 0 and 100)");
        this.TrimmedPercentTextField.setEnabled(false);
        this.MinCheckBox.setText("Minimum");
        this.MinCheckBox.setToolTipText("Minimum");
        this.SumCheckBox.setText("Sum");
        this.SumCheckBox.setToolTipText("Sum");
        this.RangeCheckBox.setText("Range");
        this.RangeCheckBox.setToolTipText("Range");
        this.jLabel6.setText("% of values to be trimmed");
        this.TrimmedMeanCheckBox.setText("Trimmed mean: cutoff %");
        this.TrimmedMeanCheckBox.setToolTipText("Trimmed mean");
        this.TrimmedMeanCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DescriptiveStatisticsDialog.this.TrimmedMeanCheckBoxStateChanged(evt);
            }
        });
        this.MaxCheckBox.setText("Maximum");
        this.MaxCheckBox.setToolTipText("Maximum");
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.TrimmedMeanCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.TrimmedPercentTextField, -2, 79, -2)).addComponent(this.SumCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel6))).addComponent(this.MinCheckBox).addComponent(this.MaxCheckBox).addComponent(this.RangeCheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGap(9, 9, 9).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.TrimmedMeanCheckBox).addComponent(this.TrimmedPercentTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SumCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.MinCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.MaxCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.RangeCheckBox)).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5))).addContainerGap()));
        this.NmissingCheckBox.setText("N missing");
        this.NmissingCheckBox.setToolTipText("number of missing column entries");
        this.CumulativeNCheckBox.setText("Cumulative N");
        this.CumulativeNCheckBox.setToolTipText("Cumulative N");
        this.NnonmissingCheckBox.setText("N nonmissing");
        this.NnonmissingCheckBox.setToolTipText("number of nonmissing column entries");
        this.NtotalCheckBox.setText("N total");
        this.NtotalCheckBox.setToolTipText(" total (nonmissing and missing) number of column entries");
        this.CumulativePercentCheckBox.setText("Cumulative Percent");
        this.CumulativePercentCheckBox.setToolTipText("Cumulative Percent");
        this.PercentCheckBox.setText("Percent");
        this.PercentCheckBox.setToolTipText("Percent");
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.CumulativeNCheckBox).addComponent(this.NtotalCheckBox).addComponent(this.NmissingCheckBox).addComponent(this.NnonmissingCheckBox).addComponent(this.PercentCheckBox).addComponent(this.CumulativePercentCheckBox)).addContainerGap(41, Short.MAX_VALUE)));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addComponent(this.NnonmissingCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.NmissingCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.NtotalCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CumulativeNCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.PercentCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CumulativePercentCheckBox).addContainerGap(28, Short.MAX_VALUE)));
        this.SkewnessCheckBox.setText("Skewness");
        this.SkewnessCheckBox.setToolTipText("Skewness");
        this.SkewnessCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DescriptiveStatisticsDialog.this.SkewnessCheckBoxStateChanged(evt);
            }
        });
        this.SumOfSqCheckBox.setText("Sum of squares");
        this.SumOfSqCheckBox.setToolTipText("sum of the squared data values");
        this.KurtosisCheckBox.setText("Kurtosis");
        this.KurtosisCheckBox.setToolTipText("Kurtosis");
        this.KurtosisCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DescriptiveStatisticsDialog.this.KurtosisCheckBoxStateChanged(evt);
            }
        });
        this.MSSDCheckBox.setText("MSSD");
        this.MSSDCheckBox.setToolTipText("Mean of Successive Squared Differences");
        this.SkewnessBiasedRadioButton.setSelected(true);
        this.SkewnessBiasedRadioButton.setText("Biased");
        this.SkewnessUnbiasedRadioButton.setText("Unbiased");
        GroupLayout SkewnessPanelLayout = new GroupLayout(this.SkewnessPanel);
        this.SkewnessPanel.setLayout(SkewnessPanelLayout);
        SkewnessPanelLayout.setHorizontalGroup(SkewnessPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(SkewnessPanelLayout.createSequentialGroup().addContainerGap().addGroup(SkewnessPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SkewnessUnbiasedRadioButton).addComponent(this.SkewnessBiasedRadioButton)).addContainerGap()));
        SkewnessPanelLayout.setVerticalGroup(SkewnessPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(SkewnessPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.SkewnessBiasedRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SkewnessUnbiasedRadioButton).addContainerGap()));
        this.KurtosisC0RadioButton.setText("Center at 0");
        this.KurtosisC3RadioButton.setSelected(true);
        this.KurtosisC3RadioButton.setText("Centered at 3");
        this.KurtosisUnbiasedRadioButton.setText("Unbiased");
        this.KurtosisBiasedRadioButton.setSelected(true);
        this.KurtosisBiasedRadioButton.setText("Biased");
        GroupLayout KurtosisPanelLayout = new GroupLayout(this.KurtosisPanel);
        this.KurtosisPanel.setLayout(KurtosisPanelLayout);
        KurtosisPanelLayout.setHorizontalGroup(KurtosisPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(KurtosisPanelLayout.createSequentialGroup().addContainerGap().addGroup(KurtosisPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.KurtosisUnbiasedRadioButton).addComponent(this.KurtosisBiasedRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(KurtosisPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.KurtosisC3RadioButton).addComponent(this.KurtosisC0RadioButton)).addContainerGap()));
        KurtosisPanelLayout.setVerticalGroup(KurtosisPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(KurtosisPanelLayout.createSequentialGroup().addContainerGap().addGroup(KurtosisPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.KurtosisBiasedRadioButton).addComponent(this.KurtosisC3RadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(KurtosisPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.KurtosisUnbiasedRadioButton).addComponent(this.KurtosisC0RadioButton)).addContainerGap()));
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SumOfSqCheckBox).addComponent(this.MSSDCheckBox).addComponent(this.SkewnessCheckBox).addComponent(this.KurtosisCheckBox))).addGroup(jPanel8Layout.createSequentialGroup().addGap(27, 27, 27).addComponent(this.SkewnessPanel, -2, -1, -2)).addGroup(jPanel8Layout.createSequentialGroup().addGap(27, 27, 27).addComponent(this.KurtosisPanel, -2, -1, -2)));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addComponent(this.SumOfSqCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SkewnessCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SkewnessPanel, -2, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.KurtosisCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.KurtosisPanel, -2, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.MSSDCheckBox)));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jPanel7, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel8, -2, -1, -2)).addComponent(this.jPanel6, -2, -1, -2))).addComponent(this.SelectAllCheckBox)).addContainerGap(17, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel6, GroupLayout.Alignment.TRAILING, -2, -1, -2).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.SelectAllCheckBox).addGap(24, 24, 24).addComponent(this.jPanel4, -2, -1, -2))).addGap(11, 11, 11).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel5, -2, -1, -2).addComponent(this.jPanel7, -2, -1, -2).addComponent(this.jPanel8, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addGap(193, 193, 193)).addGroup(layout.createSequentialGroup().addGap(321, 321, 321).addComponent(this.OKButton, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addComponent(this.jPanel3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.CancelButton).addComponent(this.OKButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("descriptive statistics");
        this.hasHeader1 = false;
        this.hasHeader2 = false;
        this.hasHeader3 = false;
        this.hasHeader4 = false;
        this.hasHeader5 = false;
        this.hasHeader6 = false;
        int[] columnNumbers = this.ParentSpreadsheet.getColumnNumbersArrayFromString(this.InputTextField.getText());
        if (columnNumbers.length == 0) {
            this.app.showErrorDialog("Invalid input column(s).");
            return;
        }
        String byVarLabel = this.ByVarComboBox.getSelectedItem().toString();
        int byVarColNum = -1;
        Vector<Cell> byVarColVector = null;
        boolean hasByVar = false;
        TreeSet<String> groupSet = new TreeSet<String>();
        if (!byVarLabel.equals("")) {
            hasByVar = true;
            byVarColNum = this.ParentSpreadsheet.parseColumnNumber(byVarLabel);
            byVarColVector = this.ParentSpreadsheet.getColumn(byVarColNum);
            Enumeration<Cell> e = byVarColVector.elements();
            while (e.hasMoreElements()) {
                Cell next = e.nextElement();
                if (next.getContents().equals("")) continue;
                groupSet.add(next.getContents());
            }
        }
        Vector<String> varNameVector = new Vector<String>(0);
        Vector<Vector<String>> ResultVectors = new Vector<Vector<String>>(0);
        this.header1 = "<tr><th align='left'>Variable</th>";
        if (hasByVar) {
            this.header1 = this.header1 + "<th align='left'>Group</th>";
            varNameVector.addElement("group");
        }
        if (this.MeanCheckBox.isSelected()) {
            this.header1 = this.header1 + "<th align='right'>Mean</th>";
            this.hasHeader1 = true;
            varNameVector.addElement("mean");
        }
        if (this.SEMeanCheckBox.isSelected()) {
            this.header1 = this.header1 + "<th align='right'>SE Mean</th>";
            this.hasHeader1 = true;
            varNameVector.addElement("SEMean");
        }
        if (this.StdevCheckBox.isSelected()) {
            this.header1 = this.header1 + "<th align='right'>Standard<br>Deviation</th>";
            this.hasHeader1 = true;
            varNameVector.addElement("stdev");
        }
        if (this.VarianceCheckBox.isSelected()) {
            this.header1 = this.header1 + "<th align='right'>Variance</th>";
            this.hasHeader1 = true;
            varNameVector.addElement("variance");
        }
        if (this.CoeffVarCheckBox.isSelected()) {
            this.header1 = this.header1 + "<th align='right'>Coefficient<br>of Variation</th>";
            this.hasHeader1 = true;
            varNameVector.addElement("coeffVar");
        }
        this.header1 = this.header1 + "</tr>";
        this.header2 = "<tr><th align='left'>Variable</th>";
        if (hasByVar) {
            this.header2 = this.header2 + "<th align='left'>Group</th>";
        }
        if (this.FirstQuartileCheckBox.isSelected()) {
            this.header2 = this.header2 + "<th align='right'>Q1</th>";
            this.hasHeader2 = true;
            varNameVector.addElement("Q1");
        }
        if (this.MedianCheckBox.isSelected()) {
            this.header2 = this.header2 + "<th align='right'>Median</th>";
            this.hasHeader2 = true;
            varNameVector.addElement("median");
        }
        if (this.ThirdQuartileCheckBox.isSelected()) {
            this.header2 = this.header2 + "<th align='right'>Q3</th>";
            this.hasHeader2 = true;
            varNameVector.addElement("Q3");
        }
        if (this.InterquartileRangeCheckBox.isSelected()) {
            this.header2 = this.header2 + "<th align='right'>IQR</th>";
            this.hasHeader2 = true;
            varNameVector.addElement("IQR");
        }
        if (this.ModeCheckBox.isSelected()) {
            this.header2 = this.header2 + "<th align='right'>Mode</th>";
            this.header2 = this.header2 + "<th align='right'>N for mode</th>";
            this.hasHeader2 = true;
            varNameVector.addElement("mode");
        }
        if (this.PercentileCheckBox.isSelected()) {
            this.header2 = this.header2 + "<th align='right'>Percentile</th>";
            this.hasHeader2 = true;
            varNameVector.addElement("percentile");
        }
        this.header2 = this.header2 + "</tr>";
        this.header3 = "<tr><th align='left'>Variable</th>";
        if (hasByVar) {
            this.header3 = this.header3 + "<th align='left'>Group</th>";
        }
        if (this.TrimmedMeanCheckBox.isSelected()) {
            this.header3 = this.header3 + "<th align='right'>Trimmed<br>Mean</th>";
            this.hasHeader3 = true;
            varNameVector.addElement("trMean");
        }
        if (this.SumCheckBox.isSelected()) {
            this.header3 = this.header3 + "<th align='right'>Sum</th>";
            this.hasHeader3 = true;
            varNameVector.addElement("sum");
        }
        if (this.MinCheckBox.isSelected()) {
            this.header3 = this.header3 + "<th align='right'>Min</th>";
            this.hasHeader3 = true;
            varNameVector.addElement("min");
        }
        if (this.MaxCheckBox.isSelected()) {
            this.header3 = this.header3 + "<th align='right'>Max</th>";
            this.hasHeader3 = true;
            varNameVector.addElement("max");
        }
        if (this.RangeCheckBox.isSelected()) {
            this.header3 = this.header3 + "<th align='right'>Range</th>";
            this.hasHeader3 = true;
            varNameVector.addElement("range");
        }
        this.header3 = this.header3 + "</tr>";
        this.header4 = "<tr><th align='left'>Variable</th>";
        if (hasByVar) {
            this.header4 = this.header4 + "<th align='left'>Group</th>";
        }
        if (this.SumOfSqCheckBox.isSelected()) {
            this.header4 = this.header4 + "<th align='right'>Sum of<br>Squares</th>";
            this.hasHeader4 = true;
            varNameVector.addElement("sumOfSq");
        }
        if (this.SkewnessCheckBox.isSelected()) {
            this.header4 = this.SkewnessBiasedRadioButton.isSelected() ? this.header4 + "<th align='right'>Skewness (biased)</th>" : this.header4 + "<th align='right'>Skewness (unbiased)</th>";
            this.hasHeader4 = true;
            varNameVector.addElement("skewness");
        }
        if (this.KurtosisCheckBox.isSelected()) {
            this.header4 = this.KurtosisBiasedRadioButton.isSelected() ? (this.KurtosisC0RadioButton.isSelected() ? this.header4 + "<th align='right'>Kurtosis(biased, centered at 0)</th>" : this.header4 + "<th align='right'>Kurtosis(biased, centered at 3)</th>") : (this.KurtosisC0RadioButton.isSelected() ? this.header4 + "<th align='right'>Kurtosis(unbiased, centered at 0)</th>" : this.header4 + "<th align='right'>Kurtosis(unbiased, centered at 3)</th>");
            this.hasHeader4 = true;
            varNameVector.addElement("kurtosis");
        }
        if (this.MSSDCheckBox.isSelected()) {
            this.header4 = this.header4 + "<th align='right'>MSSD</th>";
            this.hasHeader4 = true;
            varNameVector.addElement("MSSD");
        }
        this.header4 = this.header4 + "</tr>";
        this.header5 = "<tr><th align='left'>Variable</th>";
        if (hasByVar) {
            this.header5 = this.header5 + "<th align='left'>Group</th>";
        }
        if (this.NnonmissingCheckBox.isSelected()) {
            this.header5 = this.header5 + "<th align='right'>N<br>nonmissing</th>";
            this.hasHeader5 = true;
            varNameVector.addElement("Nnonmissing");
        }
        if (this.NmissingCheckBox.isSelected()) {
            this.header5 = this.header5 + "<th align='right'>N<br>missing</th>";
            this.hasHeader5 = true;
            varNameVector.addElement("Nmissing");
        }
        if (this.NtotalCheckBox.isSelected()) {
            this.header5 = this.header5 + "<th align='right'>N<br>total</th>";
            this.hasHeader5 = true;
            varNameVector.addElement("Ntotal");
        }
        this.header5 = this.header5 + "</tr>";
        this.header6 = "<tr><th align='left'>Variable</th>";
        if (hasByVar) {
            this.header6 = this.header6 + "<th align='left'>Group</th>";
        }
        if (this.CumulativeNCheckBox.isSelected()) {
            this.header6 = this.header6 + "<th align='right'>Cumulative<br>N</th>";
            this.hasHeader6 = true;
            varNameVector.addElement("cumN");
        }
        if (this.PercentCheckBox.isSelected()) {
            this.header6 = this.header6 + "<th align='right'>Percent</th>";
            this.hasHeader6 = true;
            varNameVector.addElement("percent");
        }
        if (this.CumulativePercentCheckBox.isSelected()) {
            this.header6 = this.header6 + "<th align='right'>Cumulative<br>Percent</th>";
            this.hasHeader6 = true;
            varNameVector.addElement("cumPercent");
        }
        this.header6 = this.header6 + "</tr>";
        if (this.TrimmedMeanCheckBox.isSelected()) {
            double percent;
            try {
                percent = Double.parseDouble(this.TrimmedPercentTextField.getText());
            }
            catch (NumberFormatException exception) {
                this.app.showErrorDialog("Enter a valid cutoff percent to compute trimmed mean.");
                return;
            }
            if (percent < 0.0 || percent > 100.0) {
                this.app.showErrorDialog("Cutoff percent for trimmed mean must be between 0 and 1.");
                return;
            }
        }
        String result1 = "";
        String result2 = "";
        String result3 = "";
        String result4 = "";
        String result5 = "";
        String result6 = "";
        int[] nonmissingArray = new int[groupSet.size()];
        for (int i = 0; i < columnNumbers.length; ++i) {
            int total;
            int nonmissing;
            Vector ResultVector;
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(columnNumbers[i]);
            String columnLabel = this.ParentSpreadsheet.getColumnFullLabel(columnNumbers[i]);
            if (hasByVar) {
                ResultVectors = new Vector(0);
                int cumTotal = 0;
                int numGroups = 0;
                Iterator iter = groupSet.iterator();
                while (iter.hasNext()) {
                    ++numGroups;
                    String groupName = (String)iter.next();
                    Vector<Cell> subVector = new Vector<Cell>(0);
                    for (int j = 0; j < StrColumnVector.size(); ++j) {
                        String label = byVarColVector.elementAt(j).getContents();
                        if (!label.equals(groupName)) continue;
                        subVector.addElement(StrColumnVector.elementAt(j));
                    }
                    Object[] values = this.computeGroupStatistics(subVector, columnLabel, groupName);
                    if (values == null) {
                        return;
                    }
                    ResultVector = (Vector)values[0];
                    ResultVector.insertElementAt(groupName, 0);
                    ResultVectors.addElement(ResultVector);
                    result1 = result1 + (String)values[1];
                    result2 = result2 + (String)values[2];
                    result3 = result3 + (String)values[3];
                    result4 = result4 + (String)values[4];
                    result5 = result5 + (String)values[5];
                    nonmissing = (Integer)values[6];
                    total = (Integer)values[7];
                    nonmissingArray[numGroups - 1] = nonmissing;
                    cumTotal += total;
                }
                int subtotal = 0;
                double cumPercent = 0.0;
                numGroups = 0;
                for (String groupName : groupSet) {
                    result6 = result6 + "<tr><th align='left'>" + columnLabel + "</th>";
                    if (!groupName.equals("")) {
                        result6 = result6 + "<td align='left'>" + groupName + "</td>";
                    }
                    subtotal += nonmissingArray[numGroups];
                    double percent = (double)nonmissingArray[numGroups] / (double)cumTotal * 100.0;
                    cumPercent += percent;
                    Vector<String> vec = ResultVectors.elementAt(numGroups);
                    if (this.CumulativeNCheckBox.isSelected()) {
                        result6 = result6 + "<td align='right'>" + subtotal + "</td>";
                        vec.addElement(subtotal + "");
                    }
                    if (this.PercentCheckBox.isSelected()) {
                        result6 = result6 + "<td align='right'>" + HelperFunctions.formatFloat(percent) + "</td>";
                        vec.addElement(percent + "");
                    }
                    if (this.CumulativePercentCheckBox.isSelected()) {
                        result6 = result6 + "<td align='right'>" + HelperFunctions.formatFloat(cumPercent) + "</td>";
                        vec.addElement(cumPercent + "");
                    }
                    result6 = result6 + "</tr>";
                    ++numGroups;
                }
            } else {
                Object[] values = this.computeGroupStatistics(StrColumnVector, columnLabel, "");
                if (values == null) {
                    return;
                }
                ResultVectors = new Vector(0);
                ResultVector = (Vector)values[0];
                result1 = result1 + (String)values[1];
                result2 = result2 + (String)values[2];
                result3 = result3 + (String)values[3];
                result4 = result4 + (String)values[4];
                result5 = result5 + (String)values[5];
                nonmissing = (Integer)values[6];
                total = (Integer)values[7];
                double percent = (double)nonmissing / (double)total;
                result6 = result6 + "<tr><th align='left'>" + columnLabel + "</th>";
                if (this.CumulativeNCheckBox.isSelected()) {
                    ResultVector.addElement(nonmissing + "");
                    result6 = result6 + "<td align='right'>" + nonmissing + "</td>";
                }
                if (this.PercentCheckBox.isSelected()) {
                    ResultVector.addElement(percent + "");
                    result6 = result6 + "<td align='right'>" + HelperFunctions.formatFloat(percent) + "</td>";
                }
                if (this.CumulativePercentCheckBox.isSelected()) {
                    ResultVector.addElement(percent + "");
                    result6 = result6 + "<td align='right'>" + HelperFunctions.formatFloat(percent) + "</td>";
                }
                result6 = result6 + "</tr>";
                ResultVectors.addElement(ResultVector);
            }
            if (!this.StoreResultCheckBox.isSelected()) continue;
            Spreadsheet ThisSpreadsheet = new Spreadsheet(this.app);
            this.app.getDatasheetTabbedPane().addDatasheet(ThisSpreadsheet);
            ThisSpreadsheet.setData(ResultVectors);
            ThisSpreadsheet.setVariablesRow(varNameVector);
            this.app.getDatasheetTabbedPane().setCurrentTabTitle("DS: " + columnLabel + "*");
        }
        this.app.addLogHeading("Descriptive Statistics");
        if (this.hasHeader1) {
            this.app.addLogText("<table border='1' cellpadding='3'>" + this.header1 + result1 + "</table><br>");
        }
        if (this.hasHeader2) {
            this.app.addLogText("<table border='1' cellpadding='3'>" + this.header2 + result2 + "</table><br>");
        }
        if (this.hasHeader3) {
            this.app.addLogText("<table border='1' cellpadding='3'>" + this.header3 + result3 + "</table><br>");
        }
        if (this.hasHeader4) {
            this.app.addLogText("<table border='1' cellpadding='3'>" + this.header4 + result4 + "</table><br>");
        }
        if (this.hasHeader5) {
            this.app.addLogText("<table border='1' cellpadding='3'>" + this.header5 + result5 + "</table><br>");
        }
        if (this.hasHeader6) {
            this.app.addLogText("<table border='1' cellpadding='3'>" + this.header6 + result6 + "</table><br>");
        }
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private Object[] computeGroupStatistics(Vector<Cell> StrColumnVector, String columnLabel, String groupLabel) {
        String m;
        String q;
        String q2;
        int total;
        int missing;
        String result1 = "";
        String result2 = "";
        String result3 = "";
        String result4 = "";
        String result5 = "";
        Vector<Double> ColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
        if (ColumnVector == null) {
            this.app.showErrorDialog("Invalid input column " + columnLabel + ": all data must be numbers.");
            return null;
        }
        if (HelperFunctions.isEmptyVector(ColumnVector)) {
            this.app.showErrorDialog("Empty input column " + columnLabel + ".");
            return null;
        }
        int nonmissing = BasicStatistics.Nnonmissing(ColumnVector);
        if (groupLabel.equals("")) {
            missing = BasicStatistics.Nmissing(ColumnVector);
            total = BasicStatistics.Ntotal(ColumnVector);
        } else {
            total = ColumnVector.size();
            missing = total - nonmissing;
        }
        Vector<String> ResultVector = new Vector<String>(0);
        result1 = result1 + "<tr><th align='left'>" + columnLabel + "</th>";
        if (!groupLabel.equals("")) {
            result1 = result1 + "<td align='left'>" + groupLabel + "</td>";
        }
        if (this.MeanCheckBox.isSelected()) {
            Double mean = BasicStatistics.mean(ColumnVector);
            String mea = mean == null ? "*" : HelperFunctions.formatFloat(mean);
            ResultVector.addElement(mea);
            result1 = result1 + "<td align='right'>" + mea + "</td>";
        }
        if (this.SEMeanCheckBox.isSelected()) {
            Double SEmean = BasicStatistics.SEmean(ColumnVector);
            q2 = SEmean == null ? "*" : HelperFunctions.formatFloat(SEmean);
            ResultVector.addElement(q2);
            result1 = result1 + "<td align='right'>" + q2 + "</td>";
        }
        if (this.StdevCheckBox.isSelected()) {
            Double stdev = BasicStatistics.stdev(ColumnVector);
            q2 = stdev == null ? "*" : HelperFunctions.formatFloat(stdev);
            ResultVector.addElement(q2);
            result1 = result1 + "<td align='right'>" + q2 + "</td>";
        }
        if (this.VarianceCheckBox.isSelected()) {
            Double variance = BasicStatistics.variance(ColumnVector);
            q2 = variance == null ? "*" : HelperFunctions.formatFloat(variance);
            ResultVector.addElement(q2);
            result1 = result1 + "<td align='right'>" + q2 + "</td>";
        }
        if (this.CoeffVarCheckBox.isSelected()) {
            Double coeffVar = BasicStatistics.coefficientOfVariance(ColumnVector);
            q2 = coeffVar == null ? "*" : HelperFunctions.formatFloat(coeffVar);
            ResultVector.addElement(q2);
            result1 = result1 + "<td align='right'>" + q2 + "</td>";
        }
        result1 = result1 + "</tr>";
        result2 = result2 + "<tr><th align='left'>" + columnLabel + "</th>";
        if (!groupLabel.equals("")) {
            result2 = result2 + "<td align='left'>" + groupLabel + "</td>";
        }
        if (this.FirstQuartileCheckBox.isSelected()) {
            Double quartile1 = BasicStatistics.firstQuartile(ColumnVector);
            String q1 = quartile1 == null ? "*" : HelperFunctions.formatFloat(quartile1);
            ResultVector.addElement(q1 + "");
            result2 = result2 + "<td align='right'>" + q1 + "</td>";
        }
        if (this.MedianCheckBox.isSelected()) {
            Double median = BasicStatistics.median(ColumnVector);
            String med = median == null ? "*" : HelperFunctions.formatFloat(median);
            ResultVector.addElement(med + "");
            result2 = result2 + "<td align='right'>" + med + "</td>";
        }
        if (this.ThirdQuartileCheckBox.isSelected()) {
            Double quartile = BasicStatistics.thirdQuartile(ColumnVector);
            q2 = quartile == null ? "*" : HelperFunctions.formatFloat(quartile);
            ResultVector.addElement(q2 + "");
            result2 = result2 + "<td align='right'>" + q2 + "</td>";
        }
        if (this.InterquartileRangeCheckBox.isSelected()) {
            Double IRQ = BasicStatistics.interquartileRange(ColumnVector);
            q2 = IRQ == null ? "*" : HelperFunctions.formatFloat(IRQ);
            ResultVector.addElement(q2 + "");
            result2 = result2 + "<td align='right'>" + q2 + "</td>";
        }
        if (this.ModeCheckBox.isSelected()) {
            String modesStr;
            Object[] results = BasicStatistics.mode(ColumnVector);
            Vector modes = (Vector)results[0];
            int numOcc = (Integer)results[1];
            if (modes.size() == 0) {
                modesStr = "*";
            } else {
                modesStr = "";
                Enumeration e = modes.elements();
                while (e.hasMoreElements()) {
                    double num = (Double)e.nextElement();
                    if (!modesStr.equals("")) {
                        modesStr = modesStr + ", ";
                    }
                    modesStr = modesStr + num;
                }
            }
            ResultVector.addElement(modesStr);
            result2 = result2 + "<td align='right'>" + modesStr + "</td>";
            result2 = result2 + "<td align='right'>" + numOcc + "</td>";
        }
        if (this.PercentileCheckBox.isSelected()) {
            try {
                double n = Double.parseDouble(this.PercentileTextField.getText());
                if (n < 0.0 || n > 100.0) {
                    this.app.showErrorDialog("Enter a valid n for the nth percentile");
                    return null;
                }
                Double percentile = BasicStatistics.percentile(ColumnVector, n);
                q = percentile == null ? "*" : HelperFunctions.formatFloat(percentile);
                ResultVector.addElement(q + "");
                result2 = result2 + "<td align='right'>" + q + " (" + n + "th)</td>";
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a valid n for the nth percentile");
                return null;
            }
        }
        result2 = result2 + "</tr>";
        result3 = result3 + "<tr><th align='left'>" + columnLabel + "</th>";
        if (!groupLabel.equals("")) {
            result3 = result3 + "<td align='left'>" + groupLabel + "</td>";
        }
        if (this.TrimmedMeanCheckBox.isSelected()) {
            try {
                double tpercent = Double.parseDouble(this.TrimmedPercentTextField.getText());
                if (tpercent < 0.0 || tpercent > 100.0) {
                    this.app.showErrorDialog("Enter a valid percent for trimmed mean");
                    return null;
                }
                Double TrMean = BasicStatistics.trimmedMean(ColumnVector, tpercent);
                q = TrMean == null ? "*" : HelperFunctions.formatFloat(TrMean);
                ResultVector.addElement(q + "");
                result3 = result3 + "<td align='right'>" + q + "</td>";
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a valid percent for trimmed mean");
                return null;
            }
        }
        if (this.SumCheckBox.isSelected()) {
            double sum = BasicStatistics.sum(ColumnVector);
            ResultVector.addElement(sum + "");
            result3 = result3 + "<td align='right'>" + HelperFunctions.formatFloat(sum) + "</td>";
        }
        if (this.MinCheckBox.isSelected()) {
            Double min = BasicStatistics.min(ColumnVector);
            m = min == null ? "*" : HelperFunctions.formatFloat(min);
            ResultVector.addElement(m);
            result3 = result3 + "<td align='right'>" + m + "</td>";
        }
        if (this.MaxCheckBox.isSelected()) {
            Double max = BasicStatistics.max(ColumnVector);
            m = max == null ? "*" : HelperFunctions.formatFloat(max);
            ResultVector.addElement(m);
            result3 = result3 + "<td align='right'>" + m + "</td>";
        }
        if (this.RangeCheckBox.isSelected()) {
            Double range = BasicStatistics.range(ColumnVector);
            String r = range == null ? "*" : HelperFunctions.formatFloat(range);
            ResultVector.addElement(r);
            result3 = result3 + "<td align='right'>" + r + "</td>";
        }
        result3 = result3 + "</tr>";
        result4 = result4 + "<tr><th align='left'>" + columnLabel + "</th>";
        if (!groupLabel.equals("")) {
            result4 = result4 + "<td align='left'>" + groupLabel + "</td>";
        }
        if (this.SumOfSqCheckBox.isSelected()) {
            double sumOfSq = BasicStatistics.sumOfSquares(ColumnVector);
            ResultVector.addElement(sumOfSq + "");
            result4 = result4 + "<td align='right'>" + HelperFunctions.formatFloat(sumOfSq) + "</td>";
        }
        if (this.SkewnessCheckBox.isSelected()) {
            Double skew = this.SkewnessBiasedRadioButton.isSelected() ? BasicStatistics.skewnessBiased(ColumnVector) : BasicStatistics.skewness(ColumnVector);
            q2 = skew == null ? "*" : HelperFunctions.formatFloat(skew);
            ResultVector.addElement(q2);
            result4 = result4 + "<td align='right'>" + q2 + "</td>";
        }
        if (this.KurtosisCheckBox.isSelected()) {
            Double kurtosis = this.KurtosisBiasedRadioButton.isSelected() ? (this.KurtosisC0RadioButton.isSelected() ? BasicStatistics.kurtosisBiased(ColumnVector) : BasicStatistics.kurtosisBiasedCentered3(ColumnVector)) : (this.KurtosisC0RadioButton.isSelected() ? BasicStatistics.kurtosis(ColumnVector) : BasicStatistics.kurtosisCentered3(ColumnVector));
            q2 = kurtosis == null ? "*" : HelperFunctions.formatFloat(kurtosis);
            ResultVector.addElement(q2);
            result4 = result4 + "<td align='right'>" + q2 + "</td>";
        }
        if (this.MSSDCheckBox.isSelected()) {
            Double sum = BasicStatistics.MSSD(ColumnVector);
            q2 = sum == null ? "*" : HelperFunctions.formatFloat(sum);
            ResultVector.addElement(q2);
            result4 = result4 + "<td align='right'>" + q2 + "</td>";
        }
        result4 = result4 + "</tr>";
        result5 = result5 + "<tr><th align='left'>" + columnLabel + "</th>";
        if (!groupLabel.equals("")) {
            result5 = result5 + "<td align='left'>" + groupLabel + "</td>";
        }
        if (this.NnonmissingCheckBox.isSelected()) {
            ResultVector.addElement(nonmissing + "");
            result5 = result5 + "<td align='right'>" + nonmissing + "</td>";
        }
        if (this.NmissingCheckBox.isSelected()) {
            ResultVector.addElement(missing + "");
            result5 = result5 + "<td align='right'>" + missing + "</td>";
        }
        if (this.NtotalCheckBox.isSelected()) {
            ResultVector.addElement(total + "");
            result5 = result5 + "<td align='right'>" + total + "</td>";
        }
        result5 = result5 + "</tr>";
        Object[] returnValues = new Object[]{ResultVector, result1, result2, result3, result4, result5, new Integer(nonmissing), new Integer(total)};
        return returnValues;
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void ByVarComboBoxActionPerformed(ActionEvent evt) {
    }

    private void SelectAllCheckBoxActionPerformed(ActionEvent evt) {
        if (this.SelectAllCheckBox.isSelected()) {
            this.toggleAllCheckBoxes(true);
        } else {
            this.toggleAllCheckBoxes(false);
        }
        this.TrimmedPercentTextField.setEnabled(true);
    }

    private void SkewnessCheckBoxStateChanged(ChangeEvent evt) {
        if (this.SkewnessCheckBox.isSelected()) {
            this.SkewnessPanel.setVisible(true);
        } else {
            this.SkewnessPanel.setVisible(false);
        }
    }

    private void KurtosisCheckBoxStateChanged(ChangeEvent evt) {
        if (this.KurtosisCheckBox.isSelected()) {
            this.KurtosisPanel.setVisible(true);
        } else {
            this.KurtosisPanel.setVisible(false);
        }
    }

    private void PercentileCheckBoxStateChanged(ChangeEvent evt) {
        if (this.PercentileCheckBox.isSelected()) {
            this.PercentileTextField.setEnabled(true);
        } else {
            this.PercentileTextField.setEnabled(false);
        }
    }

    private void TrimmedMeanCheckBoxStateChanged(ChangeEvent evt) {
        if (this.TrimmedMeanCheckBox.isSelected()) {
            this.TrimmedPercentTextField.setEnabled(true);
        } else {
            this.TrimmedPercentTextField.setEnabled(false);
        }
    }

    private void toggleAllCheckBoxes(boolean state) {
        this.CoeffVarCheckBox.setSelected(state);
        this.CumulativeNCheckBox.setSelected(state);
        this.CumulativePercentCheckBox.setSelected(state);
        this.FirstQuartileCheckBox.setSelected(state);
        this.InterquartileRangeCheckBox.setSelected(state);
        this.KurtosisCheckBox.setSelected(state);
        this.MSSDCheckBox.setSelected(state);
        this.MaxCheckBox.setSelected(state);
        this.MeanCheckBox.setSelected(state);
        this.MedianCheckBox.setSelected(state);
        this.MinCheckBox.setSelected(state);
        this.ModeCheckBox.setSelected(state);
        this.NmissingCheckBox.setSelected(state);
        this.NnonmissingCheckBox.setSelected(state);
        this.NtotalCheckBox.setSelected(state);
        this.PercentCheckBox.setSelected(state);
        this.RangeCheckBox.setSelected(state);
        this.SEMeanCheckBox.setSelected(state);
        this.SkewnessCheckBox.setSelected(state);
        this.StdevCheckBox.setSelected(state);
        this.SumCheckBox.setSelected(state);
        this.SumOfSqCheckBox.setSelected(state);
        this.ThirdQuartileCheckBox.setSelected(state);
        this.TrimmedMeanCheckBox.setSelected(state);
        this.VarianceCheckBox.setSelected(state);
        this.PercentileCheckBox.setSelected(state);
    }
}

