/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.graph;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYDotRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.graph.StatcatoChartFrame;
import org.statcato.spreadsheet.Cell;
import org.statcato.utils.HelperFunctions;

public class DotPlotDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JList InputVarList;
    private JCheckBox LegendCheckBox;
    private JButton OKButton;
    private JTextField TitleTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextField xTextField;
    private JTextField yTextField;

    public DotPlotDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.app = (Statcato)parent;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        this.initComponents();
        this.customInitComponents();
        this.setHelpFile("graph-dotplot");
        this.name = "Dot Plot";
        this.description = "For creating dot plots showing the occurrences of each distinct data value as a stack of dots.";
        this.helpStrings.add("Select the column variable(s) containing data values for which the plot will be created. A distinct marker is used with each column variable.");
        this.helpStrings.add("Enter the plot title, the x-axis label, and the y-axis label in the corresponding text fields.");
        this.helpStrings.add("Select the Show Legend check box to show a legend indicating the graph variables.");
        this.pack();
    }

    @Override
    public void updateElements() {
        this.updateColumnsList(this.InputVarList);
    }

    private void customInitComponents() {
        this.ParentSpreadsheet.populateColumnsList(this.InputVarList);
        this.getRootPane().setDefaultButton(this.OKButton);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.yTextField = new JTextField();
        this.TitleTextField = new JTextField();
        this.xTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel3 = new JLabel();
        this.LegendCheckBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.InputVarList = new JList();
        this.setDefaultCloseOperation(2);
        this.setTitle("Dot Plot");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DotPlotDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DotPlotDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Graph Options"));
        this.jLabel2.setText("Plot Title:");
        this.TitleTextField.setText("Dot Plot");
        this.jLabel4.setText("Y-axis Label:");
        this.jLabel3.setText("X-axis Label:");
        this.LegendCheckBox.setSelected(true);
        this.LegendCheckBox.setText("Show legend");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.TitleTextField, -2, 217, -2).addGap(2, 2, 2)).addComponent(this.xTextField, -1, 217, Short.MAX_VALUE).addComponent(this.yTextField, -1, 217, Short.MAX_VALUE))).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.LegendCheckBox).addContainerGap(206, Short.MAX_VALUE)))));
        jPanel2Layout.linkSize(0, this.TitleTextField, this.xTextField, this.yTextField);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.TitleTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.xTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.yTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 9, Short.MAX_VALUE).addComponent(this.LegendCheckBox)));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Graph Variable"));
        this.jLabel1.setText("Select the column for which the plot will be created:");
        this.jLabel5.setText("Ctrl-click to select multiple variables");
        this.jScrollPane1.setViewportView(this.InputVarList);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 125, -2).addComponent(this.jLabel1).addComponent(this.jLabel5)).addContainerGap(46, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 140, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGap(90, 90, 90).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addGap(21, 21, 21)));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("dot plot");
        String heading = "Dot Plot";
        String text = "Input variables: ";
        Object[] SelectedColumns = this.InputVarList.getSelectedValues();
        int[] columnNumbers = this.ParentSpreadsheet.convertColumnLabelsToNumbers(SelectedColumns);
        if (columnNumbers.length == 0) {
            this.app.showErrorDialog("Select at least one input variable.");
            return;
        }
        XYSeriesCollection seriesCollection = new XYSeriesCollection();
        TreeMap cumHash = new TreeMap();
        for (int i = 0; i < columnNumbers.length; ++i) {
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(columnNumbers[i]);
            String columnLabel = (String)SelectedColumns[i];
            text = text + columnLabel + " ";
            Vector<Double> ColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (ColumnVector == null) {
                this.app.showErrorDialog("Invalid input column " + columnLabel + ": all data must be numbers.");
                return;
            }
            seriesCollection.addSeries(this.makeSeries(columnLabel, ColumnVector, cumHash));
        }
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.createPlot(seriesCollection);
        this.setVisible(false);
    }

    private XYSeries makeSeries(String name, Vector<Double> YColumnVector, TreeMap cumHash) {
        XYSeries series = new XYSeries((Comparable)((Object)name));
        TreeMap hash = HelperFunctions.ComputeFrequency(YColumnVector);
        Set set = hash.keySet();
        for (Double cat : set) {
            int count = (Integer)hash.get(cat);
            int offset = 0;
            if (cumHash.containsKey(cat)) {
                offset = (Integer)cumHash.get(cat);
                cumHash.put(cat, new Integer(count + offset));
            } else {
                cumHash.put(cat, new Integer(count));
            }
            for (int i = 1; i <= count; ++i) {
                series.add((double)cat, i + offset);
            }
        }
        return series;
    }

    private void createPlot(XYSeriesCollection data) {
        XYSeriesCollection data1 = data;
        XYDotRenderer renderer1 = new XYDotRenderer();
        JFreeChart plot = ChartFactory.createScatterPlot(this.TitleTextField.getText(), this.xTextField.getText(), this.yTextField.getText(), data1, PlotOrientation.VERTICAL, this.LegendCheckBox.isSelected(), true, false);
        XYPlot xyplot = plot.getXYPlot();
        NumberAxis yaxis = (NumberAxis)xyplot.getRangeAxis();
        yaxis.setTickUnit(new NumberTickUnit(5.0));
        StatcatoChartFrame frame = new StatcatoChartFrame(this.TitleTextField.getText(), plot, this.app);
        frame.pack();
        frame.setVisible(true);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

