/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.graph;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.jfree.chart.JFreeChart;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.graph.GraphFactory;
import org.statcato.graph.StatcatoChartFrame;
import org.statcato.spreadsheet.Cell;
import org.statcato.utils.HelperFunctions;
import org.statcato.utils.NumDataset;

public class BoxPlotDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JComboBox GroupByComboBox;
    private JRadioButton HorizontalRadioButton;
    private JList InputVarList;
    private JCheckBox LegendCheckBox;
    private JButton OKButton;
    private JTextField TitleTextField;
    private JRadioButton VerticalRadioButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextField xTextField;
    private JTextField yTextField;

    public BoxPlotDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.app = app;
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.initComponents();
        ButtonGroup group = new ButtonGroup();
        group.add(this.HorizontalRadioButton);
        group.add(this.VerticalRadioButton);
        this.ParentSpreadsheet.populateColumnsList(this.InputVarList);
        this.ParentSpreadsheet.populateComboBox(this.GroupByComboBox);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("graph-boxplot");
        this.name = "Box Plot";
        this.description = "For creating a box plot showing five-number summaries of a group of data values.";
        this.helpStrings.add("Select the column variable(s) containing data values for which the plot will be created. A separate box is used with each column variable.");
        this.helpStrings.add("Enter the plot title and labels for the x and y axes.");
        this.helpStrings.add("Select the orientation of the plot (horizontal or vertical).  Select whether to show a legend indicating the different groups.");
        this.pack();
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.GroupByComboBox);
        this.updateColumnsList(this.InputVarList);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.InputVarList = new JList();
        this.GroupByComboBox = new JComboBox();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.LegendCheckBox = new JCheckBox();
        this.TitleTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.HorizontalRadioButton = new JRadioButton();
        this.VerticalRadioButton = new JRadioButton();
        this.jLabel6 = new JLabel();
        this.xTextField = new JTextField();
        this.jLabel7 = new JLabel();
        this.yTextField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Box Plot");
        this.setMinimumSize(new Dimension(200, 350));
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BoxPlotDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BoxPlotDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Graph Variables"));
        this.jLabel4.setText("Grouped By Categories in: [optional]");
        this.jLabel2.setText("Ctrl-click to select multiple variables");
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Graph Variables:");
        this.jScrollPane1.setViewportView(this.InputVarList);
        this.GroupByComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BoxPlotDialog.this.GroupByComboBoxItemStateChanged(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 120, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.GroupByComboBox, -2, 113, -2))).addContainerGap(39, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 118, -2).addGap(18, 18, 18).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.GroupByComboBox, -2, -1, -2).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Graph Options"));
        this.jLabel3.setText("Plot Title:");
        this.LegendCheckBox.setText("Show Legend");
        this.TitleTextField.setText("Box Plot");
        this.jLabel5.setText("Orientation:");
        this.HorizontalRadioButton.setText("Horizontal");
        this.VerticalRadioButton.setSelected(true);
        this.VerticalRadioButton.setText("Vertical");
        this.jLabel6.setText("X-axis Label:");
        this.jLabel7.setText("Y-axis Label:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jLabel6).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.xTextField, -2, 210, -2).addComponent(this.yTextField, -2, 210, -2).addComponent(this.TitleTextField, GroupLayout.Alignment.TRAILING, -2, 210, -2))).addGroup(jPanel2Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.VerticalRadioButton).addComponent(this.HorizontalRadioButton).addComponent(this.jLabel5).addComponent(this.LegendCheckBox)))).addContainerGap()));
        jPanel2Layout.linkSize(0, this.TitleTextField, this.xTextField, this.yTextField);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap(45, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.TitleTextField, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.xTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.yTextField, -2, -1, -2).addComponent(this.jLabel7)).addGap(18, 18, 18).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.HorizontalRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.VerticalRadioButton).addGap(14, 14, 14).addComponent(this.LegendCheckBox).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(220, 220, 220).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton))).addContainerGap()));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -2, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addGap(23, 23, 23)));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("box plot");
        Object[] SelectedColumns = this.InputVarList.getSelectedValues();
        int[] columnNumbers = this.ParentSpreadsheet.convertColumnLabelsToNumbers(SelectedColumns);
        if (columnNumbers.length == 0) {
            this.app.showErrorDialog("Select at least one input variable.");
            return;
        }
        String text = "";
        String byVarLabel = this.GroupByComboBox.getSelectedItem().toString();
        int byVarColNum = -1;
        Vector<Cell> byVarColVector = null;
        boolean hasByVar = false;
        if (!byVarLabel.equals("")) {
            text = text + "Group By variable: " + byVarLabel + "<br>";
            hasByVar = true;
            byVarColNum = this.ParentSpreadsheet.parseColumnNumber(byVarLabel);
            byVarColVector = this.ParentSpreadsheet.getColumn(byVarColNum);
            byVarColVector = HelperFunctions.removeNullCells(byVarColVector);
        }
        text = text + "Graph variables: ";
        NumDataset dataset = new NumDataset();
        text = text + "Graph variables: ";
        for (int i = 0; i < columnNumbers.length; ++i) {
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(columnNumbers[i]);
            String columnLabel = (String)SelectedColumns[i];
            text = text + columnLabel + " ";
            Vector<Double> ColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if ((ColumnVector = HelperFunctions.removeNullValues(ColumnVector)) == null) {
                this.app.showErrorDialog("Invalid input column " + columnLabel + ": all data must be numbers.");
                return;
            }
            if (hasByVar) {
                if (ColumnVector.size() != byVarColVector.size()) {
                    this.app.showErrorDialog("There must be one category label for each data value.");
                    return;
                }
                dataset.addDataVectorWithByVarLabels(ColumnVector, byVarColVector);
                continue;
            }
            dataset.add(ColumnVector, columnLabel);
        }
        DefaultBoxAndWhiskerCategoryDataset boxDataset = new DefaultBoxAndWhiskerCategoryDataset();
        Vector<Vector<Double>> data = dataset.getValues();
        Vector<String> labels = dataset.getLabels();
        for (int i = 0; i < data.size(); ++i) {
            boxDataset.add(data.elementAt(i), (Comparable)((Object)labels.elementAt(i)), (Comparable)((Object)""));
        }
        JFreeChart chart = GraphFactory.createBoxPlot(boxDataset, this.TitleTextField.getText(), this.xTextField.getText(), this.yTextField.getText(), this.LegendCheckBox.isSelected(), this.HorizontalRadioButton.isSelected());
        this.app.addLogParagraph("box plot", text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        StatcatoChartFrame frame = new StatcatoChartFrame(this.TitleTextField.getText(), chart, this.app);
        frame.pack();
        frame.setVisible(true);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void GroupByComboBoxItemStateChanged(ItemEvent evt) {
        if (this.GroupByComboBox.getSelectedItem() != null) {
            if (this.GroupByComboBox.getSelectedItem().toString().equals("")) {
                this.LegendCheckBox.setSelected(false);
            } else {
                this.LegendCheckBox.setSelected(true);
            }
        }
    }
}

