/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.data;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.random.UniformSample;

public class UniformSampleDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JTextField MaxTextField;
    private JTextField MinTextField;
    private JButton OKButton;
    private JTextField SeedTextField;
    private JTextField StoreTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField nTextField;

    public UniformSampleDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.app = app;
        this.initComponents();
        this.customInitComponents();
        this.setHelpFile("data-random-uniform");
        this.name = "Random Uniformly Distributed Samples";
        this.description = "For generating random samples from a range of uniformly distributed continuous values.";
        this.helpStrings.add("Specify the column name(s) in which samples will be stored, the sample size, and the minimum and maximum values of the range of possible values.");
    }

    public void customInitComponents() {
        this.getRootPane().setDefaultButton(this.OKButton);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.StoreTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jPanel2 = new JPanel();
        this.MaxTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.nTextField = new JTextField();
        this.jLabel9 = new JLabel();
        this.jLabel1 = new JLabel();
        this.MinTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.SeedTextField = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabel4 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Random Uniformly Distributed Samples");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UniformSampleDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UniformSampleDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Results"));
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText("Store Samples in:");
        this.jLabel5.setText("<html>\n- Enter valid column names separated by space.<br>\nFor a continuous range of columns, separate using dash (e.g. C1-C30).<br>\n- The random sampling process is repeated for each column.\n</html>\n");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.StoreTextField, -2, 218, -2)).addComponent(this.jLabel5, -2, -1, -2)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.StoreTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5, -2, -1, -2).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Options"));
        this.jLabel2.setText("for each column");
        this.jLabel9.setText("(exclusive)");
        this.jLabel1.setText("Number of Samples to Generate:");
        this.jLabel6.setText("Minimum:");
        this.jLabel7.setText("Maximum:");
        this.jLabel8.setText("(inclusive)");
        this.jLabel4.setText("Random Generator Seed (optional):");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.MaxTextField).addComponent(this.MinTextField, -2, 60, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.jLabel8))).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nTextField, -2, 68, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SeedTextField, -2, 77, -2).addComponent(this.jLabel2)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.nTextField, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.MinTextField, -2, -1, -2).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.MaxTextField, -2, -1, -2).addComponent(this.jLabel9)).addGap(56, 56, 56).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.SeedTextField, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(125, 125, 125).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton))).addGap(0, 10, Short.MAX_VALUE)).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addContainerGap()));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        String StoreColumn;
        Vector<Integer> nums;
        this.app.compoundEdit = new DialogEdit("uniform samples");
        int n = 0;
        double min = 0.0;
        double max = 0.0;
        try {
            n = Integer.parseInt(this.nTextField.getText());
            if (n <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a valid sample size.");
            return;
        }
        try {
            min = Double.parseDouble(this.MinTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a valid minimum value.");
            return;
        }
        try {
            max = Double.parseDouble(this.MaxTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a valid maximum value.");
            return;
        }
        if (min > max) {
            double temp = max;
            max = min;
            min = temp;
        }
        if ((nums = this.ParentSpreadsheet.getColumnNumbersFromString(StoreColumn = this.StoreTextField.getText())) == null) {
            this.app.showErrorDialog("Invalid column(s) for storing results.");
            return;
        }
        for (int i = 0; i < nums.size(); ++i) {
            int storeColumnNum = nums.elementAt(i);
            UniformSample sampler = new UniformSample(min, max);
            try {
                long seed = Long.parseLong(this.SeedTextField.getText());
                sampler.setSeed(seed);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            Vector<String> results = new Vector<String>();
            for (int j = 0; j < n; ++j) {
                double sample = sampler.nextSample();
                results.addElement(sample + "");
            }
            this.ParentSpreadsheet.setColumn(storeColumnNum, results);
        }
        this.app.addLogParagraph("Uniform Samples [" + min + ", " + max + ")", n + " samples stored in each of " + StoreColumn);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

