/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.data;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.BasicStatistics;
import org.statcato.utils.HelperFunctions;

public class StandardizeDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JRadioButton DefaultRadioButton;
    private JTextField DivideTextField;
    private JTextField FromTextField;
    private JTextField InputTextField;
    private JButton OKButton;
    private JTextField OutputTextField;
    private JRadioButton RangeRadioButton;
    private JRadioButton SubtractDivideRadioButton;
    private JTextField SubtractTextField;
    private JTextField ToTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;

    public StandardizeDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.app = app;
        this.initComponents();
        ButtonGroup group = new ButtonGroup();
        group.add(this.DefaultRadioButton);
        group.add(this.SubtractDivideRadioButton);
        group.add(this.RangeRadioButton);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("data-standardize");
        this.name = "Standardize";
        this.description = "For performing data transformation on columns of data, including scaling and moving the center of data in a column, as well as adjusting the range of the data .";
        this.helpStrings.add("Enter the names of the input columns and output columns.");
        this.helpStrings.add("Select the method of standardization.");
    }

    @Override
    public void updateElements() {
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel2 = new JLabel();
        this.InputTextField = new JTextField();
        this.OutputTextField = new JTextField();
        this.jLabel8 = new JLabel();
        this.jPanel2 = new JPanel();
        this.FromTextField = new JTextField();
        this.DefaultRadioButton = new JRadioButton();
        this.RangeRadioButton = new JRadioButton();
        this.jLabel5 = new JLabel();
        this.jLabel4 = new JLabel();
        this.SubtractTextField = new JTextField();
        this.ToTextField = new JTextField();
        this.DivideTextField = new JTextField();
        this.SubtractDivideRadioButton = new JRadioButton();
        this.jLabel3 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Standardize");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StandardizeDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StandardizeDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs and Outputs"));
        this.jLabel1.setText("Input Column(s):");
        this.jLabel6.setText("<html>\nThe number of input columns must be the same as <br>the number of columns for storing results.\n</html>");
        this.jLabel2.setText("Store results in column(s):");
        this.jLabel8.setText("<html>\nEnter valid column names separated by space.<br>\nFor a continuous range of columns, separate using dash (e.g. C1-C30).<br>\n</html>\n");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.InputTextField, -2, 147, -2))).addGap(69, 69, 69).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.OutputTextField, -2, 149, -2).addComponent(this.jLabel2))).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel8)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6, -2, 356, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.InputTextField, -2, -1, -2).addComponent(this.OutputTextField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6, -1, 51, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Options"));
        this.FromTextField.setEnabled(false);
        this.DefaultRadioButton.setSelected(true);
        this.DefaultRadioButton.setText("Subtract mean and divide by standard deviation (z-score)");
        this.RangeRadioButton.setText("Make range ");
        this.RangeRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                StandardizeDialog.this.RangeRadioButtonStateChanged(evt);
            }
        });
        this.jLabel5.setText("To:");
        this.jLabel4.setText("From:");
        this.SubtractTextField.setEnabled(false);
        this.ToTextField.setEnabled(false);
        this.DivideTextField.setEnabled(false);
        this.SubtractDivideRadioButton.setText("Subtract");
        this.SubtractDivideRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                StandardizeDialog.this.SubtractDivideRadioButtonStateChanged(evt);
            }
        });
        this.jLabel3.setText("Then divide by");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.RangeRadioButton).addComponent(this.SubtractDivideRadioButton).addComponent(this.DefaultRadioButton).addGroup(jPanel2Layout.createSequentialGroup().addGap(37, 37, 37).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.FromTextField).addComponent(this.ToTextField, -2, 108, -2))).addGroup(jPanel2Layout.createSequentialGroup().addGap(35, 35, 35).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.SubtractTextField, -2, 98, -2).addComponent(this.DivideTextField, -2, 99, -2))).addGroup(jPanel2Layout.createSequentialGroup().addGap(23, 23, 23).addComponent(this.jLabel3))).addContainerGap(78, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.DefaultRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SubtractDivideRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SubtractTextField, -2, -1, -2).addGap(11, 11, 11).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.DivideTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.RangeRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.FromTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.ToTextField, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGap(127, 127, 127).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jPanel1, -2, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.CancelButton).addComponent(this.OKButton)).addContainerGap()));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        int[] storeColumnNumbers;
        this.app.compoundEdit = new DialogEdit("standardize");
        int[] inputColumnNumbers = this.ParentSpreadsheet.getColumnNumbersArrayFromString(this.InputTextField.getText());
        if (inputColumnNumbers.length != (storeColumnNumbers = this.ParentSpreadsheet.getColumnNumbersArrayFromString(this.OutputTextField.getText())).length) {
            this.app.showErrorDialog("The number of input columns must be the same as the number of columns for storing results.");
            return;
        }
        String heading = "";
        String text = "";
        for (int i = 0; i < inputColumnNumbers.length; ++i) {
            Vector<Double> ResultVector;
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(inputColumnNumbers[i]);
            String columnLabel = this.ParentSpreadsheet.getColumnFullLabel(inputColumnNumbers[i]);
            heading = heading + "Standardize " + columnLabel + " -> " + this.ParentSpreadsheet.getColumnFullLabel(storeColumnNumbers[i]);
            Vector<Double> ColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (ColumnVector == null) {
                this.app.showErrorDialog("Invalid input column " + columnLabel + ": all data must be numbers.");
                return;
            }
            if (this.DefaultRadioButton.isSelected()) {
                ResultVector = BasicStatistics.standardize(ColumnVector);
                if (ResultVector == null) {
                    this.app.showErrorDialog("Cannot standardize column " + columnLabel);
                    return;
                }
                this.ParentSpreadsheet.setColumn(storeColumnNumbers[i], HelperFunctions.ConvertDoubleVectorToString(ResultVector));
                text = text + "subtract mean and divide by standard deviation";
                continue;
            }
            if (this.SubtractDivideRadioButton.isSelected()) {
                try {
                    double num1 = Double.parseDouble(this.SubtractTextField.getText());
                    double num2 = Double.parseDouble(this.DivideTextField.getText());
                    if (num2 == 0.0) {
                        this.app.showErrorDialog("Cannot divide by 0");
                        return;
                    }
                    ResultVector = BasicStatistics.customStandardize(ColumnVector, num1, num2);
                    this.ParentSpreadsheet.setColumn(storeColumnNumbers[i], HelperFunctions.ConvertDoubleVectorToString(ResultVector));
                    text = text + "subtract " + num1 + " and divide by " + num2;
                    continue;
                }
                catch (NumberFormatException e) {
                    this.app.showErrorDialog("Enter valid numbers for subtraction and division.");
                    return;
                }
            }
            if (!this.RangeRadioButton.isSelected()) continue;
            try {
                double a = Double.parseDouble(this.FromTextField.getText());
                double b = Double.parseDouble(this.ToTextField.getText());
                if (b <= a) {
                    this.app.showErrorDialog("The specified range is not valid--the upper bound must be greater than the lower bound.");
                    return;
                }
                ResultVector = BasicStatistics.changeRange(ColumnVector, a, b);
                if (ResultVector == null) {
                    this.app.showErrorDialog("Cannot standardize column " + columnLabel);
                    return;
                }
                this.ParentSpreadsheet.setColumn(storeColumnNumbers[i], HelperFunctions.ConvertDoubleVectorToString(ResultVector));
                text = text + "set range from " + a + " to " + b;
                continue;
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter valid bounds for the range.");
                return;
            }
        }
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void SubtractDivideRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SubtractDivideRadioButton.isSelected()) {
            this.SubtractTextField.setEnabled(true);
            this.DivideTextField.setEnabled(true);
        } else {
            this.SubtractTextField.setEnabled(false);
            this.DivideTextField.setEnabled(false);
        }
    }

    private void RangeRadioButtonStateChanged(ChangeEvent evt) {
        if (this.RangeRadioButton.isSelected()) {
            this.FromTextField.setEnabled(true);
            this.ToTextField.setEnabled(true);
        } else {
            this.FromTextField.setEnabled(false);
            this.ToTextField.setEnabled(false);
        }
    }
}

