/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.data;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;

public class SimpleNumberPatternDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JTextField EndTextField;
    private JButton OKButton;
    private JTextField RepeatItemTextField;
    private JTextField RepeatSeqTextField;
    private JTextField StartTextField;
    private JTextField StepTextField;
    private JTextField StoreTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;

    public SimpleNumberPatternDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.app = app;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("data-number-sequence");
        this.name = "Simple Number Sequence";
        this.description = "For generating a simple number sequence.";
        this.helpStrings.add("Provide the column(s) in which the results will be stored.");
        this.helpStrings.add("Specify the first and last value of the sequence, the step size, the number of times a value is repeated, and the number of times the whole sequence of values is repeated.");
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.StoreTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel2 = new JLabel();
        this.RepeatSeqTextField = new JTextField();
        this.RepeatItemTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.StartTextField = new JTextField();
        this.EndTextField = new JTextField();
        this.StepTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel3 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Simple Number Sequence");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleNumberPatternDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleNumberPatternDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Results"));
        this.jLabel1.setText("Store number pattern in:");
        this.jLabel7.setText("<html>\n- Enter valid column names separated by space.<br>\nFor a continuous range of columns, separate using dash (e.g. C1-C30).<br>\n- The random sampling process is repeated for each column.\n</html>\n");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(14, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.StoreTextField, -2, 177, -2)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.StoreTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Options"));
        this.jLabel4.setText("In steps of:");
        this.jLabel2.setText("From first number:");
        this.RepeatSeqTextField.setText("1");
        this.RepeatItemTextField.setText("1");
        this.jLabel5.setText("Number of times to list each number:");
        this.StepTextField.setText("1");
        this.jLabel6.setText("Number of times to list each sequence:");
        this.jLabel3.setText("To last number:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.RepeatItemTextField, -2, 68, -2).addComponent(this.RepeatSeqTextField, -2, 66, -2))).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4)).addGap(4, 4, 4).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.StepTextField).addComponent(this.EndTextField).addComponent(this.StartTextField, -2, 92, -2)))).addContainerGap()));
        jPanel2Layout.linkSize(0, this.RepeatItemTextField, this.RepeatSeqTextField);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.StartTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.EndTextField, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.StepTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.RepeatItemTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.RepeatSeqTextField, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(119, 119, 119).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -2, 369, Short.MAX_VALUE)))).addContainerGap()));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jPanel2, -2, -1, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.CancelButton).addComponent(this.OKButton)).addContainerGap()));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("number pattern");
        String StoreColumn = this.StoreTextField.getText();
        double first = 0.0;
        try {
            first = Double.parseDouble(this.StartTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a valid number for the first value.");
            return;
        }
        double last = 0.0;
        try {
            last = Double.parseDouble(this.EndTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a valid number for the last value.");
            return;
        }
        double step = 0.0;
        try {
            step = Double.parseDouble(this.StepTextField.getText());
            if (step == 0.0) {
                this.app.showErrorDialog("Step must be non-zero");
                return;
            }
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a valid number for step.");
            return;
        }
        int repeatNum = 0;
        try {
            repeatNum = Integer.parseInt(this.RepeatItemTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter an integer for the number of repetitions for each value.");
            return;
        }
        int repeatSeq = 0;
        try {
            repeatSeq = Integer.parseInt(this.RepeatSeqTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter an integer for the number of repetitions for the number pattern.");
            return;
        }
        Vector<String> Pattern = new Vector<String>();
        for (int seq = 0; seq < repeatSeq; ++seq) {
            int k;
            double num;
            if (first <= last) {
                if (step < 0.0) {
                    step = -step;
                }
                for (num = first; num <= last; num += step) {
                    for (k = 0; k < repeatNum; ++k) {
                        Pattern.addElement(num + "");
                    }
                }
                continue;
            }
            if (step > 0.0) {
                step = -step;
            }
            for (num = first; num >= last; num += step) {
                for (k = 0; k < repeatNum; ++k) {
                    Pattern.addElement(num + "");
                }
            }
        }
        Vector<Integer> nums = this.ParentSpreadsheet.getColumnNumbersFromString(StoreColumn);
        if (nums == null) {
            this.app.showErrorDialog("Invalid column(s) for storing results.");
            return;
        }
        for (int i = 0; i < nums.size(); ++i) {
            this.ParentSpreadsheet.setColumn(nums.elementAt(i), Pattern);
        }
        this.app.addLogParagraph("Generate Simple Number Sequence in " + StoreColumn, "First: " + first + " - Last: " + last + "<br>" + "Step size: " + step + "<br>" + "Number of times to list each number: " + repeatNum + "<br>" + "Number of times to list each sequence: " + repeatSeq);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

