/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.calc.probdist;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.GeometricProbabilityDistribution;
import org.statcato.utils.HelperFunctions;

public class GeometricDistributionDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JComboBox ColumnComboBox;
    private JRadioButton ColumnRadioButton;
    private JRadioButton ConstRadioButton;
    private JTextField ConstTextField;
    private JRadioButton CumProbRadioButton;
    private JRadioButton InvCumProbRadioButton;
    private JButton OKButton;
    private JRadioButton ProbDensityRadioButton;
    private JTextField StoreTextField;
    private JRadioButton Type1RadioButton;
    private JRadioButton Type2RadioButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField pTextField;

    public GeometricDistributionDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.app = app;
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.initComponents();
        ButtonGroup group0 = new ButtonGroup();
        group0.add(this.Type1RadioButton);
        group0.add(this.Type2RadioButton);
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.ProbDensityRadioButton);
        group1.add(this.CumProbRadioButton);
        group1.add(this.InvCumProbRadioButton);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.ConstRadioButton);
        group2.add(this.ColumnRadioButton);
        this.ParentSpreadsheet.populateComboBox(this.ColumnComboBox);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("calc-geometric");
        this.name = "Geometric Probability Distribution";
        this.description = "For calculations on geometric probability distribution.";
        this.helpStrings.add("Enter a number between 0 and 1 for the success probability.");
        this.helpStrings.add("Choose probability density for P(x), cumulative probability for (P(<= x), and inverse cumulative probability for finding x given a such that P(<= x) = a.");
        this.helpStrings.add("Inputs can be numbers within a column or a single constant.");
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.ColumnComboBox);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.Type1RadioButton = new JRadioButton();
        this.pTextField = new JTextField();
        this.ProbDensityRadioButton = new JRadioButton();
        this.InvCumProbRadioButton = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.Type2RadioButton = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.CumProbRadioButton = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.StoreTextField = new JTextField();
        this.ColumnComboBox = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.ConstRadioButton = new JRadioButton();
        this.ConstTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.ColumnRadioButton = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Geometric Probability Distribution");
        this.OKButton.setText("Compute");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeometricDistributionDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Close");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeometricDistributionDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Distribution"));
        this.Type1RadioButton.setSelected(true);
        this.Type1RadioButton.setText("Model the number of trials needed to produce the first success");
        this.ProbDensityRadioButton.setSelected(true);
        this.ProbDensityRadioButton.setText("Probability density");
        this.InvCumProbRadioButton.setText("Inverse cumulative probability");
        this.jLabel4.setFont(new Font("Tahoma", 1, 11));
        this.jLabel4.setText("Compute:");
        this.Type2RadioButton.setText("Model the number of failures before the first success");
        this.jLabel2.setText("Success probability:");
        this.CumProbRadioButton.setText("Cumulative probability");
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Distribution Parameters:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(jPanel1Layout.createSequentialGroup().addGap(9, 9, 9).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.CumProbRadioButton, GroupLayout.Alignment.LEADING).addComponent(this.ProbDensityRadioButton, GroupLayout.Alignment.LEADING).addComponent(this.InvCumProbRadioButton, GroupLayout.Alignment.LEADING))).addGroup(jPanel1Layout.createSequentialGroup().addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addGap(9, 9, 9).addComponent(this.pTextField, -2, 91, -2)).addComponent(this.Type2RadioButton).addComponent(this.Type1RadioButton))).addComponent(this.jLabel4)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.pTextField, -2, -1, -2)).addGap(21, 21, 21).addComponent(this.Type1RadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.Type2RadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ProbDensityRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CumProbRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.InvCumProbRadioButton).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Inputs and Outputs"));
        this.jLabel6.setFont(new Font("Tahoma", 1, 11));
        this.jLabel6.setText("Store Results in: (optional)");
        this.jLabel7.setText("(e.g. C1 for column label, or variable name)");
        this.ConstRadioButton.setText("Constant:");
        this.ConstRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GeometricDistributionDialog.this.ConstRadioButtonStateChanged(evt);
            }
        });
        this.ConstTextField.setEnabled(false);
        this.jLabel5.setFont(new Font("Tahoma", 1, 11));
        this.jLabel5.setText("Input(s):");
        this.ColumnRadioButton.setSelected(true);
        this.ColumnRadioButton.setText("Column:");
        this.ColumnRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GeometricDistributionDialog.this.ColumnRadioButtonStateChanged(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(9, 9, 9).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.ConstRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ConstTextField)).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.ColumnRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ColumnComboBox, -2, 109, -2)))).addGroup(jPanel2Layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.StoreTextField, -2, 105, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7)).addComponent(this.jLabel5).addComponent(this.jLabel6)).addContainerGap(20, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ColumnRadioButton).addComponent(this.ColumnComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ConstRadioButton).addComponent(this.ConstTextField, -2, -1, -2)).addGap(20, 20, 20).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.StoreTextField, -2, -1, -2).addComponent(this.jLabel7)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGap(99, 99, 99).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.CancelButton))).addContainerGap(18, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addGap(20, 20, 20)));
        this.pack();
    }

    private void ConstRadioButtonStateChanged(ChangeEvent evt) {
        if (this.ConstRadioButton.isSelected()) {
            this.ColumnComboBox.setEnabled(false);
            this.ConstTextField.setEnabled(true);
        } else {
            this.ColumnComboBox.setEnabled(true);
            this.ConstTextField.setEnabled(false);
        }
    }

    private void ColumnRadioButtonStateChanged(ChangeEvent evt) {
        if (this.ColumnRadioButton.isSelected()) {
            this.ColumnComboBox.setEnabled(true);
            this.ConstTextField.setEnabled(false);
        } else {
            this.ColumnComboBox.setEnabled(false);
            this.ConstTextField.setEnabled(true);
        }
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        Double elm;
        this.app.compoundEdit = new DialogEdit("geometric distribution");
        double p = 0.0;
        String heading = "Geometric Distribution: ";
        String text = "";
        try {
            p = Double.parseDouble(this.pTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a valid number for the success probability.");
            return;
        }
        if (p <= 0.0 || p >= 1.0) {
            this.app.showErrorDialog("The success probability must be between 0 and 1.");
            return;
        }
        heading = heading + "p=" + p;
        Vector<Object> ColumnVector = new Vector<Double>();
        if (this.ColumnRadioButton.isSelected()) {
            String columnLabel = this.ColumnComboBox.getSelectedItem().toString();
            if (columnLabel.equals("")) {
                this.app.showErrorDialog("Select the input column.");
                return;
            }
            int column = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(column);
            ColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (ColumnVector == null) {
                this.app.showErrorDialog("Invalid input column " + columnLabel + ": all data must be numbers.");
                return;
            }
            text = text + "Input: " + columnLabel + "<br>";
        } else {
            try {
                double num = Double.parseDouble(this.ConstTextField.getText());
                ColumnVector.addElement(num);
                text = text + "Input: " + num + "<br>";
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Invalid constant input.  Enter a valid number.");
                return;
            }
        }
        GeometricProbabilityDistribution npd = null;
        npd = this.Type1RadioButton.isSelected() ? new GeometricProbabilityDistribution(p, GeometricProbabilityDistribution.TYPEI) : new GeometricProbabilityDistribution(p, GeometricProbabilityDistribution.TYPEII);
        Vector<String> ResultVector = new Vector<String>();
        if (this.ProbDensityRadioButton.isSelected()) {
            text = text + "Type: Probability density<br>";
            text = text + "<table>";
            text = text + "<tr><td>X</td><td>P(X)</td></tr>";
            for (int i = 0; i < ColumnVector.size(); ++i) {
                elm = (Double)ColumnVector.elementAt(i);
                if (elm == null) continue;
                double x = elm;
                double density = npd.density(x);
                text = text + "<tr><td>" + x + "</td><td>" + HelperFunctions.formatFloat(density, 6) + "</td></tr>";
                ResultVector.addElement(density + "");
            }
            text = text + "</table>";
        } else if (this.CumProbRadioButton.isSelected()) {
            text = text + "Type: Cumulative probability<br>";
            text = text + "<table>";
            text = text + "<tr><td>X</td><td>P(<&lt;=X)</td></tr>";
            for (int i = 0; i < ColumnVector.size(); ++i) {
                elm = (Double)ColumnVector.elementAt(i);
                if (elm == null) continue;
                double x = elm;
                double density = npd.cumulativeProbability(x);
                text = text + "<tr><td>" + x + "</td><td>" + HelperFunctions.formatFloat(density, 6) + "</td></tr>";
                ResultVector.addElement(density + "");
            }
            text = text + "</table>";
        } else if (this.InvCumProbRadioButton.isSelected()) {
            text = text + "Type: Inverse cumulative probability<br>";
            text = text + "<table>";
            text = text + "<tr><td>P(<&lt;=X)</td><td>X</td></tr>";
            for (int i = 0; i < ColumnVector.size(); ++i) {
                elm = (Double)ColumnVector.elementAt(i);
                if (elm == null) continue;
                double area = elm;
                Double x = npd.inverseCumulativeProbability(area);
                if (x.equals(Double.NaN)) {
                    text = text + "<tr><td>" + area + "</td><td>" + "*" + "</td></tr>";
                    ResultVector.addElement(x + "");
                    continue;
                }
                text = text + "<tr><td>" + area + "</td><td>" + (int)x.doubleValue() + "</td></tr>";
                ResultVector.addElement((int)x.doubleValue() + "");
            }
            text = text + "</table>";
        }
        String storeColumn = this.StoreTextField.getText();
        if (!storeColumn.equals("")) {
            int storeColumnNum = this.ParentSpreadsheet.getColumnNumber(storeColumn);
            if (storeColumnNum == -1) {
                this.app.showErrorDialog("Enter a valid column name (e.g. C1) or a valid variable name to store the results.");
                return;
            }
            this.ParentSpreadsheet.setColumn(storeColumnNum, ResultVector);
        }
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

