/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.calc;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.BasicStatistics;
import org.statcato.utils.HelperFunctions;

public class FrequencyTableDialog
extends StatcatoDialog {
    private JRadioButton AutoRadioButton;
    private JButton CancelButton;
    private JRadioButton CatRadioButton;
    private JTextField CategoryTextField;
    private JRadioButton Class2RadioButton;
    private JRadioButton ClassRadioButton;
    private JTextField ClassWidthTextField;
    private JTextField FirstLimitTextField;
    private JTextField FrequencyTextField;
    private JComboBox LimitComboBox;
    private JTextField NumClassTextField;
    private JButton OKButton;
    private JComboBox SourceComboBox;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;

    public FrequencyTableDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.app = app;
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.initComponents();
        this.customInitComponents();
    }

    private void customInitComponents() {
        this.ParentSpreadsheet.populateComboBox(this.SourceComboBox);
        this.ParentSpreadsheet.populateComboBox(this.LimitComboBox);
        ButtonGroup group = new ButtonGroup();
        group.add(this.CatRadioButton);
        group.add(this.ClassRadioButton);
        group.add(this.Class2RadioButton);
        group.add(this.AutoRadioButton);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("calc-freqtable");
        this.name = "Frequency Table";
        this.description = "For computing frqeuencies of data values.";
        this.helpStrings.add("Select the column containing data for which frequencies will be computed.");
        this.helpStrings.add("Select the method for computing frequency data.");
        this.helpStrings.add("Select the columns in which the frequency results are to be stored.");
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.SourceComboBox);
        this.updateComboBox(this.LimitComboBox);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.SourceComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.NumClassTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.Class2RadioButton = new JRadioButton();
        this.jLabel11 = new JLabel();
        this.FirstLimitTextField = new JTextField();
        this.ClassWidthTextField = new JTextField();
        this.CatRadioButton = new JRadioButton();
        this.LimitComboBox = new JComboBox();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.ClassRadioButton = new JRadioButton();
        this.jLabel8 = new JLabel();
        this.AutoRadioButton = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.FrequencyTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel5 = new JLabel();
        this.CategoryTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel7 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Compute Frequency Table");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrequencyTableDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrequencyTableDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Input"));
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText("Source Data");
        this.jLabel1.setText("Compute frequency data for column:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel3))).addGroup(jPanel1Layout.createSequentialGroup().addGap(33, 33, 33).addComponent(this.SourceComboBox, -2, 119, -2))).addContainerGap(16, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SourceComboBox, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Computing Frequencies"));
        this.NumClassTextField.setEnabled(false);
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setText("Method of Computing Frequencies");
        this.Class2RadioButton.setText("Source data contains numerical data.");
        this.Class2RadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrequencyTableDialog.this.Class2RadioButtonStateChanged(evt);
            }
        });
        this.jLabel11.setText("(optional)");
        this.FirstLimitTextField.setEnabled(false);
        this.ClassWidthTextField.setEnabled(false);
        this.CatRadioButton.setText("Treat source data as categories.  Count the frequency of each category.");
        this.CatRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FrequencyTableDialog.this.CatRadioButtonItemStateChanged(evt);
            }
        });
        this.LimitComboBox.setEnabled(false);
        this.jLabel9.setText("Class width:");
        this.jLabel10.setText("Number of classes:");
        this.ClassRadioButton.setText("<html>Source data contains numerical data.  Count the frequency of each class, <br>where the upper class limits are in column:</html>");
        this.ClassRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FrequencyTableDialog.this.ClassRadioButtonItemStateChanged(evt);
            }
        });
        this.jLabel8.setText("First upper class limit:");
        this.AutoRadioButton.setSelected(true);
        this.AutoRadioButton.setText("<html>Source data contains numerical data.  Automatically use 10 classes, <br>with the first lower class limit decided by the minimum value.\n");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ClassRadioButton, -2, 387, -2).addComponent(this.AutoRadioButton, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.CatRadioButton).addComponent(this.Class2RadioButton).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.jLabel8)).addGroup(jPanel2Layout.createSequentialGroup().addGap(45, 45, 45).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel9).addComponent(this.jLabel10)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.FirstLimitTextField).addComponent(this.ClassWidthTextField).addComponent(this.NumClassTextField, -1, 56, Short.MAX_VALUE)).addGap(10, 10, 10).addComponent(this.jLabel11)))).addGroup(jPanel2Layout.createSequentialGroup().addGap(68, 68, 68).addComponent(this.LimitComboBox, -2, 122, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CatRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ClassRadioButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.LimitComboBox, -2, -1, -2).addGap(3, 3, 3).addComponent(this.Class2RadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.FirstLimitTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.ClassWidthTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.NumClassTextField, -2, -1, -2).addComponent(this.jLabel11)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.AutoRadioButton, -2, -1, -2).addContainerGap(19, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Results"));
        this.jLabel6.setText("Frequency column:");
        this.jLabel5.setText("Category column:");
        this.jLabel4.setFont(new Font("Tahoma", 1, 11));
        this.jLabel4.setText("Store Frequency Table in");
        this.jLabel7.setText("e.g. C1 or variable name");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(4, 4, 4).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel6, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.CategoryTextField, -2, 72, -2).addComponent(this.FrequencyTextField, -2, 72, -2))).addComponent(this.jLabel4).addComponent(this.jLabel7, GroupLayout.Alignment.TRAILING)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.CategoryTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.FrequencyTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addContainerGap(79, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton)).addComponent(this.jPanel2, -2, -1, -2)).addContainerGap()));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jPanel2, -2, -1, -2))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addContainerGap()));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("frequency table");
        if (this.SourceComboBox.getSelectedIndex() == 0) {
            this.app.showErrorDialog("Select the column containing the source data.");
            return;
        }
        if (this.ClassRadioButton.isSelected() && this.LimitComboBox.getSelectedIndex() == 0) {
            this.app.showErrorDialog("Select the column containing upper class limits.");
            return;
        }
        String source = this.SourceComboBox.getSelectedItem().toString();
        int sourceColumn = this.ParentSpreadsheet.parseColumnNumber(source);
        String text = "";
        text = text + "Source column: " + source + "<br>";
        Vector<Cell> CellColumnVector = null;
        Vector<Double> ColumnVector = null;
        CellColumnVector = this.ParentSpreadsheet.getColumn(sourceColumn);
        CellColumnVector = HelperFunctions.removeNullCells(CellColumnVector);
        if ((this.ClassRadioButton.isSelected() || this.Class2RadioButton.isSelected() || this.AutoRadioButton.isSelected()) && (ColumnVector = HelperFunctions.ConvertInputVectorToDoubles(CellColumnVector)) == null) {
            this.app.showErrorDialog("Invalid input column " + source + ": all data must be numbers.");
            return;
        }
        String StoreCatColumn = this.CategoryTextField.getText();
        int storeCatColumnNum = this.ParentSpreadsheet.getColumnNumber(StoreCatColumn);
        if (storeCatColumnNum == -1) {
            this.app.showErrorDialog("Enter a valid column name (e.g. C1) or a valid variable name to store the categories of the frequency table.");
            return;
        }
        String StoreFreqColumn = this.FrequencyTextField.getText();
        int storeFreqColumnNum = this.ParentSpreadsheet.getColumnNumber(StoreFreqColumn);
        if (storeFreqColumnNum == -1) {
            this.app.showErrorDialog("Enter a valid column name (e.g. C1) or a valid variable name to store the frequencies of the frequency table.");
            return;
        }
        text = text + "Category column: " + StoreCatColumn + "<br>";
        text = text + "Frequency column: " + StoreFreqColumn;
        if (this.CatRadioButton.isSelected()) {
            Object[] returnValues = HelperFunctions.ComputeCategoryFrequency(CellColumnVector);
            Vector categories = (Vector)returnValues[0];
            Vector frequencies = (Vector)returnValues[1];
            this.ParentSpreadsheet.setCellColumn(storeCatColumnNum, categories);
            this.ParentSpreadsheet.setColumn(storeFreqColumnNum, HelperFunctions.ConvertDoubleVectorToString(frequencies));
        } else if (this.ClassRadioButton.isSelected()) {
            String classes = this.LimitComboBox.getSelectedItem().toString();
            int classesColumn = this.ParentSpreadsheet.parseColumnNumber(classes);
            Vector<Cell> LimitsColumnVector = this.ParentSpreadsheet.getColumn(classesColumn);
            Vector<Double> LimitsVector = HelperFunctions.ConvertInputVectorToDoubles(LimitsColumnVector = HelperFunctions.removeNullCells(LimitsColumnVector));
            if (LimitsVector == null) {
                this.app.showErrorDialog("Invalid input column " + source + " for class limits: all data must be numbers.");
                return;
            }
            Vector<Double> frequencies = HelperFunctions.ComputeClassFrequency(ColumnVector, LimitsVector);
            Vector<String> limits = HelperFunctions.ConvertDoubleVectorToString(LimitsVector);
            limits.addElement("+");
            this.ParentSpreadsheet.setColumn(storeCatColumnNum, limits);
            this.ParentSpreadsheet.setColumn(storeFreqColumnNum, HelperFunctions.ConvertDoubleVectorToString(frequencies));
        } else {
            if (this.Class2RadioButton.isSelected()) {
                try {
                    double limit1 = Double.parseDouble(this.FirstLimitTextField.getText());
                    double width = Double.parseDouble(this.ClassWidthTextField.getText());
                    double max = BasicStatistics.max(ColumnVector);
                    int numClasses = -1;
                    if (!this.NumClassTextField.getText().equals("")) {
                        try {
                            numClasses = Integer.parseInt(this.NumClassTextField.getText());
                            if (numClasses <= 0) {
                                throw new NumberFormatException();
                            }
                        }
                        catch (NumberFormatException e) {
                            this.app.showErrorDialog("Enter a positive integer for the number of classes.");
                            return;
                        }
                    }
                    Vector<Double> LimitsVector = new Vector<Double>();
                    double thisLimit = limit1;
                    int classes = 0;
                    LimitsVector.addElement(thisLimit);
                    ++classes;
                    while (thisLimit < max && (numClasses == -1 || classes < numClasses)) {
                        LimitsVector.addElement(thisLimit += width);
                        ++classes;
                    }
                    Vector<Double> frequencies = HelperFunctions.ComputeClassFrequency(ColumnVector, LimitsVector);
                    frequencies.removeElementAt(frequencies.size() - 1);
                    Vector<String> limits = HelperFunctions.ConvertDoubleVectorToString(LimitsVector);
                    this.ParentSpreadsheet.setColumn(storeCatColumnNum, limits);
                    this.ParentSpreadsheet.setColumn(storeFreqColumnNum, HelperFunctions.ConvertDoubleVectorToString(frequencies));
                }
                catch (NumberFormatException e) {
                    this.app.showErrorDialog("Enter valid numbers for the first upper class limit and the class width.");
                    return;
                }
            }
            double numClasses = 10.0;
            double min = BasicStatistics.min(ColumnVector);
            double max = BasicStatistics.max(ColumnVector);
            double width = (max - min) / numClasses;
            Vector<Double> LimitsVector = new Vector<Double>();
            int i = 1;
            while ((double)i <= numClasses) {
                LimitsVector.addElement(min + (double)i * width);
                ++i;
            }
            Vector<Double> frequencies = HelperFunctions.ComputeClassFrequency(ColumnVector, LimitsVector);
            frequencies.removeElementAt(frequencies.size() - 1);
            Vector<String> limits = HelperFunctions.ConvertDoubleVectorToString(LimitsVector);
            this.ParentSpreadsheet.setColumn(storeCatColumnNum, limits);
            this.ParentSpreadsheet.setColumn(storeFreqColumnNum, HelperFunctions.ConvertDoubleVectorToString(frequencies));
        }
        this.app.addLogParagraph("Frequency Table", text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void CatRadioButtonItemStateChanged(ItemEvent evt) {
        if (this.CatRadioButton.isSelected()) {
            // empty if block
        }
    }

    private void ClassRadioButtonItemStateChanged(ItemEvent evt) {
        if (this.ClassRadioButton.isSelected()) {
            this.LimitComboBox.setEnabled(true);
        } else {
            this.LimitComboBox.setEnabled(false);
        }
    }

    private void Class2RadioButtonStateChanged(ChangeEvent evt) {
        if (this.Class2RadioButton.isSelected()) {
            this.FirstLimitTextField.setEnabled(true);
            this.ClassWidthTextField.setEnabled(true);
            this.NumClassTextField.setEnabled(true);
        } else {
            this.FirstLimitTextField.setEnabled(false);
            this.ClassWidthTextField.setEnabled(false);
            this.NumClassTextField.setEnabled(false);
        }
    }
}

